/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.report.EditorContributor;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.properties.internal.IHighlightPropertyWidget;
import com.jaspersoft.studio.properties.internal.IWidgetsProviderSection;
import com.jaspersoft.studio.properties.internal.WidgetDescriptor;
import com.jaspersoft.studio.properties.view.AdvancedPropertySection;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.JRPropertySheetEntry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class JDAdvancedSection
extends AdvancedPropertySection
implements PropertyChangeListener,
IWidgetsProviderSection {
    private EditDomain editDomain;
    private APropertyNode element;
    private JRPropertySheetEntry rootEntry = null;
    private boolean isRefreshing = false;

    public void createControls(Composite parent, TabbedPropertySheetPage atabbedPropertySheetPage) {
        super.createControls(parent, atabbedPropertySheetPage);
        this.UpdatePageContent(this.getSelectionList(this.getSelection()));
    }

    private void UpdatePageContent(IStructuredSelection selection) {
        if (this.page != null && this.element != null && this.getEditDomain() != null) {
            this.page.selectionChanged(this.getPart(), (ISelection)selection);
            this.disposeRootEntry();
            this.rootEntry = new JRPropertySheetEntry(this.getEditDomain().getCommandStack(), this.element);
            this.page.setRootEntry((IPropertySheetEntry)this.rootEntry);
        }
    }

    private void disposeRootEntry() {
        if (this.rootEntry != null) {
            this.rootEntry.dispose();
            this.rootEntry = null;
        }
    }

    private IStructuredSelection getSelectionList(ISelection currentSelection) {
        ArrayList<APropertyNode> result = new ArrayList<APropertyNode>();
        Assert.isTrue((boolean)(currentSelection instanceof IStructuredSelection));
        IStructuredSelection selectionList = (IStructuredSelection)currentSelection;
        Object[] objectArray = selectionList.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart part;
            Object obj = objectArray[n2];
            if (obj instanceof EditPart && (part = (EditPart)obj).getModel() instanceof APropertyNode) {
                result.add((APropertyNode)part.getModel());
            }
            ++n2;
        }
        return new StructuredSelection(result);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.setPart(part);
        this.setSelection(selection);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            EditorContributor provider = (EditorContributor)part.getAdapter(EditorContributor.class);
            if (provider != null) {
                this.setEditDomain(provider.getEditDomain());
            }
            this.element = null;
            IStructuredSelection selectionList = this.getSelectionList(selection);
            if (!selectionList.isEmpty()) {
                this.element = (APropertyNode)selectionList.getFirstElement();
                this.UpdatePageContent(selectionList);
            }
        }
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public void setEditDomain(EditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        TabbedPropertySheetPage tp = this.getTabbedPropertySheetPage();
        if (tp != null) {
            if (this.getElement() != null) {
                this.getElement().getPropertyChangeSupport().addPropertyChangeListener(this);
            }
            if (tp.getSite() != null) {
                IActionBars actionBars = tp.getSite().getActionBars();
                if (actionBars != null) {
                    actionBars.getToolBarManager().removeAll();
                }
                this.page.makeContributions(actionBars.getMenuManager(), actionBars.getToolBarManager(), actionBars.getStatusLineManager());
                actionBars.updateActionBars();
            }
        }
    }

    public void aboutToBeHidden() {
        TabbedPropertySheetPage tp = this.getTabbedPropertySheetPage();
        if (tp != null) {
            IActionBars actionBars;
            if (this.getElement() != null) {
                this.getElement().getPropertyChangeSupport().removePropertyChangeListener(this);
            }
            if (tp.getSite() != null && (actionBars = tp.getSite().getActionBars()) != null) {
                actionBars.getToolBarManager().removeAll();
                actionBars.updateActionBars();
            }
        }
        this.disposeRootEntry();
    }

    public APropertyNode getElement() {
        return this.element;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getElement() != evt.getSource()) {
            this.getElement().getPropertyChangeSupport().removePropertyChangeListener(this);
            if (!JSSCompoundCommand.isRefreshEventsIgnored(this.getElement())) {
                this.refresh();
            }
            this.getElement().getPropertyChangeSupport().addPropertyChangeListener(this);
        }
    }

    public void refresh() {
        if (this.isRefreshing) {
            return;
        }
        this.isRefreshing = true;
        if (this.page != null) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    JDAdvancedSection.this.page.refresh();
                }
            });
        }
        this.isRefreshing = false;
    }

    public Object getSelectedElement() {
        return this.getElement();
    }

    public List<Object> getHandledProperties() {
        return new ArrayList<Object>();
    }

    public IHighlightPropertyWidget getWidgetForProperty(Object propertyId) {
        return null;
    }

    public WidgetDescriptor getPropertyInfo(Object propertyId) {
        return null;
    }

    public void expandForProperty(Object propertyId) {
    }
}

