/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.graphic;

import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.ISetValueCommandProvider;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.section.AbstractRealValueSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SizeSection
extends AbstractRealValueSection {
    private ExpandableComposite section;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        parent = this.getWidgetFactory().createSection(parent, Messages.SizeSection_sizeSectionTitle, true, 4);
        this.section = (ExpandableComposite)parent.getParent();
        ASPropertyWidget<?> hw = this.createWidget4Property(parent, "width");
        CLabel lbl = hw.getLabel();
        lbl.setText(Messages.SizeSection_widthLabel);
        lbl.setLayoutData((Object)new GridData(128));
        hw = this.createWidget4Property(parent, "height");
        lbl = hw.getLabel();
        lbl.setText(Messages.SizeSection_heightLabel);
        lbl.setLayoutData((Object)new GridData(128));
        ASPropertyWidget<?> w = this.createWidget4Property(parent, "stretchType");
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        w.getControl().setLayoutData((Object)gd);
    }

    @Override
    protected void initializeProvidedProperties() {
        super.initializeProvidedProperties();
        this.addProvidedProperties("width", Messages.MGraphicElement_width);
        this.addProvidedProperties("height", Messages.common_height);
        this.addProvidedProperties("stretchType", Messages.common_stretch_type);
    }

    @Override
    public Command getChangePropertyCommand(Object property, Object newValue, APropertyNode n) {
        if (this.isChanged(property, newValue, n)) {
            ISetValueCommandProvider provider = (ISetValueCommandProvider)n.getAdapter(ISetValueCommandProvider.class);
            if (provider != null) {
                return provider.getSetValueCommand(n, n.getDisplayText(), property, newValue);
            }
            SetValueCommand setCommand = new SetValueCommand(n.getDisplayText()){

                @Override
                public void execute() {
                    super.execute();
                    this.layoutChildAndParent();
                }

                @Override
                public void undo() {
                    super.undo();
                    this.layoutChildAndParent();
                }

                private void layoutChildAndParent() {
                    ANode elementNode = (ANode)this.target;
                    LayoutManager.layoutContainer(elementNode);
                    LayoutManager.layoutContainer(elementNode.getParent());
                }
            };
            setCommand.setTarget(n);
            setCommand.setPropertyId(property);
            setCommand.setPropertyValue(newValue);
            return setCommand;
        }
        return null;
    }

    @Override
    public void expandForProperty(Object propertyId) {
        if (this.section != null && !this.section.isExpanded()) {
            this.section.setExpanded(true);
        }
    }
}

