/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.obj;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;

public class GroupSection
extends AbstractSection {
    private ASPropertyWidget<?> nameWidget;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        parent = this.getWidgetFactory().createSection(parent, Messages.GroupSection_SectionTitle, false, 2);
        this.nameWidget = this.createWidget4Property(parent, "name");
        this.createWidget4Property(parent, "expression");
    }

    @Override
    protected void initializeProvidedProperties() {
        super.initializeProvidedProperties();
        this.addProvidedProperties("name", Messages.common_name);
        this.addProvidedProperties("expression", Messages.common_expression);
    }

    @Override
    protected APropertyNode getModelFromEditPart(Object item) {
        APropertyNode md = super.getModelFromEditPart(item);
        if (md instanceof MBandGroupHeader) {
            return ((MBandGroupHeader)md).getMGroup();
        }
        if (md instanceof MBandGroupFooter) {
            return ((MBandGroupFooter)md).getMGroup();
        }
        return md;
    }

    @Override
    public boolean changeProperty(Object property, Object newValue) {
        if ("name".equals(property)) {
            JasperDesign jd = this.getElement().getJasperConfiguration().getJasperDesign();
            String oldName = this.getElement().getPropertyValue("name").toString();
            if (oldName.equals(newValue)) {
                return true;
            }
            if (jd != null && jd.getGroupsMap().get(newValue) != null) {
                this.nameWidget.setData(this.getElement(), oldName);
                String message = MessageFormat.format(Messages.GroupSection_SameNameErrorMsg, newValue);
                MessageDialog dialog = new MessageDialog(UIUtils.getShell(), Messages.GroupSection_SameNameErrorTitle, null, message, 4, new String[]{"Ok"}, 0);
                dialog.open();
                return false;
            }
        }
        return super.changeProperty(property, newValue);
    }
}

