/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.obj;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.properties.internal.IHighlightPropertyWidget;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.graphic.ASHighlightControl;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.BackgroundHighlight;
import com.jaspersoft.studio.property.section.widgets.SPHyperlinkParameter;
import com.jaspersoft.studio.property.section.widgets.SPWidgetFactory;
import com.jaspersoft.studio.swt.widgets.WHyperlink;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class HyperlinkSection
extends AbstractSection {
    private ElementHider anchor;
    private ElementHider page;
    private ElementHider reference;
    private ElementHider when;
    private ElementHider tooltip;
    private ElementHider parameters;
    private ASPropertyWidget<?> anchorWidget;
    private ASPropertyWidget<?> referenceWidget;
    private ASPropertyWidget<?> parametersWidget;
    private ASPropertyWidget<?> whenWidget;
    private ASPropertyWidget<?> tooltipWidget;
    private ASPropertyWidget<?> pageWidget;
    private Combo targetCombo;
    private Combo typeCombo;
    private Composite mainComposite;
    private ExpandableComposite section;
    private HashMap<String, ElementHider[]> hideList = null;
    private static String[] linkTargetItems = new String[]{HyperlinkTargetEnum.SELF.getName(), HyperlinkTargetEnum.BLANK.getName(), HyperlinkTargetEnum.TOP.getName(), HyperlinkTargetEnum.PARENT.getName()};
    private static String[] linkTypeItems;

    static {
        ArrayList<HyperlinkTypeEnum> filteredTypes = new ArrayList<HyperlinkTypeEnum>(2);
        filteredTypes.add(HyperlinkTypeEnum.CUSTOM);
        filteredTypes.add(HyperlinkTypeEnum.NULL);
        List<String> alltypes = ModelUtils.getHyperlinkTypeNames4Widget(filteredTypes);
        linkTypeItems = alltypes.toArray(new String[alltypes.size()]);
    }

    private GridData gridDataGenerator() {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    private GridData gridDataComboGenerator() {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 50;
        return gd;
    }

    @Override
    public void refresh() {
        this.setRefreshing(true);
        APropertyNode element = this.getElement();
        if (element != null) {
            String typeValue;
            if (this.anchorWidget != null) {
                this.anchorWidget.setData(element, element.getPropertyActualValue("hyperlinkAnchorExpression"));
            }
            if (this.referenceWidget != null) {
                this.referenceWidget.setData(element, element.getPropertyActualValue("hyperlinkReferenceExpression"));
            }
            if (this.whenWidget != null) {
                this.whenWidget.setData(element, element.getPropertyActualValue("hyperlinkWhenExpression"));
            }
            if (this.pageWidget != null) {
                this.pageWidget.setData(element, element.getPropertyActualValue("hyperlinkPageExpression"));
            }
            if (this.tooltipWidget != null) {
                this.tooltipWidget.setData(element, element.getPropertyActualValue("hyperlinkTooltipExpression"));
            }
            if (this.parametersWidget != null) {
                this.parametersWidget.setData(element, element.getPropertyActualValue("hyperlinkParameters"));
            }
            Object propertyValue = element.getPropertyActualValue("linkTarget");
            if (this.targetCombo != null) {
                this.targetCombo.setText(propertyValue != null ? propertyValue.toString() : linkTargetItems[0]);
            }
            String string = typeValue = (propertyValue = element.getPropertyActualValue("hyperlinkType")) != null ? propertyValue.toString() : linkTypeItems[0];
            if (this.typeCombo != null && !typeValue.equals(this.typeCombo.getText())) {
                this.typeCombo.setText(typeValue);
            }
        }
        this.setRefreshing(false);
    }

    private void createMap() {
        if (this.hideList == null) {
            this.hideList = new HashMap();
            this.hideList.put(linkTypeItems[0], new ElementHider[]{this.tooltip});
            this.hideList.put(linkTypeItems[1], new ElementHider[]{this.tooltip, this.reference});
            this.hideList.put(linkTypeItems[2], new ElementHider[]{this.tooltip, this.anchor});
            this.hideList.put(linkTypeItems[3], new ElementHider[]{this.tooltip, this.page});
            this.hideList.put(linkTypeItems[4], new ElementHider[]{this.tooltip, this.reference, this.anchor});
            this.hideList.put(linkTypeItems[5], new ElementHider[]{this.tooltip, this.reference, this.page});
            int i = 6;
            while (i < linkTypeItems.length) {
                List<WHyperlink.UIElement> uiElements = JaspersoftStudioPlugin.getExtensionManager().getUIElementsForCustomHyperlink(linkTypeItems[i]);
                ArrayList<ElementHider> elHiders = new ArrayList<ElementHider>();
                if (uiElements.contains((Object)WHyperlink.UIElement.ANCHOR)) {
                    elHiders.add(this.anchor);
                }
                if (uiElements.contains((Object)WHyperlink.UIElement.PAGE)) {
                    elHiders.add(this.page);
                }
                if (uiElements.contains((Object)WHyperlink.UIElement.REFERENCE)) {
                    elHiders.add(this.reference);
                }
                if (uiElements.contains((Object)WHyperlink.UIElement.TOOLTIP)) {
                    elHiders.add(this.tooltip);
                }
                if (uiElements.contains((Object)WHyperlink.UIElement.PARAMETERS)) {
                    elHiders.add(this.parameters);
                }
                this.hideList.put(linkTypeItems[i], elHiders.toArray(new ElementHider[elHiders.size()]));
                ++i;
            }
            this.hideList.put("Custom", new ElementHider[]{this.parameters});
        }
    }

    private void refreshVisibleComponents() {
        ElementHider[] actualHiders;
        ElementHider[] hiders;
        ElementHider[] elementHiderArray = hiders = new ElementHider[]{this.anchor, this.page, this.reference, this.tooltip, this.parameters};
        int n = hiders.length;
        int n2 = 0;
        while (n2 < n) {
            ElementHider hider = elementHiderArray[n2];
            hider.hideAll();
            ++n2;
        }
        String selectedValue = this.typeCombo.getText();
        if (!this.hideList.containsKey(selectedValue)) {
            selectedValue = "Custom";
        }
        ElementHider[] elementHiderArray2 = actualHiders = this.hideList.get(selectedValue);
        int n3 = actualHiders.length;
        int n4 = 0;
        while (n4 < n3) {
            ElementHider hider = elementHiderArray2[n4];
            if (hider != null) {
                hider.showAll();
            }
            ++n4;
        }
        this.mainComposite.layout();
    }

    private void readValueFromCombo(Combo combo, String property) {
        for (APropertyNode element : this.getElements()) {
            element.setPropertyValue(property, combo.getText());
            int stringLength = combo.getText().length();
            combo.setSelection(new Point(stringLength, stringLength));
        }
    }

    private Label createLabel(Composite parent, String toolTip, String text) {
        Label newLabel = new Label(parent, 0);
        newLabel.setText(text);
        newLabel.setToolTipText(toolTip);
        return newLabel;
    }

    private void setHelp() {
        String prefix = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#";
        if (this.getElement() instanceof MImage) {
            HelpSystem.setHelp((Control)this.typeCombo, String.valueOf(prefix) + "image_hyperlinkType");
            HelpSystem.setHelp((Control)this.targetCombo, String.valueOf(prefix) + "image_hyperlinkTarget");
        } else if (this.getElement() instanceof MTextField) {
            HelpSystem.setHelp((Control)this.typeCombo, String.valueOf(prefix) + "textField_hyperlinkType");
            HelpSystem.setHelp((Control)this.targetCombo, String.valueOf(prefix) + "textField_hyperlinkTarget");
        } else {
            HelpSystem.setHelp((Control)this.typeCombo, String.valueOf(prefix) + "sectionHyperlink_hyperlinkType");
            HelpSystem.setHelp((Control)this.targetCombo, String.valueOf(prefix) + "sectionHyperlink_hyperlinkTarget");
        }
    }

    protected void createWhenWidget() {
        Label whenLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_whenexpr_desc, Messages.MHyperLink_whenexpr);
        this.whenWidget = this.createWidget4Property(this.mainComposite, "hyperlinkWhenExpression", false);
        this.whenWidget.getControl().setLayoutData((Object)this.gridDataGenerator());
        this.when = new ElementHider(new Control[]{whenLabel, this.whenWidget.getControl()});
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.mainComposite = this.getWidgetFactory().createSection(parent, Messages.HyperlinkSection_hyperlinkSectionTitle, true, 3);
        this.section = (ExpandableComposite)this.mainComposite.getParent();
        this.section.setExpanded(false);
        this.mainComposite.setLayout((Layout)new GridLayout(3, false));
        GridData parentData = new GridData(4, 4, true, true);
        parentData.minimumHeight = 280;
        parentData.heightHint = 280;
        this.section.setLayoutData((Object)parentData);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.createLabel(this.mainComposite, Messages.MHyperLink_link_target_description, Messages.MHyperLink_link_target);
        this.targetCombo = new Combo(this.mainComposite, 0);
        this.targetCombo.setLayoutData((Object)this.gridDataComboGenerator());
        this.targetCombo.setItems(linkTargetItems);
        this.createLabel(this.mainComposite, Messages.MHyperLink_link_type_description, Messages.MHyperLink_link_type);
        this.typeCombo = new Combo(this.mainComposite, 0);
        this.typeCombo.setLayoutData((Object)this.gridDataComboGenerator());
        this.typeCombo.setItems(linkTypeItems);
        Label anchorLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_anchor_expression_description, Messages.MHyperLink_hyperlink_anchor_expression);
        this.anchorWidget = this.createWidget4Property(this.mainComposite, "hyperlinkAnchorExpression", false);
        this.anchorWidget.getControl().setLayoutData((Object)this.gridDataGenerator());
        this.anchor = new ElementHider(new Control[]{anchorLabel, this.anchorWidget.getControl()});
        Label pageLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_page_expression_description, Messages.MHyperLink_hyperlink_page_expression);
        this.pageWidget = this.createWidget4Property(this.mainComposite, "hyperlinkPageExpression", false);
        this.pageWidget.getControl().setLayoutData((Object)this.gridDataGenerator());
        this.page = new ElementHider(new Control[]{pageLabel, this.pageWidget.getControl()});
        Label referenceLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_reference_expression_description, Messages.MHyperLink_hyperlink_reference_expression);
        this.referenceWidget = this.createWidget4Property(this.mainComposite, "hyperlinkReferenceExpression", false);
        this.referenceWidget.getControl().setLayoutData((Object)this.gridDataGenerator());
        this.reference = new ElementHider(new Control[]{referenceLabel, this.referenceWidget.getControl()});
        IPropertyDescriptor whenDescriptor = this.getPropertyDesriptor("hyperlinkWhenExpression");
        if (whenDescriptor != null) {
            Label whenLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_whenexpr_desc, Messages.MHyperLink_whenexpr);
            this.whenWidget = SPWidgetFactory.createWidget(this.mainComposite, this, whenDescriptor);
            this.widgets.put(whenDescriptor.getId(), this.whenWidget);
            this.whenWidget.getControl().setLayoutData((Object)this.gridDataGenerator());
            this.when = new ElementHider(new Control[]{whenLabel, this.whenWidget.getControl()});
        }
        Label tooltipLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_tooltip_expression_description, Messages.MHyperLink_hyperlink_tooltip_expression);
        this.tooltipWidget = this.createWidget4Property(this.mainComposite, "hyperlinkTooltipExpression", false);
        this.tooltipWidget.getControl().setLayoutData((Object)this.gridDataGenerator());
        this.tooltip = new ElementHider(new Control[]{tooltipLabel, this.tooltipWidget.getControl()});
        Label parametersLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_parameters_description, Messages.common_parameters);
        this.parametersWidget = this.createWidget4Property(this.mainComposite, "hyperlinkParameters", false);
        Control button = ((SPHyperlinkParameter)this.parametersWidget).getButton();
        this.parameters = new ElementHider(new Control[]{parametersLabel, this.parametersWidget.getControl(), button});
        this.createMap();
        this.setHelp();
        this.targetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkSection.this.readValueFromCombo(HyperlinkSection.this.targetCombo, "linkTarget");
            }
        });
        this.targetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkSection.this.readValueFromCombo(HyperlinkSection.this.targetCombo, "linkTarget");
            }
        });
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkSection.this.refreshVisibleComponents();
                HyperlinkSection.this.readValueFromCombo(HyperlinkSection.this.typeCombo, "hyperlinkType");
            }
        });
        this.typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkSection.this.refreshVisibleComponents();
                HyperlinkSection.this.readValueFromCombo(HyperlinkSection.this.typeCombo, "hyperlinkType");
            }
        });
    }

    @Override
    public IHighlightPropertyWidget getWidgetForProperty(Object propertyId) {
        if ("linkTarget".equals(propertyId)) {
            return new ASHighlightControl((Control)this.targetCombo, new BackgroundHighlight((Control)this.targetCombo));
        }
        if ("hyperlinkType".equals(propertyId)) {
            return new ASHighlightControl((Control)this.typeCombo, new BackgroundHighlight((Control)this.typeCombo));
        }
        return super.getWidgetForProperty(propertyId);
    }

    @Override
    protected void initializeProvidedProperties() {
        super.initializeProvidedProperties();
        this.addProvidedProperties("linkTarget", Messages.MHyperLink_link_target);
        this.addProvidedProperties("hyperlinkType", Messages.MHyperLink_link_type);
        this.addProvidedProperties("hyperlinkAnchorExpression", Messages.MHyperLink_hyperlink_anchor_expression);
        this.addProvidedProperties("hyperlinkPageExpression", Messages.MHyperLink_hyperlink_page_expression);
        this.addProvidedProperties("hyperlinkReferenceExpression", Messages.MHyperLink_hyperlink_reference_expression);
        this.addProvidedProperties("hyperlinkWhenExpression", Messages.MHyperLink_whenexpr);
        this.addProvidedProperties("hyperlinkTooltipExpression", Messages.MHyperLink_hyperlink_tooltip_expression);
        this.addProvidedProperties("hyperlinkParameters", Messages.common_parameters);
    }

    @Override
    public void expandForProperty(Object propertyId) {
        if (this.section != null && !this.section.isExpanded()) {
            this.section.setExpanded(true);
        }
    }

    private class ElementHider {
        private Control[] controls;

        public ElementHider(Control[] controls) {
            this.controls = controls;
        }

        public void setVisibility(boolean visible) {
            Control[] controlArray = this.controls;
            int n = this.controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    if (control.getLayoutData() == null) {
                        control.setLayoutData((Object)new GridData());
                    }
                    GridData layout = (GridData)control.getLayoutData();
                    layout.exclude = !visible;
                    control.setVisible(visible);
                }
                ++n2;
            }
        }

        public void showAll() {
            this.setVisibility(true);
        }

        public void hideAll() {
            this.setVisibility(false);
        }
    }
}

