/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.report;

import com.jaspersoft.studio.editor.gef.figures.borders.ShadowBorder;
import com.jaspersoft.studio.editor.java2d.J2DLightweightSystem;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class PageFormatWidget
extends Composite {
    private Figure parentFigure;
    private Canvas square;
    private RectangleFigure borderPreview;
    private J2DLightweightSystem lws;
    private int pwidth;
    private int pheight;
    private int space;
    private int cwidth;
    private int cols;
    private int lmargin;
    private int tmargin;
    private int rmargin;
    private int bmargin;

    public PageFormatWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.square = new Canvas((Composite)this, 0x140000);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.square.setLayoutData((Object)gd);
        this.lws = new J2DLightweightSystem();
        this.lws.setControl(this.square);
        this.parentFigure = new Figure();
        this.parentFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.lws.setContents((IFigure)this.parentFigure);
        this.borderPreview = new RectangleFigure(){

            public void paint(Graphics graphics) {
                Dimension psize = PageFormatWidget.this.parentFigure.getSize();
                float zoom = Math.max((float)PageFormatWidget.this.pwidth / (float)(psize.width - 20), (float)PageFormatWidget.this.pheight / (float)(psize.height - 20));
                int x = this.getBounds().x + 10 + Math.round((float)PageFormatWidget.this.lmargin / zoom);
                int y = this.getBounds().y + 10 + Math.round((float)PageFormatWidget.this.tmargin / zoom);
                int w = this.getBounds().width - 20 - Math.round((float)PageFormatWidget.this.rmargin / zoom) - Math.round((float)PageFormatWidget.this.lmargin / zoom);
                int h = this.getBounds().height - 20 - Math.round((float)PageFormatWidget.this.bmargin / zoom) - Math.round((float)PageFormatWidget.this.tmargin / zoom);
                graphics.setForegroundColor(ColorConstants.blue);
                graphics.setBackgroundColor(ColorConstants.lightGray);
                graphics.setLineWidthFloat(0.1f);
                graphics.drawRectangle(x, y, w, h);
                int sw = Math.round((float)PageFormatWidget.this.space / zoom);
                w = Math.round((float)PageFormatWidget.this.cwidth / zoom);
                int i = 1;
                while (i < PageFormatWidget.this.cols) {
                    graphics.drawLine(x += w, y, x, y + h);
                    graphics.fillRectangle(x, y, sw, h);
                    graphics.drawLine(x += sw, y, x, y + h);
                    ++i;
                }
                this.paintBorder(graphics);
            }
        };
        this.borderPreview.setBorder((Border)new ShadowBorder());
        this.parentFigure.add((IFigure)this.borderPreview);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                PageFormatWidget.this.setTBounds();
            }
        });
    }

    public void setPwidth(int pwidth) {
        this.pwidth = pwidth;
    }

    public void setPheight(int pheight) {
        this.pheight = pheight;
    }

    public void setSpace(int space) {
        this.space = space;
    }

    public void setCwidth(int cwidth) {
        this.cwidth = cwidth;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setLmargin(int lmargin) {
        this.lmargin = lmargin;
    }

    public void setTmargin(int tmargin) {
        this.tmargin = tmargin;
    }

    public void setRmargin(int rmargin) {
        this.rmargin = rmargin;
    }

    public void setBmargin(int bmargin) {
        this.bmargin = bmargin;
    }

    public Control getCanvas() {
        return this.square;
    }

    public void setTBounds() {
        if (!this.isDisposed()) {
            Dimension psize = this.parentFigure.getSize();
            float zoom = Math.max((float)this.pwidth / (float)(psize.width + 10), (float)this.pheight / (float)(psize.height + 10));
            int w = Math.max(22, Math.round((float)this.pwidth / zoom));
            int h = Math.max(22, Math.round((float)this.pheight / zoom));
            this.borderPreview.setSize(w, h);
            int x = psize.width / 2 - w / 2;
            int y = psize.height / 2 - h / 2;
            this.borderPreview.setLocation(new Point(x, y));
            this.parentFigure.invalidate();
            this.square.redraw();
            this.lws.getUpdateManager().performUpdate();
        }
    }
}

