/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.report.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.gef.parts.ReportPageEditPart;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.editor.report.ReportEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class PageRemoveMarginsAction
extends ACachedSelectionAction {
    public static final String ID = "pageRemoveMarginsAction";

    public PageRemoveMarginsAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        super.init();
        this.setText(Messages.PageRemoveMarginsAction_actionName);
        this.setToolTipText(Messages.PageRemoveMarginsAction_actionTooltip);
        this.setId(ID);
        this.setEnabled(false);
    }

    @Override
    public void run() {
        ReportEditor part = (ReportEditor)this.getWorkbenchPart();
        MReport n = (MReport)part.getModel().getChildren().get(0);
        JasperDesign jd = n.getJasperDesign();
        JSSCompoundCommand c = new JSSCompoundCommand(this.getText(), (ANode)n);
        c.add(this.createResetCommand(n, "leftMargin", 0));
        c.add(this.createResetCommand(n, "rightMargin", 0));
        c.add(this.createResetCommand(n, "topMargin", 0));
        c.add(this.createResetCommand(n, "bottomMargin", 0));
        int w = jd.getPageWidth() - jd.getLeftMargin() - jd.getRightMargin();
        int h = jd.getPageHeight() - jd.getTopMargin() - jd.getBottomMargin();
        c.add(this.createResetCommand(n, "pageWidth", w));
        c.add(this.createResetCommand(n, "pageHeight", h));
        this.execute((Command)c);
    }

    private Command createResetCommand(APropertyNode n, Object prop, int value) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setPropertyId(prop);
        cmd.setPropertyValue(value);
        cmd.setTarget(n);
        return cmd;
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() > 1) {
            return false;
        }
        List<Object> pageEditPart = this.editor.getSelectionCache().getSelectionPartForType(ReportPageEditPart.class);
        if (pageEditPart.size() > 0) {
            return true;
        }
        List<Object> bandEditParts = this.editor.getSelectionCache().getSelectionPartForType(BandEditPart.class);
        return bandEditParts.size() > 0;
    }
}

