/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.report.util;

import com.jaspersoft.studio.utils.ModelUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatedMeasureUnitFormat
extends DecimalFormat {
    private static final long serialVersionUID = -8953035800738294624L;
    private Pattern patternToMatch;
    private String measureUnit;

    public ValidatedMeasureUnitFormat(String measureUnit) {
        this.measureUnit = measureUnit;
        String pattern = "#####0.####";
        this.updateStringPattern();
        this.applyPattern(pattern);
    }

    protected void updateStringPattern() {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        char decimalSeparator = symbols.getDecimalSeparator();
        this.patternToMatch = ModelUtils.safeEquals(this.measureUnit, "pixel") ? Pattern.compile("[0-9]+") : Pattern.compile("[0-9]+([" + decimalSeparator + "]{0,1}[0-9]{0,4})?");
    }

    @Override
    public Number parse(String source) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        String valueToParse = source;
        Matcher matcher = this.patternToMatch.matcher(valueToParse);
        if (!matcher.matches()) {
            throw new ParseException(valueToParse, pp.getIndex());
        }
        Number result = super.parse(valueToParse, pp);
        if (pp.getIndex() == valueToParse.length()) {
            return result;
        }
        throw new ParseException(valueToParse, pp.getIndex());
    }

    public void setMeasureUnit(String unit) {
        if (!ModelUtils.safeEquals(unit, this.measureUnit)) {
            this.measureUnit = unit;
            this.updateStringPattern();
        }
    }
}

