/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.report.util;

import com.jaspersoft.studio.property.section.report.util.Unit;
import com.jaspersoft.studio.property.section.report.util.ValidatedMeasureUnitFormat;
import com.jaspersoft.studio.swt.widgets.NullableSpinner;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ValueUnitsWidget {
    private Unit unit;
    private Unit maxPixels;
    private Combo unitc;
    private NullableSpinner val;
    private ValidatedMeasureUnitFormat spinnerValidator = new ValidatedMeasureUnitFormat("pixel");

    public ValueUnitsWidget() {
        this.unit = new Unit(0.0, "pixel");
        this.maxPixels = new Unit(2.147483647E9, "pixel");
    }

    public void createComponent(Composite parent, String label, String toolTip) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        this.val = new NullableSpinner(parent, 133120);
        this.val.setFormat(this.spinnerValidator);
        this.val.setToolTipText(toolTip);
        this.val.setNullable(false);
        GridData gd = new GridData();
        gd.widthHint = 80;
        this.val.setLayoutData(gd);
        this.unitc = new Combo(parent, 2060);
        this.unitc.setItems(Unit.getUnits());
        this.unitc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String u = Unit.getUnits()[ValueUnitsWidget.this.unitc.getSelectionIndex()];
                if (ValueUnitsWidget.this.unit.setUnit(u)) {
                    ValueUnitsWidget.this.setSpinerValue(u);
                }
            }
        });
        this.val.addSelectionListener((SelectionListener)new SpinerSelectionListener());
        this.unitc.select(0);
        this.setSpinerValue(this.unit.getUnit());
    }

    public void setMaxPixels(int maxPixels) {
        this.maxPixels.setValue(maxPixels, "pixel");
        String currentUnit = Unit.getUnits()[this.unitc.getSelectionIndex()];
        this.val.setMaximum(this.maxPixels.getValue(currentUnit));
    }

    private void setSpinerValue(String u) {
        this.spinnerValidator.setMeasureUnit(u);
        this.val.setMinimum(0.0);
        this.val.setMaximum(this.maxPixels.getValue(u));
        this.val.setIncrement(1.0f);
        this.val.setValue(this.unit.getValue(u));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.val.addSelectionListener(listener);
    }

    public void setUnit(String u) {
        if (this.unit.setUnit(u)) {
            this.unitc.select(Unit.getUnitIndex(u));
            this.setSpinerValue(u);
        }
    }

    public int getValue() {
        return this.unit.getPxValue();
    }

    public String getUnit() {
        return this.unit.getUnit();
    }

    public void setValue(int px) {
        this.unit.setValue(px, "pixel");
        this.setSpinerValue(this.unit.getUnit());
    }

    private final class SpinerSelectionListener
    extends SelectionAdapter {
        private SpinerSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ValueUnitsWidget.this.unit.setValue(ValueUnitsWidget.this.val.getValueAsDouble(), Unit.getUnits()[ValueUnitsWidget.this.unitc.getSelectionIndex()]);
        }
    }
}

