/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.CustomAutoCompleteField;
import com.jaspersoft.studio.utils.inputhistory.InputHistoryCache;
import java.util.ArrayList;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AHistorySPropertyWidget<K extends IPropertyDescriptor>
extends ASPropertyWidget<K> {
    public static final String HIST_PREFIX = "asproperty.";
    protected CustomAutoCompleteField autocomplete;
    private BindingService bindingService;

    public AHistorySPropertyWidget(Composite parent, AbstractSection section, K pDescriptor) {
        super(parent, section, pDescriptor);
    }

    protected abstract Text getTextControl();

    protected Object getHistoryKey() {
        return HIST_PREFIX + this.pDescriptor.getId();
    }

    @Override
    protected void handleFocusLost() {
        if (this.autocomplete != null) {
            this.autocomplete.setProposals(InputHistoryCache.get(null));
            if (this.getTextControl() != null) {
                InputHistoryCache.put(this.getHistoryKey(), this.getTextControl().getText());
            }
        }
        super.handleFocusLost();
        this.activateHandlers();
    }

    @Override
    protected void handleFocusGained() {
        if (this.autocomplete != null) {
            this.autocomplete.setProposals(InputHistoryCache.get(this.getHistoryKey()));
        }
        super.handleFocusGained();
        this.deactivateHandlers();
    }

    private void activateHandlers() {
        if (this.getBindingService() == null) {
            return;
        }
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (cs != null) {
            this.bindingService.readRegistryAndPreferences(cs);
        }
    }

    private BindingService getBindingService() {
        if (this.bindingService == null) {
            this.bindingService = (BindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        }
        return this.bindingService;
    }

    public void deactivateHandlers() {
        if (this.getBindingService() == null) {
            return;
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Binding[] bindingArray = this.bindingService.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            Binding b = bindingArray[n2];
            if (b.getParameterizedCommand() != null && (id = b.getParameterizedCommand().getId()) != null && (id.equals("org.eclipse.ui.edit.undo") || id.equals("org.eclipse.ui.edit.redo"))) {
                bindings.add(b);
            }
            ++n2;
        }
        for (Binding b : bindings) {
            this.bindingService.removeBinding(b);
        }
    }
}

