/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import java.util.HashMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

public class DefaultWidgetsHighlighters {
    private static HashMap<Class<?>, PaintListener> widgetsMap = null;
    private static PaintListener defaultListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Rectangle bounds = ((Control)e.getSource()).getBounds();
            e.gc.setForeground(ColorConstants.orange);
            e.gc.setLineWidth(3);
            e.gc.drawRectangle(0, 0, bounds.width - 5, bounds.height - 5);
        }
    };

    private static void initializeMap() {
        widgetsMap = new HashMap();
        widgetsMap.put(ToolItem.class, new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = ((Control)e.getSource()).getBounds();
                e.gc.setForeground(ColorConstants.orange);
                e.gc.setLineWidth(3);
                e.gc.drawRectangle(1, 1, bounds.width - 3, bounds.height - 3);
            }
        });
        widgetsMap.put(Combo.class, new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = ((Control)e.getSource()).getBounds();
                e.gc.setForeground(ColorConstants.orange);
                e.gc.setLineWidth(3);
                e.gc.drawRectangle(1, 1, bounds.width - 3, bounds.height - 3);
            }
        });
        widgetsMap.put(Composite.class, new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setLineWidth(3);
                int lineWidth = gc.getLineWidth();
                gc.setForeground(ColorConstants.orange);
                gc.drawRectangle(1, 1, e.width - lineWidth, e.height - lineWidth);
            }
        });
        widgetsMap.put(Button.class, new PaintListener(){

            public void paintControl(PaintEvent e) {
                Button obj = (Button)e.getSource();
                obj.setBackground(ColorConstants.orange);
                Pattern pattern = new Pattern(e.gc.getDevice(), 0.0f, 0.0f, 0.0f, 100.0f, ColorConstants.orange, 230, ColorConstants.orange, 230);
                e.gc.setBackgroundPattern(pattern);
                e.gc.fillGradientRectangle(0, 0, obj.getBounds().width, obj.getBounds().height, true);
            }
        });
    }

    public static PaintListener getWidgetForType(Class<?> type) {
        PaintListener selected;
        if (widgetsMap == null) {
            DefaultWidgetsHighlighters.initializeMap();
        }
        return (selected = widgetsMap.get(type)) != null ? selected : defaultListener;
    }
}

