/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.property.descriptor.color.ColorLabelProvider;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SPColor
extends ASPropertyWidget<ColorPropertyDescriptor> {
    private ToolItem foreButton;
    private ColorLabelProvider colorLabelProvider = new ColorLabelProvider(null);
    private APropertyNode parent;
    private ToolBar toolBar;
    private boolean isEnabled = true;

    public SPColor(Composite parent, AbstractSection section, ColorPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.toolBar;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x804040);
        this.toolBar.setBackground(parent.getBackground());
        this.toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SPColor.this.colorLabelProvider.dispose();
            }
        });
        this.foreButton = new ToolItem(this.toolBar, 8);
        this.foreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SPColor.this.isEnabled) {
                    ColorDialog cd = new ColorDialog(SPColor.this.toolBar.getShell());
                    cd.setText(((ColorPropertyDescriptor)SPColor.this.pDescriptor).getDisplayName());
                    AlfaRGB rgb = (AlfaRGB)SPColor.this.section.getElement().getPropertyActualValue(((ColorPropertyDescriptor)SPColor.this.pDescriptor).getId());
                    cd.setRGB(rgb == null ? null : rgb);
                    boolean useTransparency = true;
                    useTransparency = ((ColorPropertyDescriptor)SPColor.this.pDescriptor).supportsTransparency();
                    if (useTransparency) {
                        AlfaRGB newColor = cd.openAlfaRGB();
                        if (newColor != null) {
                            SPColor.this.changeProperty(SPColor.this.section, ((ColorPropertyDescriptor)SPColor.this.pDescriptor).getId(), newColor);
                        }
                    } else {
                        RGB newColor = cd.openRGB();
                        if (newColor != null) {
                            SPColor.this.changeProperty(SPColor.this.section, ((ColorPropertyDescriptor)SPColor.this.pDescriptor).getId(), AlfaRGB.getFullyOpaque(newColor));
                        }
                    }
                }
            }
        });
        this.foreButton.setToolTipText(((ColorPropertyDescriptor)this.pDescriptor).getDescription());
        this.toolBar.pack();
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        if (elementValue == null && this.getLabel() != null) {
            this.foreButton.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + ((ColorPropertyDescriptor)this.pDescriptor).getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(String.valueOf(Messages.common_inherited_attribute) + ((ColorPropertyDescriptor)this.pDescriptor).getDescription());
                this.getLabel().setForeground(UIUtils.INHERITED_COLOR);
            }
        } else if (this.getLabel() != null) {
            this.foreButton.setToolTipText(((ColorPropertyDescriptor)this.pDescriptor).getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(((ColorPropertyDescriptor)this.pDescriptor).getDescription());
                this.getLabel().setForeground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"));
            }
        }
        this.setData(pnode, resolvedValue);
    }

    public void setData(APropertyNode parent, AlfaRGB b) {
        this.parent = parent;
        this.foreButton.setImage(this.colorLabelProvider.getImage(b));
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.createContextualMenu(pnode);
        this.isEnabled = pnode.isEditable();
        this.setData(null, (AlfaRGB)b);
    }

    private void changeProperty(AbstractSection section, Object property, AlfaRGB newColor) {
        if (this.parent == null) {
            section.changeProperty(property, newColor);
        } else {
            section.changePropertyOn(property, newColor, this.parent);
        }
    }
}

