/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPNumber;
import com.jaspersoft.studio.swt.widgets.JSSAngleSlider;
import java.math.BigDecimal;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPDegree
extends SPNumber {
    private JSSAngleSlider angleSlider;
    private Composite composite;
    private SelectionListener degreeSelectionListener;

    public SPDegree(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.composite = this.section.getWidgetFactory().createComposite(parent);
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.center = true;
        this.composite.setLayout((Layout)layout);
        this.angleSlider = new JSSAngleSlider(this.composite, 0);
        this.angleSlider.setToolTipText(this.pDescriptor.getDescription());
        this.degreeSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPDegree.this.ftext.setValue(SPDegree.this.angleSlider.getSelection());
                SPDegree.this.changeValue();
            }
        };
        this.angleSlider.addSelectionListener(this.degreeSelectionListener);
        super.createComponent(this.composite);
    }

    @Override
    protected void createContextualMenu(APropertyNode node) {
        this.createContextualMenu(node, (Control)this.angleSlider, this.pDescriptor.getId().toString());
        this.createContextualMenu(node, (Control)this.ftext, this.pDescriptor.getId().toString());
    }

    @Override
    protected void focusControl(Control control) {
        super.focusControl((Control)this.ftext);
    }

    @Override
    public void setDataNumber(Number resolvedNumber, Number ownNumber) {
        super.setDataNumber(resolvedNumber, ownNumber);
        this.angleSlider.removeSelectionListener(this.degreeSelectionListener);
        if (resolvedNumber != null) {
            int degree = Math.abs(resolvedNumber.intValue());
            if (degree > 360) {
                degree = BigDecimal.valueOf(degree).remainder(BigDecimal.valueOf(360L)).intValue();
            }
            this.angleSlider.setSelection(degree);
        } else if (ownNumber != null) {
            int degree = Math.abs(ownNumber.intValue());
            if (degree > 360) {
                degree = BigDecimal.valueOf(degree).remainder(BigDecimal.valueOf(360L)).intValue();
            }
            this.angleSlider.setSelection(degree);
        } else {
            this.angleSlider.setSelection(0);
        }
        this.angleSlider.addSelectionListener(this.degreeSelectionListener);
    }
}

