/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.ibm.icu.text.MessageFormat;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.AHistorySPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.CustomAutoCompleteField;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.inputhistory.InputHistoryCache;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPExpression
extends AHistorySPropertyWidget<IPropertyDescriptor>
implements IExpressionContextSetter {
    protected WTextExpression expr;

    public SPExpression(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.expr;
    }

    @Override
    protected Text getTextControl() {
        return this.expr.getTextControl();
    }

    @Override
    public Control getControlToBorder() {
        return this.getTextControl();
    }

    @Override
    protected void createComponent(Composite parent) {
        this.expr = new WTextExpression(parent, 0, 1);
        this.expr.addModifyListener(event -> {
            JRDesignExpression exp = this.expr.getExpression();
            this.section.changeProperty(this.pDescriptor.getId(), exp != null ? exp.clone() : null);
        });
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(768);
            this.expr.setLayoutData(gd);
        }
        this.expr.getTextControl().addFocusListener(this.focusListener);
        this.autocomplete = new CustomAutoCompleteField((Control)this.expr.getTextControl(), (IControlContentAdapter)new TextContentAdapter(), InputHistoryCache.get(this.getHistoryKey()));
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        ExpressionContext expContext;
        this.createContextualMenu(pnode);
        this.expr.setEnabled(pnode.isEditable());
        this.expr.setExpression((JRDesignExpression)b);
        if (b != null && this.expr.getTextControl() != null) {
            String expressionText = ((JRDesignExpression)b).getText();
            if (this.expr.isTraverseOnTab()) {
                String tooltip = MessageFormat.format((String)Messages.SPExpression_tooltipHint, (Object[])new Object[]{expressionText});
                this.expr.getTextControl().setToolTipText(tooltip);
            } else {
                this.expr.getTextControl().setToolTipText(expressionText);
            }
        }
        JRDesignElement designEl = null;
        if (pnode.getValue() instanceof JRDesignElement) {
            designEl = (JRDesignElement)pnode.getValue();
        }
        if ((expContext = pnode.getExpressionContext(Misc.toStringObject((Object)this.pDescriptor.getId()))) != null) {
            this.expr.setExpressionContext(expContext);
        } else {
            this.expr.setExpressionContext(ModelUtils.getElementExpressionContext(designEl, pnode));
        }
    }

    public void setEnabled(boolean enabled) {
        this.expr.setEnabled(enabled);
    }

    @Override
    public void setExpressionContext(ExpressionContext exprContext) {
        this.expr.setExpressionContext(exprContext);
    }

    public void setTraverseOnTab(boolean value) {
        if (this.expr != null) {
            this.expr.setTraverseOnTab(value);
        }
    }
}

