/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboItemSeparator;
import com.jaspersoft.studio.property.combomenu.WritableComboTableViewer;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignFont;
import net.sf.jasperreports.engine.fonts.FontUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class SPFontNamePopUp<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    private static final String FONT_PREVIEW_MESSAGE = "Sample";
    private PreferenceListener preferenceListener = new PreferenceListener();
    protected WritableComboTableViewer combo;
    private APropertyNode pnode;
    protected boolean dataSetted = false;

    public SPFontNamePopUp(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, (IResource)section.getJasperReportsContext().get("ifile"));
    }

    private static BufferedImage resize(BufferedImage img, int newWidth, int newHeight) {
        int oldWidth = img.getWidth();
        int oldHeight = img.getHeight();
        if (newWidth == oldWidth || newHeight == oldHeight) {
            return img;
        }
        int scaledHeight = newHeight;
        int scaledWidth = Math.max((int)((float)oldWidth * (float)scaledHeight) / oldHeight, 1);
        if (scaledWidth > newWidth) {
            scaledWidth = newWidth;
            scaledHeight = Math.max((int)((float)oldHeight * (float)scaledWidth) / oldWidth, 1);
        }
        Image tmp = img.getScaledInstance(scaledWidth, scaledHeight, 16);
        BufferedImage dimg = new BufferedImage(newWidth, newHeight, 2);
        int yOffset = (newHeight - scaledHeight) / 2;
        int xOffset = (newWidth - scaledWidth) / 2;
        Graphics2D g2d = dimg.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.drawImage(tmp, xOffset, yOffset, null);
        g2d.dispose();
        return dimg;
    }

    public static BufferedImage createFontImage(String fontName, FontUtil util) {
        int height = 16;
        int width = 55;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D ig2 = bi.createGraphics();
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ig2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        JRDesignFont jrFont = new JRDesignFont(null);
        jrFont.setFontName(fontName);
        jrFont.setFontSize(Float.valueOf(30.0f));
        Font font = util.getAwtFont((JRFont)jrFont, Locale.getDefault());
        ig2.setFont(font);
        FontMetrics metrics = ig2.getFontMetrics(font);
        int stringWidth = metrics.stringWidth(FONT_PREVIEW_MESSAGE);
        int stringHeight = metrics.getAscent() + 5;
        ig2.dispose();
        if (stringWidth <= 0) {
            stringWidth = width;
        }
        if (stringHeight <= 0) {
            stringHeight = height;
        }
        bi = new BufferedImage(stringWidth, stringHeight, 2);
        ig2 = bi.createGraphics();
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ig2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ig2.setFont(font);
        ig2.setPaint(Color.black);
        ig2.drawString(FONT_PREVIEW_MESSAGE, 0, bi.getHeight() / 2 + stringHeight / 4);
        ig2.dispose();
        return SPFontNamePopUp.resize(bi, width, height);
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        this.setData(pnode, resolvedValue);
        if (this.combo != null && !this.combo.getControl().isDisposed()) {
            if (elementValue != null) {
                this.combo.setInherithed(false);
                this.combo.setToolTipText(this.pDescriptor.getDescription());
            } else {
                this.combo.setInherithed(true);
                this.combo.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
            }
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.pnode = pnode;
        if (pnode != null) {
            this.createContextualMenu(pnode);
            this.combo.setEnabled(pnode.isEditable());
            if (!this.dataSetted) {
                this.combo.addSelectionListener(new ComboItemAction(){

                    @Override
                    public void exec() {
                        boolean valueChanged;
                        Object selectionValue = SPFontNamePopUp.this.combo.getSelectionValue();
                        String newValue = null;
                        if (selectionValue != null && !selectionValue.toString().trim().isEmpty()) {
                            newValue = selectionValue.toString();
                        }
                        if (valueChanged = SPFontNamePopUp.this.section.changeProperty(SPFontNamePopUp.this.pDescriptor.getId(), newValue)) {
                            SPFontNamePopUp.this.setData(SPFontNamePopUp.this.section.getElement(), SPFontNamePopUp.this.section.getElement().getPropertyActualValue(SPFontNamePopUp.this.pDescriptor.getId()), newValue);
                        }
                    }
                });
                this.refreshFont();
                this.dataSetted = true;
            }
            this.combo.setText(b.toString());
        }
    }

    protected void refreshFont() {
        if (this.pnode == null) {
            return;
        }
        List<String[]> fontsList = ModelUtils.getFontNames(this.pnode.getJasperConfiguration());
        ArrayList<ComboItem> itemsList = new ArrayList<ComboItem>();
        int i = 0;
        FontUtil util = FontUtil.getInstance((JasperReportsContext)this.pnode.getJasperConfiguration());
        int index = 0;
        while (index < fontsList.size()) {
            String[] fonts;
            String[] stringArray = fonts = fontsList.get(index);
            int n = fonts.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                org.eclipse.swt.graphics.Image resolvedImage = ResourceManager.getImage((String)element);
                if (resolvedImage == null) {
                    resolvedImage = new org.eclipse.swt.graphics.Image((Device)UIUtils.getDisplay(), ImageUtils.convertToSWT(SPFontNamePopUp.createFontImage(element, util)));
                    ResourceManager.addImage((String)element, (org.eclipse.swt.graphics.Image)resolvedImage);
                }
                itemsList.add(new ComboItem(element, true, resolvedImage, i, element, element));
                ++i;
                ++n2;
            }
            if (index + 1 != fontsList.size() && fonts.length > 0) {
                itemsList.add(new ComboItemSeparator(i));
                ++i;
            }
            ++index;
        }
        this.combo.setItems(itemsList);
    }

    public void propertyChange(AbstractSection section, String property, String value) {
        section.changeProperty(property, value);
    }

    @Override
    protected void createComponent(Composite parent) {
        if (this.combo == null) {
            this.combo = new WritableComboTableViewer(parent, 0x800000);
            this.combo.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JaspersoftStudioPlugin.getInstance().removePreferenceListener(SPFontNamePopUp.this.preferenceListener);
                }
            });
        }
    }

    @Override
    public Control getControl() {
        return this.combo != null ? this.combo.getControl() : null;
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("FONT_LIST")) {
                SPFontNamePopUp.this.refreshFont();
            }
        }
    }
}

