/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import java.text.MessageFormat;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPFontSize<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    private ToolBar buttons;
    private APropertyNode fontValue;
    private Image imageValueIncrement;
    private Image imageValueDecrement;
    public static Integer factor = 10;
    private String messageIncrement = MessageFormat.format(Messages.SPButon_Size_Increment, factor.toString());
    private String messageDecrement;

    public SPFontSize(Composite parent, AbstractSection section, T pDescriptor, APropertyNode fontValue) {
        super(parent, section, pDescriptor);
        this.imageValueIncrement = JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/edit-size-up.png");
        this.messageDecrement = MessageFormat.format(Messages.SPButon_Size_Decrement, factor.toString());
        this.imageValueDecrement = JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/edit-size-down.png");
        this.fontValue = fontValue;
        this.createComponent(parent);
    }

    protected void createCommand(boolean increment) {
        Object fontSize = this.section.getElement().getPropertyValue("fontSize");
        if (fontSize == null) {
            fontSize = this.fontValue.getPropertyActualValue("fontSize");
        }
        Float newValue = Float.valueOf(2.0f);
        if (fontSize != null) {
            newValue = (Float)fontSize;
            Integer plus = null;
            plus = increment ? Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)factor.intValue()) + 1) : Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)(-factor.intValue())) - 1);
            if (newValue.floatValue() + (float)plus.intValue() > 99.0f) {
                newValue = Float.valueOf(99.0f);
            } else if (newValue.floatValue() + (float)plus.intValue() > 0.0f) {
                newValue = Float.valueOf(newValue.floatValue() + (float)plus.intValue());
            }
            this.section.changeProperty("fontSize", newValue);
        }
    }

    private void createButton(final boolean increment) {
        String message;
        Image imageValue;
        if (increment) {
            imageValue = this.imageValueIncrement;
            message = this.messageIncrement;
        } else {
            imageValue = this.imageValueDecrement;
            message = this.messageDecrement;
        }
        ToolItem button = new ToolItem(this.buttons, 8);
        button.setImage(imageValue);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SPFontSize.this.createCommand(increment);
            }
        });
        button.setToolTipText(message);
    }

    @Override
    protected void createComponent(Composite parent) {
        if (this.fontValue != null) {
            this.buttons = new ToolBar(parent, 0x800040);
            this.createButton(true);
            this.createButton(false);
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        this.buttons.setEnabled(pnode.isEditable());
    }

    @Override
    public Control getControl() {
        return this.buttons;
    }
}

