/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ModelUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.type.JREnum;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class SPGroupTypeCombo<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    protected static final String GROUPPREFIX = "[Group] ";
    protected Combo combo;
    protected boolean hasFirstFakeElement = false;
    protected IPropertyDescriptor gDescriptor;

    public SPGroupTypeCombo(Composite parent, AbstractSection section, T pDescriptor, IPropertyDescriptor gDescriptor) {
        super(parent, section, pDescriptor);
        this.gDescriptor = gDescriptor;
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    public void createComponent(Composite parent) {
        this.combo = this.section.getWidgetFactory().createCombo(parent, 8);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SPGroupTypeCombo.this.hasFirstFakeElement && SPGroupTypeCombo.this.combo.getSelectionIndex() == 0) {
                    return;
                }
                String group = null;
                List dataEntries = (List)SPGroupTypeCombo.this.combo.getData();
                DataEntry comboVal = (DataEntry)dataEntries.get(SPGroupTypeCombo.this.combo.getSelectionIndex());
                boolean isGroup = false;
                if (comboVal.enumValue == SPGroupTypeCombo.this.getGroupEnum()) {
                    isGroup = true;
                    group = comboVal.groupName;
                }
                SPGroupTypeCombo.this.section.changeProperty(SPGroupTypeCombo.this.gDescriptor.getId(), Misc.nvl((String)group));
                if (isGroup) {
                    SPGroupTypeCombo.this.section.changeProperty(SPGroupTypeCombo.this.pDescriptor.getId(), SPGroupTypeCombo.this.getGroupEnum());
                } else {
                    SPGroupTypeCombo.this.section.changeProperty(SPGroupTypeCombo.this.pDescriptor.getId(), comboVal.enumValue);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.combo.setToolTipText(this.pDescriptor.getDescription());
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        this.createContextualMenu(pnode);
        this.setData((JREnum)pnode.getPropertyValue(this.pDescriptor.getId()), (String)pnode.getPropertyValue(this.gDescriptor.getId()));
    }

    protected boolean groupEquivalents(String group1, String group2) {
        boolean emptyGroup2;
        boolean emptyGroup1 = group1 == null || group1.trim().isEmpty();
        boolean bl = emptyGroup2 = group2 == null || group2.trim().isEmpty();
        if (emptyGroup1 || emptyGroup2) {
            return emptyGroup1 && emptyGroup2;
        }
        return ModelUtils.safeEquals(group1, group2);
    }

    protected void setData(JREnum jrEnum, String group) {
        this.hasFirstFakeElement = false;
        int selection = 0;
        boolean found = false;
        Pair<String[], List<DataEntry>> entries = this.getItems();
        String[] comboEntries = (String[])entries.getKey();
        List dataEntries = (List)entries.getValue();
        if (jrEnum != null) {
            int index = 0;
            for (DataEntry entry : dataEntries) {
                if (entry.enumValue == jrEnum && this.groupEquivalents(entry.groupName, group)) {
                    selection = index;
                    found = true;
                    break;
                }
                ++index;
            }
        }
        String[] comboItems = comboEntries;
        if (!found && group != null && !group.isEmpty()) {
            ArrayList<String> newItems = new ArrayList<String>();
            newItems.add(MessageFormat.format(Messages.SPGroupTypeCombo_groupNotFounError, group));
            newItems.addAll(new ArrayList<String>(Arrays.asList(comboEntries)));
            comboItems = newItems.toArray(new String[newItems.size()]);
            dataEntries.add(0, null);
            this.hasFirstFakeElement = true;
        }
        this.combo.setItems(comboItems);
        this.combo.setData((Object)dataEntries);
        this.combo.select(selection);
        this.combo.getParent().layout();
    }

    protected Pair<String[], List<DataEntry>> getItems() {
        ArrayList<String> lsIncs = new ArrayList<String>();
        ArrayList<DataEntry> dataEntries = new ArrayList<DataEntry>();
        JREnum[] jREnumArray = this.getEnumValues();
        int n = jREnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            JREnum en = jREnumArray[n2];
            if (en.equals(this.getGroupEnum())) {
                String gr;
                int n3;
                int n4;
                String[] stringArray;
                String[] groupItems;
                if (this.gDescriptor instanceof RWComboBoxPropertyDescriptor) {
                    stringArray = groupItems = ((RWComboBoxPropertyDescriptor)this.gDescriptor).getItems();
                    n4 = groupItems.length;
                    n3 = 0;
                    while (n3 < n4) {
                        gr = stringArray[n3];
                        if (gr != null && !gr.trim().isEmpty()) {
                            lsIncs.add(GROUPPREFIX + gr);
                            dataEntries.add(new DataEntry(en, gr));
                        }
                        ++n3;
                    }
                } else if (this.gDescriptor instanceof RComboBoxPropertyDescriptor) {
                    stringArray = groupItems = ((RComboBoxPropertyDescriptor)this.gDescriptor).getItems();
                    n4 = groupItems.length;
                    n3 = 0;
                    while (n3 < n4) {
                        gr = stringArray[n3];
                        if (gr != null && !gr.trim().isEmpty()) {
                            lsIncs.add(GROUPPREFIX + gr);
                            dataEntries.add(new DataEntry(en, gr));
                        }
                        ++n3;
                    }
                }
            } else {
                lsIncs.add(MessagesByKeys.getString(en.getName()));
                dataEntries.add(new DataEntry(en));
            }
            ++n2;
        }
        String[] comboEntries = lsIncs.toArray(new String[lsIncs.size()]);
        return new Pair((Object)comboEntries, dataEntries);
    }

    protected abstract JREnum[] getEnumValues();

    protected abstract JREnum getGroupEnum();

    protected abstract JREnum getByName(String var1);

    protected class DataEntry {
        private JREnum enumValue;
        private String groupName;

        public DataEntry(JREnum value, String groupName) {
            this.enumValue = value;
            this.groupName = groupName;
        }

        public DataEntry(JREnum value) {
            this(value, null);
        }
    }
}

