/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.editor.SimpleJRXMLEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MQuery;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.property.dataset.dialog.DatasetDialog;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.PatternEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPQueryButton<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    private Button editQueryButton;
    private MQuery mquery;
    private MDataset mdataset;

    public SPQueryButton(Composite parent, AbstractSection section, T pDescriptor, String buttonText) {
        super(parent, section, pDescriptor);
        this.createButton(parent, buttonText);
    }

    @Override
    protected void createComponent(Composite parent) {
    }

    protected void createButton(Composite parent, String buttonText) {
        this.editQueryButton = this.section.getWidgetFactory().createButton(parent, buttonText, 8);
        this.editQueryButton.setToolTipText(this.pDescriptor.getDescription());
        this.editQueryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectionHelper.getActiveJRXMLEditor() instanceof SimpleJRXMLEditor) {
                    UIUtils.showInformation((String)Messages.SPQueryButton_editorNotSuppoertedMessage);
                } else {
                    PatternEditor wizard = new PatternEditor();
                    Object queryText = SPQueryButton.this.mquery.getPropertyValue("text");
                    wizard.setValue(queryText != null ? queryText.toString() : "");
                    new DatasetDialog(SPQueryButton.this.editQueryButton.getShell(), SPQueryButton.this.mdataset, SPQueryButton.this.mquery.getJasperConfiguration(), SPQueryButton.this.section.getEditDomain().getCommandStack()).open();
                }
            }
        });
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        if (pnode instanceof MDataset) {
            this.mdataset = (MDataset)pnode;
        } else if (pnode instanceof MReport) {
            this.mdataset = (MDataset)pnode.getPropertyValue("mainDataset");
        }
        this.mquery = (MQuery)this.mdataset.getPropertyValue("query");
    }

    @Override
    public Control getControl() {
        return this.editQueryButton;
    }
}

