/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.combo.RWCComboPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.ResourceCache;

public class SPRWCCombo<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    protected CCombo combo;
    private ResourceCache cache = new ResourceCache();
    private boolean refresh = false;
    protected APropertyNode pnode;

    public SPRWCCombo(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.combo = new CCombo(parent, 0x800000);
        this.setNewItems((RWCComboPropertyDescriptor)this.pDescriptor);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SPRWCCombo.this.refresh) {
                    return;
                }
                if (SPRWCCombo.this.combo.getSelectionIndex() >= 0) {
                    SPRWCCombo.this.section.changeProperty(SPRWCCombo.this.pDescriptor.getId(), SPRWCCombo.this.combo.getItem(SPRWCCombo.this.combo.getSelectionIndex()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SPRWCCombo.this.refresh) {
                    return;
                }
                SPRWCCombo.this.section.changeProperty(SPRWCCombo.this.pDescriptor.getId(), SPRWCCombo.this.combo.getText());
            }
        });
        this.combo.setToolTipText(this.pDescriptor.getDescription());
        this.combo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SPRWCCombo.this.cache.dispose();
            }
        });
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.pnode = pnode;
        this.refresh = true;
        this.createContextualMenu(pnode);
        RWCComboPropertyDescriptor pd = (RWCComboPropertyDescriptor)this.pDescriptor;
        String str = (String)b;
        String[] items = this.combo.getItems();
        int selection = 0;
        int i = 0;
        while (i < items.length) {
            if (Misc.compare((String)items[i], (String)str, (boolean)pd.isCaseSensitive())) {
                selection = i;
                break;
            }
            ++i;
        }
        this.combo.select(selection);
        if (selection == 0 && pd.getItems().length > 0) {
            str = Misc.nvl((String)str);
            this.combo.setText(str);
        }
        int stringLength = this.combo.getText().length();
        this.combo.setSelection(new Point(stringLength, stringLength));
        this.refresh = false;
    }

    private Image createImage(String fontName) {
        Image stringImage = this.cache.getImage(fontName);
        if (stringImage == null) {
            Display display = Display.getCurrent();
            Color TRANSPARENT_COLOR = display.getSystemColor(1);
            Color DRAWING_COLOR = display.getSystemColor(2);
            PaletteData paletteData = new PaletteData(new RGB[]{TRANSPARENT_COLOR.getRGB(), DRAWING_COLOR.getRGB()});
            ImageData imageData = new ImageData(55, 15, 4, paletteData);
            imageData.transparentPixel = 0;
            stringImage = new Image((Device)display, imageData);
            GC stringGc = new GC((Drawable)stringImage);
            try {
                stringGc.setForeground(DRAWING_COLOR);
                stringGc.setBackground(TRANSPARENT_COLOR);
                stringGc.setFont(this.cache.getFont(fontName, 10, 0));
                stringGc.drawText("Sample", 0, 0);
            }
            finally {
                stringGc.dispose();
                this.cache.storeImage(fontName, stringImage);
            }
        }
        return stringImage;
    }

    public void setNewItems(RWCComboPropertyDescriptor pd) {
        MenuManager manager = new MenuManager("#PopUpMenu");
        String[] stringArray = pd.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            ComboAction action = new ComboAction(element, 0);
            action.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.createImage(element)));
            manager.add((IAction)action);
            manager.add((IContributionItem)new Separator());
            ++n2;
        }
        manager.add((IContributionItem)new Separator("additions-end"));
        Menu menu = manager.createContextMenu((Control)this.combo);
        this.combo.setMenu(menu);
    }

    private static class ComboAction
    extends Action {
        public ComboAction(String name, int style) {
            super(name, style);
        }
    }
}

