/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptors.JSSComboPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPReadCombo
extends ASPropertyWidget<IPropertyDescriptor> {
    protected Combo combo;
    private boolean refreshing = false;

    public SPReadCombo(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    protected void createComponent(Composite parent) {
        JSSComboPropertyDescriptor pd = (JSSComboPropertyDescriptor)this.pDescriptor;
        this.combo = this.section.getWidgetFactory().createCombo(parent, 8);
        this.combo.setItems(pd.getLabels());
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPReadCombo.this.handlePropertyChange();
            }
        });
        this.combo.setToolTipText(this.pDescriptor.getDescription());
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.createContextualMenu(pnode);
        this.setRefreshing(true);
        int index = 0;
        if (b != null) {
            index = ((Number)b).intValue();
        }
        this.combo.select(index);
        this.setRefreshing(false);
    }

    public void setItems(String[] items) {
        this.setRefreshing(true);
        String currentSelection = this.combo.getText();
        if (ArrayUtils.contains((Object[])items, (Object)currentSelection)) {
            this.combo.setItems(items);
            this.combo.select(ArrayUtils.indexOf((Object[])items, (Object)currentSelection));
            this.setRefreshing(false);
        } else {
            this.setRefreshing(false);
            this.combo.setItems(items);
            this.combo.select(0);
        }
    }

    protected void handlePropertyChange() {
        if (!this.isRefreshing()) {
            int index = this.combo.getSelectionIndex();
            this.section.changeProperty(this.pDescriptor.getId(), index);
        }
    }

    public String[] getItems() {
        return this.combo.getItems();
    }

    protected synchronized void setRefreshing(boolean value) {
        this.refreshing = value;
    }

    protected synchronized boolean isRefreshing() {
        return this.refreshing;
    }
}

