/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptors.JSSTextPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.AHistorySPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.CustomAutoCompleteField;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.inputhistory.InputHistoryCache;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPText<T extends IPropertyDescriptor>
extends AHistorySPropertyWidget<T> {
    protected CustomText ftext;
    protected APropertyNode pnode;
    protected String savedValue;
    private boolean editHappened = false;
    protected IContextActivation context;
    protected boolean disableFocusLost = false;

    public SPText(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.ftext;
    }

    @Override
    protected Text getTextControl() {
        return this.ftext;
    }

    protected int getStyle() {
        int style = 0;
        if (this.pDescriptor instanceof JSSTextPropertyDescriptor) {
            style = ((JSSTextPropertyDescriptor)this.pDescriptor).getStyle();
        }
        return style;
    }

    protected Point computeTextSize(int wHint, int hHint, boolean changed) {
        return this.ftext.standardComputeSize(wHint, hHint, changed);
    }

    @Override
    protected void createComponent(Composite parent) {
        this.ftext = new CustomText(parent, this.getStyle());
        this.autocomplete = new CustomAutoCompleteField((Control)this.ftext, (IControlContentAdapter)new TextContentAdapter(), InputHistoryCache.get(this.getHistoryKey()));
        if (UIUtil.isMacAndEclipse4()) {
            this.ftext.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SPText.this.editHappened = true;
                }
            });
        }
        this.ftext.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    SPText.this.disableFocusLost = true;
                    SPText.this.handleTextChanged(SPText.this.section, SPText.this.pDescriptor.getId(), SPText.this.ftext.getText());
                    SPText.this.disableFocusLost = false;
                }
                if (e.keyCode == 27 && !SPText.this.autocomplete.isPopupJustClosed()) {
                    SPText.this.autocomplete.setEnabled(false);
                    SPText.this.ftext.setText(SPText.this.savedValue);
                    SPText.this.autocomplete.setEnabled(true);
                }
                SPText.this.autocomplete.resetPopupJustClosed();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.ftext.setToolTipText(this.pDescriptor.getDescription());
        this.setWidth(parent, 15);
    }

    private void setWidth(Composite parent, int chars) {
        int w = SPText.getCharWidth((Control)this.ftext) * chars;
        if (w > 50) {
            w = 50;
        }
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            rd.width = w;
            this.ftext.setLayoutData(rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData rd = new GridData(768);
            rd.minimumWidth = w;
            rd.widthHint = w;
            this.ftext.setLayoutData(rd);
        }
    }

    @Override
    protected void handleFocusLost() {
        String currentValue = this.getCurrentValue();
        if (UIUtil.isMacAndEclipse4() && !this.editHappened) {
            this.ftext.setText(Misc.nvl((String)currentValue));
        }
        if (!this.disableFocusLost) {
            if (currentValue == null || !currentValue.equals(this.ftext.getText())) {
                this.handleTextChanged(this.section, this.pDescriptor.getId(), this.ftext.getText());
            }
            super.handleFocusLost();
        }
        if (UIUtil.isMacAndEclipse4()) {
            this.editHappened = false;
        }
    }

    protected String getCurrentValue() {
        Object v = this.section.getElement().getPropertyValue(this.pDescriptor.getId());
        if (v instanceof String) {
            return (String)v;
        }
        return null;
    }

    protected void handleTextChanged(AbstractSection section, Object property, String text) {
        section.changeProperty(property, text);
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.createContextualMenu(pnode);
        this.pnode = pnode;
        this.ftext.setEnabled(pnode.isEditable());
        if (b != null) {
            this.savedValue = b.toString();
            int oldpos = this.ftext.getLocation().x;
            this.ftext.setText(b.toString());
            if (b.toString().length() >= oldpos) {
                this.ftext.setSelection(oldpos, oldpos);
            }
        } else {
            this.savedValue = "";
            this.ftext.setText("");
        }
    }

    protected class CustomText
    extends Text {
        public CustomText(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return SPText.this.computeTextSize(wHint, hHint, changed);
        }

        public Point standardComputeSize(int wHint, int hHint, boolean changed) {
            return super.computeSize(wHint, hHint, changed);
        }

        protected void checkSubclass() {
        }

        public void setLayoutData(Object layoutData) {
            Object newData = layoutData;
            if (newData instanceof GridData) {
                GridData newGridData = (GridData)newData;
                if (newGridData.grabExcessHorizontalSpace && newGridData.horizontalAlignment == 4 && newGridData.widthHint == -1) {
                    int w = SPText.getCharWidth((Control)this) * 15;
                    if (w > 50) {
                        w = 50;
                    }
                    newGridData.widthHint = w;
                }
            }
            super.setLayoutData(newData);
        }
    }
}

