/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.IEnumDescriptors;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.UUID;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class SPToolBarEnum<T extends IPropertyDescriptor & IEnumDescriptors>
extends ASPropertyWidget<T> {
    private ToolItem[] toolItems;
    private ToolBar toolBar;
    private boolean refresh = false;
    private static final String IMAGE_KEY = "imageKey";
    private static final String GREY_IMAGE_ID_KEY = "greyImageId";

    public SPToolBarEnum(Composite parent, AbstractSection section, T pDescriptor, Image[] images, boolean showText) {
        super(parent, section, pDescriptor);
        this.setupImages(pDescriptor, images, showText);
    }

    public SPToolBarEnum(Composite parent, AbstractSection section, T pDescriptor, Image[] images) {
        this(parent, section, pDescriptor, images, true);
    }

    private void setupImages(T pDescriptor, Image[] images, boolean showText) {
        if (images != null) {
            int i = 0;
            int j = 0;
            while (i < this.toolItems.length) {
                if (images.length > j) {
                    this.toolItems[i].setImage(images[j]);
                    if (!showText) {
                        this.toolItems[i].setData(IMAGE_KEY, (Object)images[i]);
                        this.toolItems[i].setData(GREY_IMAGE_ID_KEY, (Object)(String.valueOf(UUID.randomUUID().toString()) + "greyScale"));
                        this.toolItems[i].setText("");
                    }
                }
                ++i;
                ++j;
            }
        }
    }

    @Override
    public Control getControl() {
        return this.toolBar;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.toolBar = new ToolBar(parent, 8519744);
        String[] enumItems = ((IEnumDescriptors)this.pDescriptor).getEnumItems();
        int j = 0;
        if (((IEnumDescriptors)this.pDescriptor).getType() != NullEnum.NOTNULL) {
            this.toolItems = new ToolItem[enumItems.length - 1];
            ++j;
        } else {
            this.toolItems = new ToolItem[enumItems.length];
        }
        int i = 0;
        while (i < this.toolItems.length) {
            final int index = i;
            this.toolItems[i] = new ToolItem(this.toolBar, 32);
            this.toolItems[i].setText(enumItems[index + j]);
            this.toolItems[i].setToolTipText(enumItems[index + j]);
            this.toolItems[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (SPToolBarEnum.this.refresh) {
                        return;
                    }
                    ToolItem[] toolItemArray = SPToolBarEnum.this.toolItems;
                    int n = SPToolBarEnum.this.toolItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem item = toolItemArray[n2];
                        if (item != e.widget) {
                            item.setSelection(false);
                        }
                        ++n2;
                    }
                    int val = index;
                    if (((IEnumDescriptors)SPToolBarEnum.this.pDescriptor).getType() != NullEnum.NOTNULL) {
                        ++val;
                    }
                    SPToolBarEnum.this.propertyChange(SPToolBarEnum.this.section, SPToolBarEnum.this.pDescriptor.getId(), SPToolBarEnum.this.toolItems[index].getSelection() ? Integer.valueOf(val) : null);
                }
            });
            ++i;
        }
    }

    public void propertyChange(AbstractSection section, Object property, Integer value) {
        section.changeProperty(property, value);
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        int i = 0;
        while (i < this.toolItems.length) {
            ToolItem currentItem = this.toolItems[i];
            Image originalImage = (Image)currentItem.getData(IMAGE_KEY);
            if (originalImage != null) {
                if (elementValue == null) {
                    ImageData grayData;
                    String grayImageKey = (String)currentItem.getData(GREY_IMAGE_ID_KEY);
                    Image grayImage = ResourceManager.getImage((String)grayImageKey);
                    if (grayImage == null && (grayData = ImageUtils.createGrayImage(originalImage)) != null) {
                        grayImage = new Image(originalImage.getDevice(), grayData);
                        ResourceManager.addImage((String)grayImageKey, (Image)grayImage);
                    }
                    if (grayImage != null) {
                        currentItem.setImage(grayImage);
                    }
                } else {
                    currentItem.setImage(originalImage);
                }
            }
            if (elementValue == null) {
                currentItem.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
                if (this.getLabel() != null) {
                    this.getLabel().setToolTipText(String.valueOf(Messages.common_inherited_attribute) + this.pDescriptor.getDescription());
                    this.getLabel().setForeground(UIUtils.INHERITED_COLOR);
                }
            } else {
                currentItem.setToolTipText(this.pDescriptor.getDescription());
                if (this.getLabel() != null) {
                    this.getLabel().setToolTipText(this.pDescriptor.getDescription());
                    this.getLabel().setForeground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND"));
                }
            }
            ++i;
        }
        this.setData(pnode, resolvedValue);
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.createContextualMenu(pnode);
        this.refresh = true;
        this.toolBar.setEnabled(pnode.isEditable());
        int index = 0;
        if (b != null) {
            index = ((Number)b).intValue();
        }
        if (((IEnumDescriptors)this.pDescriptor).getType() != NullEnum.NOTNULL) {
            --index;
        }
        int i = 0;
        while (i < this.toolItems.length) {
            this.toolItems[i].setSelection(i == index);
            ++i;
        }
        this.refresh = false;
    }
}

