/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPNumber;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPTransparency
extends SPNumber {
    private Composite composite;
    private Scale scale;
    private SelectionListener transparencyChangeListener;

    public SPTransparency(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    protected void createComponent(Composite parent) {
        this.composite = this.section.getWidgetFactory().createComposite(parent);
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.center = true;
        this.composite.setLayout((Layout)layout);
        this.scale = new Scale(this.composite, 256);
        this.scale.setMinimum(0);
        this.scale.setMaximum(100);
        this.scale.setIncrement(1);
        this.scale.setPageIncrement(5);
        RowData rd = new RowData();
        rd.width = 100;
        this.scale.setLayoutData((Object)rd);
        this.scale.setToolTipText(this.pDescriptor.getDescription());
        this.transparencyChangeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPTransparency.this.ftext.setValue(SPTransparency.this.scale.getSelection());
                SPTransparency.this.changeValue();
            }
        };
        this.scale.addSelectionListener(this.transparencyChangeListener);
        super.createComponent(this.composite);
        this.setBounds(0, 100);
    }

    @Override
    protected void changeValue() {
        boolean valueChanged;
        Number newValue = this.getValue();
        if (newValue != null) {
            newValue = Float.valueOf(newValue.floatValue() / 100.0f);
        }
        if (valueChanged = this.section.changeProperty(this.pDescriptor.getId(), newValue)) {
            this.setData(this.section.getElement(), this.section.getElement().getPropertyActualValue(this.pDescriptor.getId()), newValue);
        }
    }

    @Override
    protected void createContextualMenu(APropertyNode node) {
        this.createContextualMenu(node, (Control)this.scale, this.pDescriptor.getId().toString());
        this.createContextualMenu(node, (Control)this.ftext, this.pDescriptor.getId().toString());
    }

    @Override
    public void setDataNumber(Number resolvedNumber, Number ownNumber) {
        this.scale.removeSelectionListener(this.transparencyChangeListener);
        if (resolvedNumber != null) {
            int resolvedAlfa = Math.round(100.0f * resolvedNumber.floatValue());
            int oldpos = this.ftext.getCaretPosition();
            this.ftext.setValue(resolvedAlfa);
            this.scale.setSelection(resolvedAlfa);
            this.ftext.setInherited(ownNumber == null);
            if (this.ftext.getText().length() >= oldpos) {
                this.ftext.setSelection(oldpos, oldpos);
            }
        }
        this.scale.addSelectionListener(this.transparencyChangeListener);
    }
}

