/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.refactor;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.digester.Digester;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResetUuidCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            Job job = new Job("Reset report UUIDs"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Reset report UUIDs", -1);
                    for (Object element : (IStructuredSelection)selection) {
                        if (!(element instanceof IFile)) continue;
                        IFile f = (IFile)element;
                        JasperReportsConfiguration jConfig = JasperReportsConfiguration.getDefaultJRConfig(f);
                        JasperDesign jd = null;
                        InputStream in = null;
                        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                        try {
                            try {
                                Thread.currentThread().setContextClassLoader(jConfig.getClassLoader());
                                in = f.getContents();
                                jd = new JRXmlLoader((JasperReportsContext)jConfig, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)jConfig)).loadXML(new InputSource(in));
                                jConfig.setJasperDesign(jd);
                                JRXmlWriter writer = new JRXmlWriter((JasperReportsContext)jConfig);
                                writer.setExcludeUuids(true);
                                f.setContents((InputStream)new ByteArrayInputStream(writer.write((JRReport)jd, "UTF-8").getBytes("UTF-8")), 3, monitor);
                                f.refreshLocal(0, monitor);
                            }
                            catch (UnsupportedEncodingException | ParserConfigurationException | JRException | CoreException | SAXException e) {
                                UIUtils.showError((Throwable)e);
                                FileUtils.closeStream(in);
                                Thread.currentThread().setContextClassLoader(oldCL);
                                jConfig.dispose();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            FileUtils.closeStream(in);
                            Thread.currentThread().setContextClassLoader(oldCL);
                            jConfig.dispose();
                            throw throwable;
                        }
                        FileUtils.closeStream((Closeable)in);
                        Thread.currentThread().setContextClassLoader(oldCL);
                        jConfig.dispose();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        return null;
    }
}

