/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.repository;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.properties.view.ITabbedPropertySheetPageContributor;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.repository.IRepositoryViewProvider;
import com.jaspersoft.studio.repository.actions.Separator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.dnd.DelegatingDragAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

public class RepositoryView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    private TreeViewer treeViewer;
    private PropertyChangeListener propChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!RepositoryView.this.treeViewer.getTree().isDisposed()) {
                RepositoryView.this.treeViewer.refresh(true);
                RepositoryView.this.treeViewer.expandToLevel(evt.getNewValue(), 1);
            }
        }
    };
    private IPropertySheetPage propertySheetPage;
    private List<IRepositoryViewProvider> rprovs;
    private ExtensionManager extensionManager;
    private IToolBarManager topToolbarManager;

    public Object getAdapter(Class type) {
        if (type == IPropertySource.class) {
            return this.getPropertySheetPage();
        }
        if (type == IPropertySource2.class) {
            return this.getPropertySheetPage();
        }
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(type);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        }
        return this.propertySheetPage;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.jaspersoft.studio.doc.view_repository");
        this.treeViewer = new TreeViewer(composite);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        this.treeViewer.setInput((Object)this.getResources());
        this.treeViewer.expandToLevel(2);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).RepositoryView.this.rprovs = RepositoryView.this.getExtensionManager();
                        for (IRepositoryViewProvider rp : (this).RepositoryView.this.rprovs) {
                            rp.doubleClick((this).RepositoryView.this.treeViewer);
                        }
                    }
                });
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                RepositoryView.this.rprovs = RepositoryView.this.getExtensionManager();
                for (IRepositoryViewProvider rp : RepositoryView.this.rprovs) {
                    rp.handleTreeEvent(event);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IContributionItem[] iContributionItemArray = RepositoryView.this.topToolbarManager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem ci = iContributionItemArray[n2];
                    if (ci instanceof ActionContributionItem) {
                        IAction action = ((ActionContributionItem)ci).getAction();
                        action.setEnabled(action.isEnabled());
                    }
                    ++n2;
                }
                IActionBars actionBars = RepositoryView.this.getViewSite().getActionBars();
                actionBars.clearGlobalActionHandlers();
                List<IAction> alist = RepositoryView.this.fillContextMenu();
                if (alist != null) {
                    for (IAction act : alist) {
                        if (act instanceof Separator) continue;
                        actionBars.setGlobalActionHandler(act.getId(), act);
                    }
                }
            }
        });
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
        this.hookGlobalActions();
        this.addDNDListeners();
        this.rprovs = this.getExtensionManager();
        for (IRepositoryViewProvider rp : this.rprovs) {
            rp.addPropertyChangeListener(this.propChangeListener);
        }
    }

    public void dispose() {
        this.rprovs = this.getExtensionManager();
        for (IRepositoryViewProvider rp : this.rprovs) {
            rp.removePropertyChangeListener(this.propChangeListener);
        }
        super.dispose();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.getExtensionManager();
    }

    private void hookGlobalActions() {
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                RepositoryView.this.rprovs = RepositoryView.this.getExtensionManager();
                for (IRepositoryViewProvider rp : RepositoryView.this.rprovs) {
                    rp.hookKeyEvent(RepositoryView.this.treeViewer, event);
                }
            }
        });
    }

    public void createActions() {
    }

    private void createMenu() {
    }

    private void createToolbar() {
        this.topToolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.rprovs = this.getExtensionManager();
        for (IRepositoryViewProvider rp : this.rprovs) {
            Action[] actions = rp.getActions(this.treeViewer);
            if (actions == null) continue;
            Action[] actionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action a = actionArray[n2];
                this.topToolbarManager.add((IAction)a);
                ++n2;
            }
        }
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RepositoryView.this.fillMenu(mgr, RepositoryView.this.fillContextMenu());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
    }

    private void addDNDListeners() {
        int operations = 3;
        ArrayList<TransferDragSourceListener> dragListeners = new ArrayList<TransferDragSourceListener>();
        ArrayList<TransferDropTargetListener> dropListeners = new ArrayList<TransferDropTargetListener>();
        for (IRepositoryViewProvider rp : this.rprovs) {
            List<TransferDropTargetListener> tdtl;
            List<TransferDragSourceListener> tdsl = rp.getTransferDragSourceListeners(this.treeViewer);
            if (tdsl != null) {
                dragListeners.addAll(tdsl);
            }
            if ((tdtl = rp.getTransferDropTargetListeners(this.treeViewer)) == null) continue;
            dropListeners.addAll(tdtl);
        }
        if (!dragListeners.isEmpty()) {
            DelegatingDragAdapter dragAdapter = new DelegatingDragAdapter();
            for (TransferDragSourceListener dragListener : dragListeners) {
                dragAdapter.addDragSourceListener(dragListener);
            }
            this.treeViewer.addDragSupport(operations, dragAdapter.getTransfers(), (DragSourceListener)dragAdapter);
        }
        if (!dropListeners.isEmpty()) {
            DelegatingDropAdapter dropAdapter = new DelegatingDropAdapter();
            for (TransferDropTargetListener dropListener : dropListeners) {
                dropAdapter.addDropTargetListener(dropListener);
            }
            this.treeViewer.addDropSupport(operations, dropAdapter.getTransfers(), (DropTargetListener)dropAdapter);
        }
    }

    private List<IAction> fillContextMenu() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        ArrayList<IAction> alist = null;
        int i = 0;
        while (i < p.length) {
            Object obj = p[i].getLastSegment();
            if (obj instanceof ANode) {
                this.rprovs = this.getExtensionManager();
                ArrayList<IAction> tlist = new ArrayList<IAction>();
                for (IRepositoryViewProvider rp : this.rprovs) {
                    List<IAction> t = rp.fillContextMenu(this.treeViewer, (ANode)obj);
                    if (t == null) continue;
                    tlist.addAll(t);
                }
                if (tlist == null || tlist.isEmpty()) {
                    return null;
                }
                if (alist == null) {
                    alist = tlist;
                } else {
                    ArrayList<IAction> todelete = new ArrayList<IAction>();
                    for (IAction a : alist) {
                        if (tlist.contains(a)) continue;
                        todelete.add(a);
                    }
                    alist.removeAll(todelete);
                    if (alist.isEmpty()) {
                        return null;
                    }
                }
            }
            ++i;
        }
        return alist;
    }

    private void fillMenu(IMenuManager mgr, List<IAction> alist) {
        if (alist != null) {
            for (IAction act : alist) {
                if (act instanceof Separator) {
                    mgr.add((IContributionItem)new org.eclipse.jface.action.Separator());
                    continue;
                }
                mgr.add(act);
            }
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public ANode getResources() {
        MRoot rootNode = new MRoot(null, null);
        this.rprovs = this.getExtensionManager();
        for (IRepositoryViewProvider rp : this.rprovs) {
            rp.getNode(rootNode);
        }
        return rootNode;
    }

    private List<IRepositoryViewProvider> getExtensionManager() {
        if (this.extensionManager == null) {
            this.extensionManager = new ExtensionManager();
            this.extensionManager.init();
        }
        if (this.rprovs == null) {
            this.rprovs = this.extensionManager.getRepositoryProviders();
        }
        return this.rprovs;
    }

    public int getDefaultSelectedPageIndex() {
        return 0;
    }
}

