/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.statistics;

import java.net.URL;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class BooleanLinkFieldEditor
extends FieldEditor {
    private boolean wasSelected;
    private Button checkBox = null;
    private Link linkLabel = null;
    private GridData containerGridData = null;

    public BooleanLinkFieldEditor(String name, String label, Composite parent) {
        this.init(name, label);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData checkBoxData = new GridData();
        checkBoxData.verticalAlignment = 128;
        this.checkBox = this.getChangeControl(parent);
        this.checkBox.setLayoutData((Object)checkBoxData);
        GridData gd = new GridData(768);
        gd.widthHint = 500;
        this.getLinkControl(parent).setLayoutData((Object)gd);
        String text = this.getLabelText();
        if (text != null) {
            this.linkLabel.setText(text);
        }
    }

    public Control getDescriptionControl(Composite parent) {
        return this.getLinkControl(parent);
    }

    protected Button getChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 32);
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = BooleanLinkFieldEditor.this.checkBox.getSelection();
                    BooleanLinkFieldEditor.this.valueChanged(BooleanLinkFieldEditor.this.wasSelected, isSelected);
                    BooleanLinkFieldEditor.this.wasSelected = isSelected;
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BooleanLinkFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    protected Link getLinkControl(Composite parent) {
        if (this.linkLabel == null) {
            this.linkLabel = new Link(parent, 64);
            this.linkLabel.setFont(parent.getFont());
            this.linkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.linkLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BooleanLinkFieldEditor.this.linkLabel = null;
                }
            });
        } else {
            this.checkParent((Control)this.linkLabel, parent);
        }
        return this.linkLabel;
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        this.containerGridData.horizontalSpan = numColumns;
    }

    protected void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.containerGridData = new GridData(768);
        container.setLayoutData((Object)this.containerGridData);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        container.setLayout((Layout)containerLayout);
        this.doFillIntoGrid(container, containerLayout.numColumns);
    }

    protected void doLoad() {
        if (this.checkBox != null) {
            boolean value = this.getPreferenceStore().getBoolean(this.getPreferenceName());
            this.checkBox.setSelection(value);
            this.wasSelected = value;
        }
    }

    protected void doLoadDefault() {
        if (this.checkBox != null) {
            boolean value = this.getPreferenceStore().getDefaultBoolean(this.getPreferenceName());
            this.checkBox.setSelection(value);
            this.wasSelected = value;
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.checkBox.getSelection());
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        if (this.linkLabel != null) {
            this.linkLabel.setText(text);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.getLinkControl(parent).setEnabled(enabled);
        this.getChangeControl(parent).setEnabled(enabled);
    }
}

