/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.statistics;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.jface.util.Util;

public class OSIdentifier {
    private OSDescription currentOSDescription;
    private static final OSIdentifier INSTANCE;
    private static final String KEY_PRETTY_NAME = "PRETTY_NAME";
    private static final String KEY_LSB_DISTRIB_DESCRIPTION = "DISTRIB_DESCRIPTION";
    private static final String KEY_LSB_DISTRIB_CODENAME = "DISTRIB_CODENAME";

    static {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String architecture = System.getProperty("os.arch");
        INSTANCE = new OSIdentifier(name, version, architecture);
    }

    protected OSIdentifier(String name, String version, String arch) {
        try {
            if (name != null) {
                if (Util.isWindows()) {
                    this.currentOSDescription = new OSDescription(name, version, arch);
                } else if (Util.isMac()) {
                    this.currentOSDescription = new OSDescription("MacOS", version, arch);
                } else if (Util.isLinux()) {
                    this.initLinuxOsInfo(name, version, arch);
                }
            }
        }
        catch (Exception ex) {
            JasperReportsPlugin.getDefault().logError((Throwable)ex);
            ex.printStackTrace();
            this.currentOSDescription = null;
        }
        if (this.currentOSDescription == null) {
            this.currentOSDescription = new OSDescription(name, version, arch);
        }
    }

    public static String getName() {
        return OSIdentifier.INSTANCE.currentOSDescription.getName();
    }

    public static String getArchitecture() {
        return OSIdentifier.INSTANCE.currentOSDescription.getArchitecture();
    }

    public static String getVersion() {
        return OSIdentifier.INSTANCE.currentOSDescription.getVersion();
    }

    public static String getOSInfo() {
        return String.valueOf(OSIdentifier.getName()) + " " + OSIdentifier.getVersion() + " " + OSIdentifier.getArchitecture();
    }

    private void initLinuxOsInfo(String name, String version, String arch) {
        File fileVersion;
        File dir;
        OSDescription osInfo = this.getPlatformNameFromLsbRelease(name, version, arch);
        if (osInfo == null) {
            osInfo = this.getPlatformNameFromFile(name, version, arch, "/etc/system-release");
        }
        if (osInfo == null && (dir = new File("/etc/")).exists()) {
            osInfo = this.getPlatformNameFromFile(name, version, arch, this.getFileEndingWith(dir, "-release"));
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, this.getFileEndingWith(dir, "_version"));
            }
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, "/etc/issue");
            }
        }
        if ((fileVersion = new File("/proc/version")).exists() && osInfo == null) {
            osInfo = this.getPlatformNameFromFile(name, version, arch, fileVersion.getAbsolutePath());
        }
        if (osInfo == null) {
            osInfo = new OSDescription(name, version, arch);
        }
        this.currentOSDescription = osInfo;
    }

    private String getFileEndingWith(File dir, final String fileEndingWith) {
        File[] fileList = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(fileEndingWith);
            }
        });
        if (fileList.length > 0) {
            return fileList[0].getAbsolutePath();
        }
        return null;
    }

    private OSDescription getPlatformNameFromLsbRelease(String name, String version, String arch) {
        OSDescription result;
        block6: {
            result = null;
            String fileName = "/etc/lsb-release";
            File f = new File(fileName);
            FileReader fileReader = null;
            BufferedReader br = null;
            if (f.exists()) {
                try {
                    try {
                        fileReader = new FileReader(fileName);
                        br = new BufferedReader(fileReader);
                        result = this.readPlatformNameFromLsb(name, version, arch, br);
                    }
                    catch (IOException ex) {
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                        FileUtils.closeStream((Closeable)fileReader);
                        FileUtils.closeStream(br);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(fileReader);
                    FileUtils.closeStream(br);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)fileReader);
                FileUtils.closeStream((Closeable)br);
            }
        }
        return result;
    }

    private OSDescription getPlatformNameFromFile(String name, String version, String arch, String filename) {
        OSDescription result;
        block7: {
            result = null;
            if (filename != null) {
                File f = new File(filename);
                BufferedReader br = null;
                FileReader fileReader = null;
                if (f.exists()) {
                    try {
                        try {
                            fileReader = new FileReader(filename);
                            br = new BufferedReader(fileReader);
                            result = this.readPlatformName(name, version, arch, br);
                        }
                        catch (IOException ex) {
                            JaspersoftStudioPlugin.getInstance().logError(ex);
                            FileUtils.closeStream((Closeable)fileReader);
                            FileUtils.closeStream(br);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(fileReader);
                        FileUtils.closeStream(br);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)fileReader);
                    FileUtils.closeStream((Closeable)br);
                }
            }
        }
        return result;
    }

    private OSDescription readPlatformName(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String lineToReturn = null;
        int lineNb = 0;
        while ((line = br.readLine()) != null) {
            if (lineNb++ == 0) {
                lineToReturn = line;
            }
            if (!line.toUpperCase().trim().startsWith(KEY_PRETTY_NAME)) continue;
            return new OSDescription(line.substring(13, line.length() - 1), version, arch);
        }
        return new OSDescription(lineToReturn, version, arch);
    }

    private OSDescription readPlatformNameFromLsb(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribDescription = null;
        String distribCodename = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith(KEY_LSB_DISTRIB_DESCRIPTION)) {
                distribDescription = line.replace("DISTRIB_DESCRIPTION=", "").replace("\"", "");
                continue;
            }
            if (!line.startsWith(KEY_LSB_DISTRIB_CODENAME)) continue;
            distribCodename = line.replace("DISTRIB_CODENAME=", "");
        }
        if (distribDescription != null && distribCodename != null) {
            return new OSDescription(String.valueOf(distribDescription) + " (" + distribCodename + ")", version, arch);
        }
        return null;
    }

    private class OSDescription {
        private String name;
        private String architecture;
        private String version;

        private OSDescription(String name, String version, String architecture) {
            this.name = name;
            this.architecture = architecture;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

