/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.statistics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.preferences.util.PropertiesHelper;
import com.jaspersoft.studio.statistics.DefaultAuditProvider;
import com.jaspersoft.studio.statistics.OSIdentifier;
import com.jaspersoft.studio.statistics.UsageStatistic;
import com.jaspersoft.studio.statistics.UsagesContainer;
import com.jaspersoft.studio.statistics.VersionCheckResult;
import com.jaspersoft.studio.statistics.heartbeat.Heartbeat;
import com.jaspersoft.studio.statistics.messages.Messages;
import com.jaspersoft.studio.utils.ModelUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.osgi.framework.Bundle;

public class UsageManager {
    protected static final String UNKWNOW_VERSION = "Unknown";
    private static String CURRENT_VERSION = null;
    private static final String STATISTICS_SERVER_URL = "http://heartbeat.jaspersoft.com/heartbeat/jss/statistics";
    private static final String HEARTBEAT_SERVER_URL = "https://jasperstudio.sf.net/jsslastversion.php";
    private static final String BACKWARD_UUID_PROPERTY = "UUID";
    private static final int MINIMUM_WAIT_TIME = 5000;
    private static final String TIME_SERVER = "pool.ntp.org";
    private static final String PROPERTIES_FILE_NAME = "jss.properties";
    private static final String INFO_FILE_NAME = "info.properties";
    private static final String LOCK_INFO = "isLocked";
    private static final String TIMESTAMP_INFO = "lastStatsTimestamp";
    private static final String VERSION_INFO = "lastSubmittedVersion";
    private static final String ID_CATEGORY_SEPARATOR = "|";
    private boolean allowUsageCollection = false;
    private Properties usageStats = null;
    private Properties installationInfo = null;
    private boolean statisticUpdatedRecently = false;
    private Job writeStatsToDisk = new WriteUsageJob();
    private File statisticsFolder = ConfigurationManager.getAppDataFolder("Statistics");
    private static final String COMMUNITY_LOGIN_OK_FILENAME = ".community";
    private boolean telemetryDisabled = false;
    private IPropertyChangeListener preferencesListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("com.jaspersoft.studio.send_usage")) {
                UsageManager.this.allowUsageCollection = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("com.jaspersoft.studio.send_usage");
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProperty(String key, String value) {
        UsageManager usageManager = this;
        synchronized (usageManager) {
            this.getStatisticsContainer().setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String key) {
        UsageManager usageManager = this;
        synchronized (usageManager) {
            return this.getStatisticsContainer().getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUsageStatisticsOnDisk() {
        FileOutputStream out = null;
        UsageManager usageManager = this;
        synchronized (usageManager) {
            block8: {
                try {
                    try {
                        File propertiesFile = new File(this.statisticsFolder, PROPERTIES_FILE_NAME);
                        out = new FileOutputStream(propertiesFile.getAbsolutePath());
                        this.getStatisticsContainer().store(out, "Usage informations");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(Messages.UsageManager_errorWriteStatProperties, ex);
                        FileUtils.closeStream(out);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(out);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)out);
            }
        }
    }

    protected String getVersion() {
        if (CURRENT_VERSION == null) {
            CURRENT_VERSION = JaspersoftStudioPlugin.getInstance().getBundle().getVersion().toString();
            if (CURRENT_VERSION.endsWith(".qualifier")) {
                CURRENT_VERSION = String.valueOf(CURRENT_VERSION.substring(0, CURRENT_VERSION.lastIndexOf(".qualifier"))) + "-dev";
            }
            if (this.isPro()) {
                CURRENT_VERSION = String.valueOf(CURRENT_VERSION) + "-pro";
            }
        }
        return CURRENT_VERSION;
    }

    protected String getEclipseVersion() {
        try {
            String pluginId = Platform.getProduct().getId();
            Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
            String eclipseVersion = "";
            if (bundle != null) {
                eclipseVersion = bundle.getVersion().toString();
            }
            if (eclipseVersion != null && !eclipseVersion.isEmpty()) {
                return String.valueOf(pluginId) + "[" + eclipseVersion + "]";
            }
            return String.valueOf(pluginId) + "[Unknown Version]";
        }
        catch (Exception ex) {
            JaspersoftStudioPlugin.getInstance().logError(ex);
            return UNKWNOW_VERSION;
        }
    }

    protected long getCurrentTime() throws Exception {
        NTPUDPClient timeClient = new NTPUDPClient();
        InetAddress inetAddress = InetAddress.getByName(TIME_SERVER);
        TimeInfo timeInfo = timeClient.getTime(inetAddress);
        long returnTime = timeInfo.getMessage().getTransmitTimeStamp().getTime();
        Date time = new Date(returnTime);
        return time.getTime();
    }

    protected boolean checkUpload() {
        try {
            long actualMillis = this.getCurrentTime();
            String lastUpdate = this.getInstallationInfoContainer().getProperty(TIMESTAMP_INFO);
            if (lastUpdate != null) {
                long millisDiff = actualMillis - Long.parseLong(lastUpdate);
                int days = (int)(millisDiff / 86400000L);
                return days >= 7;
            }
            this.setInstallationInfo(TIMESTAMP_INFO, String.valueOf(actualMillis));
        }
        catch (Exception ex) {
            JaspersoftStudioPlugin.getInstance().logWarning(Messages.UsageManager_errorGetTime, ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getStatisticsContainer() {
        UsageManager usageManager = this;
        synchronized (usageManager) {
            block11: {
                if (this.usageStats == null) {
                    File propertiesFile = new File(this.statisticsFolder, PROPERTIES_FILE_NAME);
                    if (propertiesFile.exists()) {
                        FileInputStream input = null;
                        try {
                            try {
                                input = new FileInputStream(propertiesFile.getAbsolutePath());
                                this.usageStats = new Properties();
                                this.usageStats.load(input);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JaspersoftStudioPlugin.getInstance().logError(Messages.UsageManager_errorReadStatProperties, e);
                                FileUtils.closeStream((Closeable)input);
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            FileUtils.closeStream(input);
                            throw throwable;
                        }
                        FileUtils.closeStream((Closeable)input);
                    } else {
                        this.usageStats = new Properties();
                    }
                }
            }
        }
        return this.usageStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getInstallationInfoContainer() {
        UsageManager usageManager = this;
        synchronized (usageManager) {
            block11: {
                if (this.installationInfo == null) {
                    File propertiesFile = new File(this.statisticsFolder, INFO_FILE_NAME);
                    if (propertiesFile.exists()) {
                        FileInputStream input = null;
                        try {
                            try {
                                input = new FileInputStream(propertiesFile.getAbsolutePath());
                                this.installationInfo = new Properties();
                                this.installationInfo.load(input);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JaspersoftStudioPlugin.getInstance().logError(Messages.UsageManager_errorReadInfoProperties, e);
                                FileUtils.closeStream((Closeable)input);
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            FileUtils.closeStream(input);
                            throw throwable;
                        }
                        FileUtils.closeStream((Closeable)input);
                    } else {
                        this.installationInfo = new Properties();
                    }
                }
            }
            return this.installationInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInstallationInfo(String propertyName, String newValue) {
        UsageManager usageManager = this;
        synchronized (usageManager) {
            block9: {
                boolean equals;
                Properties info = this.getInstallationInfoContainer();
                String value = info.getProperty(propertyName);
                boolean bl = value == null ? newValue == null : (equals = value.equals(newValue));
                if (!equals) {
                    FileOutputStream out = null;
                    try {
                        try {
                            info.setProperty(propertyName, newValue);
                            File propertiesFile = new File(this.statisticsFolder, INFO_FILE_NAME);
                            out = new FileOutputStream(propertiesFile.getAbsolutePath());
                            info.store(out, "Installation information - This information are NEVER send to the statistics server, used only locally for configuration purpose");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JaspersoftStudioPlugin.getInstance().logError(Messages.UsageManager_errorWriteInfoProperties, ex);
                            FileUtils.closeStream(out);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(out);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStatistics() {
        block17: {
            BufferedReader responseReader = null;
            try {
                try {
                    String inputLine;
                    if (STATISTICS_SERVER_URL.trim().isEmpty()) break block17;
                    Executor exec = Executor.newInstance();
                    URI fullURI = new URI(STATISTICS_SERVER_URL);
                    HttpUtils.setupProxy((Executor)exec, (URI)fullURI);
                    HttpHost proxy = HttpUtils.getUnauthProxy((Executor)exec, (URI)fullURI);
                    Request req = Request.Post((String)STATISTICS_SERVER_URL);
                    req.addHeader("User-Agent", "Mozilla/5.0");
                    req.addHeader("Accept-Language", "en-US,en;q=0.5");
                    if (proxy != null) {
                        req.viaProxy(proxy);
                    }
                    UsagesContainer container = new UsagesContainer(ConfigurationManager.getInstallationUUID());
                    boolean fileChanged = false;
                    UsageManager usageManager = this;
                    synchronized (usageManager) {
                        Properties prop = this.getStatisticsContainer();
                        for (Object key : new ArrayList<Object>(prop.keySet())) {
                            try {
                                String[] id_category = key.toString().split(Pattern.quote(ID_CATEGORY_SEPARATOR));
                                String value = prop.getProperty(key.toString(), "0");
                                int usageNumber = Integer.parseInt(value);
                                String version = this.getVersion();
                                if (id_category.length == 3) {
                                    version = id_category[2];
                                } else {
                                    prop.remove(key);
                                    String fixed_key = String.valueOf(id_category[0]) + ID_CATEGORY_SEPARATOR + id_category[1] + ID_CATEGORY_SEPARATOR + version;
                                    prop.setProperty(fixed_key, value);
                                    fileChanged = true;
                                }
                                container.addStat(new UsageStatistic(id_category[0], id_category[1], version, usageNumber));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                prop.remove(key);
                                fileChanged = true;
                            }
                        }
                    }
                    if (fileChanged) {
                        this.writeStatsToDisk.cancel();
                        this.writeStatsToDisk.setPriority(20);
                        this.writeStatsToDisk.schedule(5000L);
                    }
                    ObjectMapper mapper = new ObjectMapper();
                    String serializedData = mapper.writeValueAsString((Object)container);
                    req.bodyForm((Iterable)Form.form().add("data", serializedData).build());
                    Response resp = req.execute();
                    HttpResponse response = resp.returnResponse();
                    StatusLine statusLine = response.getStatusLine();
                    HttpEntity entity = response.getEntity();
                    int responseCode = statusLine.getStatusCode();
                    responseReader = new BufferedReader(new InputStreamReader(entity.getContent()));
                    StringBuffer textResponse = new StringBuffer();
                    while ((inputLine = responseReader.readLine()) != null) {
                        textResponse.append(inputLine);
                    }
                    if (responseCode == 200 && ModelUtils.safeEquals(textResponse.toString(), "ok")) {
                        this.setInstallationInfo(TIMESTAMP_INFO, String.valueOf(this.getCurrentTime()));
                        break block17;
                    }
                    System.out.println("Response error: " + textResponse.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(Messages.UsageManager_errorStatUpload, ex);
                    FileUtils.closeStream(responseReader);
                }
            }
            finally {
                FileUtils.closeStream(responseReader);
            }
        }
    }

    protected boolean isPro() {
        return Platform.getBundle((String)"com.jaspersoft.studio.pro.doc") != null;
    }

    protected void moveStatisticsToFolder() {
        File statisticsFile;
        File applicationFolder;
        block12: {
            applicationFolder = this.statisticsFolder.getParentFile();
            File infoFile = new File(applicationFolder, INFO_FILE_NAME);
            if (infoFile.exists()) {
                try {
                    try {
                        org.apache.commons.io.FileUtils.moveFileToDirectory((File)infoFile, (File)this.statisticsFolder, (boolean)true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                        infoFile.delete();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    infoFile.delete();
                    throw throwable;
                }
                infoFile.delete();
            }
        }
        if ((statisticsFile = new File(applicationFolder, PROPERTIES_FILE_NAME)).exists()) {
            try {
                try {
                    org.apache.commons.io.FileUtils.moveFileToDirectory((File)statisticsFile, (File)this.statisticsFolder, (boolean)true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                    statisticsFile.delete();
                }
            }
            finally {
                statisticsFile.delete();
            }
        }
    }

    public void start() {
        this.moveStatisticsToFolder();
        this.allowUsageCollection = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("com.jaspersoft.studio.send_usage");
        this.allowUsageCollection = false;
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        if (this.allowUsageCollection) {
            Job uploadUsageStats = new Job(Messages.UsageManager_uploadJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    boolean isLocekd = Boolean.parseBoolean(UsageManager.this.getInstallationInfoContainer().getProperty(UsageManager.LOCK_INFO, Boolean.FALSE.toString()));
                    if (isLocekd) {
                        UsageManager.this.audit("jssApplicationCrashed", "Error");
                    } else {
                        try {
                            UsageManager.this.setInstallationInfo(UsageManager.LOCK_INFO, Boolean.TRUE.toString());
                        }
                        catch (Exception exception) {}
                    }
                    if (UsageManager.this.checkUpload()) {
                        UsageManager.this.sendStatistics();
                    }
                    return Status.OK_STATUS;
                }
            };
            uploadUsageStats.setPriority(30);
            uploadUsageStats.schedule();
        }
        if (!UIUtils.isDevMode()) {
            Job job = new Job(Messages.UsageManager_checkVersionJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    Heartbeat.run();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    public void stop() {
        this.setInstallationInfo(LOCK_INFO, Boolean.FALSE.toString());
        this.writeStatsToDisk.cancel();
        if (this.statisticUpdatedRecently) {
            this.writeUsageStatisticsOnDisk();
        }
    }

    public void audit(String used_action_id, String category) {
        if (!this.isTelemetryDisabled()) {
            DefaultAuditProvider.INSTANCE.audit(used_action_id, category);
        }
    }

    public void audit(String used_action_id, String category, Properties attributes) {
        DefaultAuditProvider.INSTANCE.audit(used_action_id, category, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void audit_set(String used_action_id, String cateogory, int usageNumber) {
        UsageManager usageManager = this;
        synchronized (usageManager) {
            if (this.allowUsageCollection) {
                String errorMessage = MessageFormat.format(Messages.UsageManager_errorSepratorReserved, ID_CATEGORY_SEPARATOR);
                Assert.isTrue((!used_action_id.contains(ID_CATEGORY_SEPARATOR) && !cateogory.contains(ID_CATEGORY_SEPARATOR) ? 1 : 0) != 0, (String)errorMessage);
                String id = String.valueOf(used_action_id) + ID_CATEGORY_SEPARATOR + cateogory + ID_CATEGORY_SEPARATOR + this.getVersion();
                this.setProperty(id, String.valueOf(usageNumber));
                this.statisticUpdatedRecently = true;
                this.writeStatsToDisk.cancel();
                this.writeStatsToDisk.setPriority(20);
                this.writeStatsToDisk.schedule(5000L);
            }
        }
    }

    public VersionCheckResult checkVersion() {
        String javaVersion;
        String uuid = ConfigurationManager.getInstallationUUID();
        String versionKnownByTheStats = this.getInstallationInfoContainer().getProperty(VERSION_INFO);
        int newInstallation = 0;
        PropertiesHelper ph = PropertiesHelper.getInstance();
        String backward_uuid = ph.getString(BACKWARD_UUID_PROPERTY, null);
        if (backward_uuid == null) {
            if (versionKnownByTheStats == null) {
                newInstallation = 1;
            } else if (!versionKnownByTheStats.equals(this.getVersion())) {
                newInstallation = 2;
            }
        } else {
            newInstallation = 2;
            this.setInstallationInfo(VERSION_INFO, this.getVersion());
        }
        String OS = OSIdentifier.getOSInfo();
        this.audit_set(OS, "OperativeSystem", 1);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(HEARTBEAT_SERVER_URL);
        urlBuilder.append("?version=");
        urlBuilder.append(this.getVersion());
        urlBuilder.append("&uuid=");
        urlBuilder.append(uuid);
        urlBuilder.append("&new=");
        urlBuilder.append(newInstallation);
        urlBuilder.append("&isRCP=");
        boolean isRCP = JaspersoftStudioPlugin.isRCP();
        urlBuilder.append(String.valueOf(isRCP));
        if (!isRCP) {
            urlBuilder.append("&eclipse_version=");
            urlBuilder.append(this.getEclipseVersion());
        }
        if ((javaVersion = System.getProperty("java.runtime.version")) != null) {
            urlBuilder.append("&java_version=");
            urlBuilder.append(javaVersion);
        }
        String urlstr = urlBuilder.toString();
        try {
            HttpResponse resp;
            int statusCode;
            Executor exec = Executor.newInstance();
            URI fullURI = new URI(urlstr);
            HttpUtils.setupProxy((Executor)exec, (URI)fullURI);
            HttpHost proxy = HttpUtils.getUnauthProxy((Executor)exec, (URI)fullURI);
            Request req = Request.Get((String)urlstr);
            if (proxy != null) {
                req.viaProxy(proxy);
            }
            if ((statusCode = (resp = exec.execute(req).returnResponse()).getStatusLine().getStatusCode()) == 200) {
                this.setInstallationInfo(VERSION_INFO, this.getVersion());
                if (backward_uuid != null) {
                    ph.removeString(BACKWARD_UUID_PROPERTY, "instance");
                }
                String response = new String(resp.getEntity().getContent().readAllBytes());
                String serverVersion = null;
                String optmsg = "";
                for (String inputLine : IOUtils.readLines((Reader)new StringReader(response))) {
                    if (serverVersion == null) {
                        serverVersion = inputLine.trim();
                        continue;
                    }
                    optmsg = String.valueOf(optmsg) + inputLine;
                }
                return new VersionCheckResult(serverVersion, optmsg, this.getVersion());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JaspersoftStudioPlugin.getInstance().logError(Messages.UsageManager_errorUpdateCheck, ex);
        }
        return new VersionCheckResult();
    }

    public Properties getInstallationProperties() {
        Properties props = new Properties();
        props.setProperty("os_info", OSIdentifier.getOSInfo());
        props.setProperty("os_name", OSIdentifier.getName());
        props.setProperty("os_version", OSIdentifier.getVersion());
        props.setProperty("os_arch", OSIdentifier.getArchitecture());
        props.setProperty("jss_version", this.getVersion());
        props.setProperty("java_version", System.getProperty("java.version", "undefined"));
        props.setProperty("java_vendor", System.getProperty("java.vendor", "undefined"));
        return props;
    }

    public void confirmSuccessfulCommunityLogin(String userEmail) {
        File communityOkFile = new File(ConfigurationManager.getAppDataFolder(), COMMUNITY_LOGIN_OK_FILENAME);
        try {
            if (userEmail != null && !userEmail.isEmpty()) {
                Properties props = this.getInstallationProperties();
                props.setProperty("email", userEmail);
                this.audit("InstallationInfo", "InstallationInfo", props);
            }
            communityOkFile.createNewFile();
            this.saveCommunityFile(communityOkFile);
        }
        catch (IOException e) {
            JaspersoftStudioPlugin.getInstance().logError(Messages.UsageManager_HiddenFileCreationError, e);
        }
    }

    private static SecretKey getSecretKey() {
        String keyString = ConfigurationManager.getInstallationUUID();
        keyString = keyString.replaceAll("-", "");
        byte[] strBytes = (String.valueOf(keyString) + keyString).getBytes();
        byte[] keyBytes = new byte[32];
        int i = 0;
        while (i < 32) {
            keyBytes[i] = strBytes[strBytes.length - i - 1];
            ++i;
        }
        return new SecretKeySpec(keyBytes, "AES");
    }

    private static byte[] createEncryptedContent() throws Exception {
        String msg = ConfigurationManager.getInstallationUUID();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKey secretKey = UsageManager.getSecretKey();
        byte[] ivBytes = new byte[cipher.getBlockSize()];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(ivBytes);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(1, (Key)secretKey, iv);
        byte[] randomData = new byte[4096];
        sr.nextBytes(randomData);
        msg = String.valueOf(msg) + "\n" + Base64.getEncoder().encodeToString(randomData);
        byte[] encryptedMessage = cipher.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        byte[] content = new byte[ivBytes.length + encryptedMessage.length];
        System.arraycopy(ivBytes, 0, content, 0, ivBytes.length);
        System.arraycopy(encryptedMessage, 0, content, ivBytes.length, encryptedMessage.length);
        return content;
    }

    protected void saveCommunityFile(File f) {
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(UsageManager.createEncryptedContent());
            fos.close();
        }
        catch (Exception exception) {}
    }

    public static boolean isCommunityLoginValid() {
        File communityOkFile = new File(ConfigurationManager.getAppDataFolder(), COMMUNITY_LOGIN_OK_FILENAME);
        if (!communityOkFile.exists()) {
            return false;
        }
        try {
            FileInputStream is = new FileInputStream(communityOkFile);
            byte[] content = ((InputStream)is).readAllBytes();
            ((InputStream)is).close();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] ivBytes = new byte[cipher.getBlockSize()];
            System.arraycopy(content, 0, ivBytes, 0, ivBytes.length);
            byte[] emBytes = new byte[content.length - ivBytes.length];
            System.arraycopy(content, ivBytes.length, emBytes, 0, emBytes.length);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            SecretKey secretKey = UsageManager.getSecretKey();
            cipher.init(2, (Key)secretKey, iv);
            String result = new String(cipher.doFinal(emBytes));
            String[] msgParts = result.split("\n");
            return ConfigurationManager.getInstallationUUID().equals(msgParts[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void disableTelemetry() {
        this.telemetryDisabled = true;
    }

    public boolean isTelemetryDisabled() {
        return this.telemetryDisabled;
    }

    private class WriteUsageJob
    extends Job {
        public WriteUsageJob() {
            super(Messages.UsageManager_writeJobName);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (UsageManager.this.statisticUpdatedRecently) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                UsageManager.this.statisticUpdatedRecently = false;
            }
            if (!monitor.isCanceled()) {
                UsageManager.this.writeUsageStatisticsOnDisk();
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

