/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.statistics.heartbeat;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.statistics.messages.Messages;
import com.jaspersoft.studio.utils.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class CommunityLoginQRCodeDialog
extends Dialog {
    public static final int CANCEL_ID = 1;
    public static final int VALIDATE_CODE_ID = 2;
    private Composite body;
    private Text codeTxt;
    private Button confirmButton;
    private String code = "";
    private String url = "";
    private Clipboard clipBoard = null;
    private Image qrCodeImg;
    private Font biggerFont;

    public CommunityLoginQRCodeDialog(Shell parentShell) {
        this(parentShell, null, null);
    }

    public CommunityLoginQRCodeDialog(Shell parentShell, String loginURL, String verificationCode) {
        super(parentShell);
        this.setShellStyle(67696);
        this.code = verificationCode;
        this.url = loginURL;
        this.clipBoard = new Clipboard(parentShell.getDisplay());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.horizontalSpacing = 0;
        gl_container.verticalSpacing = 0;
        gl_container.marginWidth = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        Composite headerCmp = new Composite(container, 0);
        headerCmp.setLayout((Layout)new GridLayout(1, false));
        headerCmp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        headerCmp.setBackground(SWTResourceManager.getColor((int)1));
        Label headerLogo = new Label(headerCmp, 0);
        headerLogo.setAlignment(0x1000000);
        headerLogo.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio", (String)"resources/js_community_400.png"));
        headerLogo.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        Label sep1 = new Label(container, 258);
        sep1.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite bodyCmp = this.getDialogBody(container);
        bodyCmp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label sep2 = new Label(container, 0x1000102);
        GridData sep2GD = new GridData(4, 1024, true, false, 1, 1);
        sep2GD.verticalIndent = 20;
        sep2.setLayoutData((Object)sep2GD);
        return container;
    }

    public Composite getDialogBody(Composite parent) {
        this.body = new Composite(parent, 0);
        GridData bodyGD = new GridData(4, 4, true, true);
        this.body.setLayoutData((Object)bodyGD);
        GridLayout bodyLayout = new GridLayout(1, false);
        bodyLayout.marginWidth = 20;
        bodyLayout.marginHeight = 0;
        this.body.setLayout((Layout)bodyLayout);
        int vertIndent = 20;
        Label detailsLbl1 = new Label(this.body, 0);
        detailsLbl1.setText(Messages.CommunityLoginQRCodeDialog_InfoMsg);
        GridData details1GD = new GridData(4, 4, true, false);
        details1GD.verticalIndent = vertIndent;
        detailsLbl1.setLayoutData((Object)details1GD);
        BufferedImage qrCodeBI = this.paintQRCode(300);
        ImageData qrCodeImageData = ImageUtils.convertToSWT(qrCodeBI);
        this.qrCodeImg = new Image((Device)UIUtils.getDisplay(), qrCodeImageData);
        Label qrCodeLbl = new Label(this.body, 2048);
        GridData qrCodeGD = new GridData(0x1000000, 0x1000000, true, false);
        qrCodeGD.widthHint = 300;
        qrCodeGD.heightHint = 300;
        qrCodeGD.verticalIndent = vertIndent;
        qrCodeLbl.setLayoutData((Object)qrCodeGD);
        qrCodeLbl.setImage(this.qrCodeImg);
        final Button button = new Button(this.body, 0);
        button.setText(Messages.CommunityLoginQRCodeDialog_CopyToClipboard);
        GridData buttonGD = new GridData(0x1000000, 4, false, false);
        button.setLayoutData((Object)buttonGD);
        button.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                TextTransfer textTransfer = TextTransfer.getInstance();
                CommunityLoginQRCodeDialog.this.clipBoard.setContents(new Object[]{CommunityLoginQRCodeDialog.this.url}, new Transfer[]{textTransfer});
                button.setText(Messages.CommunityLoginQRCodeDialog_CopiedToClipboard);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (button != null && !button.isDisposed()) {
                                    button.setText(Messages.CommunityLoginQRCodeDialog_CopyToClipboard);
                                }
                            }
                        });
                    }
                });
                t.start();
            }
        });
        Label detailsLbl2 = new Label(this.body, 0);
        GridData details2GD = new GridData(0x1000000, 4, true, false);
        details2GD.verticalIndent = vertIndent;
        details2GD.widthHint = 300;
        detailsLbl2.setText("Code");
        detailsLbl2.setLayoutData((Object)details2GD);
        this.codeTxt = new Text(this.body, 0x1000800);
        GridData codeGD = new GridData(0x1000000, 0x1000000, true, false);
        codeGD.widthHint = UIUtils.isWindows() ? 285 : 290;
        this.codeTxt.setLayoutData((Object)codeGD);
        FontData[] fD = this.codeTxt.getFont().getFontData();
        fD[0].setHeight(fD[0].getHeight() + 8);
        this.biggerFont = new Font((Device)this.body.getDisplay(), fD[0]);
        this.codeTxt.setFont(this.biggerFont);
        this.codeTxt.setText("");
        this.codeTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommunityLoginQRCodeDialog.this.confirmButton.setEnabled(CommunityLoginQRCodeDialog.this.isConfirmButtonEnabled());
            }
        });
        return this.body;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Cancel", false);
        this.confirmButton = this.createButton(parent, 2, Messages.CommunityLoginQRCodeDialog_ValidateCodeButtonTxt, true);
        this.confirmButton.setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        if (1 == buttonId) {
            this.cancelPressed();
        } else if (2 == buttonId) {
            String codeProvided = this.codeTxt.getText();
            if (!(codeProvided = codeProvided.replaceAll("[^0-9]", "")).equals(this.code)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.CommunityLoginQRCodeDialog_ErrorDialogTitle, (String)Messages.CommunityLoginQRCodeDialog_ErrorCodeMsg);
                return;
            }
            this.setReturnCode(0);
            this.okPressed();
        }
    }

    protected String getDialogTitle() {
        return Messages.CommunityLoginDialog_Title;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected boolean isResizable() {
        return false;
    }

    protected BufferedImage paintQRCode(int size) {
        BufferedImage qrCodeImg = null;
        try {
            Hashtable<EncodeHintType, Object> hintMap = new Hashtable<EncodeHintType, Object>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            hintMap.put(EncodeHintType.MARGIN, 0);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(this.url, BarcodeFormat.QR_CODE, size, size, hintMap);
            int matrixWidth = byteMatrix.getWidth();
            qrCodeImg = new BufferedImage(matrixWidth, matrixWidth, 1);
            qrCodeImg.createGraphics();
            Graphics2D graphics = (Graphics2D)qrCodeImg.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, matrixWidth, matrixWidth);
            graphics.setColor(Color.BLACK);
            int i = 0;
            while (i < matrixWidth) {
                int j = 0;
                while (j < matrixWidth) {
                    if (byteMatrix.get(i, j)) {
                        graphics.fillRect(i, j, 1, 1);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (WriterException e) {
            JaspersoftStudioPlugin.getInstance().logError(e);
        }
        return qrCodeImg;
    }

    private boolean isConfirmButtonEnabled() {
        return !StringUtils.isNullOrEmpty((String)this.codeTxt.getText().trim()) && !StringUtils.isNullOrEmpty((String)this.codeTxt.getText().trim());
    }

    public void create() {
        super.create();
        this.codeTxt.forceFocus();
    }

    public boolean close() {
        if (this.biggerFont != null) {
            this.biggerFont.dispose();
        }
        if (this.qrCodeImg != null) {
            this.qrCodeImg.dispose();
        }
        return super.close();
    }
}

