/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view;

import com.jaspersoft.studio.compatibility.ToolUtilitiesCompatibility;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.SelectionChangedListener;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.ResourceManager;

public class FormattingToolsView
extends ViewPart
implements IContributedContentsView {
    private ScrolledComposite scrollComp;
    private Composite mainContainer;
    private List<Control> controlList = new ArrayList<Control>();
    private int selectedGraphicalElements = 0;
    private int buttonsMinWidth = 200;
    private int buttonHeight = 30;
    private CachedSelectionProvider currentEditor = null;
    private IPartListener partChangeListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart editor) {
            FormattingToolsView.this.updateEditor(editor);
        }
    };
    private SelectionChangedListener selectionListener = new SelectionChangedListener(){

        @Override
        public void selectionChanged() {
            FormattingToolsView.this.updateSelection();
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getPage().addPartListener(this.partChangeListener);
    }

    private void updateEditor(IWorkbenchPart editor) {
        if (this.currentEditor != editor && editor instanceof CachedSelectionProvider) {
            CachedSelectionProvider cachedSelEditor;
            if (this.currentEditor != null) {
                cachedSelEditor = this.currentEditor;
                cachedSelEditor.getSelectionCache().removeSelectionChangeListener(this.selectionListener);
            }
            cachedSelEditor = (CachedSelectionProvider)editor;
            cachedSelEditor.getSelectionCache().addSelectionChangeListener(this.selectionListener);
            this.currentEditor = (CachedSelectionProvider)editor;
            this.updateSelection();
        }
    }

    private void updateSelection() {
        this.initializeContent();
        this.updateSelectedElements();
        this.refresh();
    }

    public IWorkbenchPart getContributingPart() {
        return (IWorkbenchPart)this.currentEditor;
    }

    private void refresh() {
        this.mainContainer.setRedraw(false);
        for (Control control : this.controlList) {
            IAction action = (IAction)control.getData();
            control.setEnabled(action.isEnabled());
        }
        this.mainContainer.setRedraw(true);
    }

    private void updateSelectedElements() {
        IWorkbenchPart editor = this.getContributingPart();
        this.selectedGraphicalElements = 0;
        if (editor instanceof CachedSelectionProvider) {
            CachedSelectionProvider cachedSelEditor = (CachedSelectionProvider)editor;
            List<EditPart> editparts = cachedSelEditor.getSelectionCache().getSelectionModelPartForType(MGraphicElement.class);
            this.selectedGraphicalElements = ToolUtilitiesCompatibility.getSelectionWithoutDependants(editparts).size();
        }
    }

    public void createPartControl(Composite parent) {
        this.scrollComp = new ScrolledComposite(parent, 512);
        this.scrollComp.setLayoutData((Object)new GridData(1808));
        this.scrollComp.setLayout((Layout)new GridLayout(1, false));
        this.scrollComp.setExpandVertical(true);
        this.scrollComp.setExpandHorizontal(true);
        this.scrollComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FormattingToolsView.this.refreshScrolledHeight();
            }
        });
        this.mainContainer = new Composite((Composite)this.scrollComp, 2048);
        this.mainContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrollComp.setContent((Control)this.mainContainer);
        this.mainContainer.setLayout((Layout)new ButtonFillLayout());
        this.updateEditor((IWorkbenchPart)SelectionHelper.getActiveJRXMLEditor());
    }

    private void refreshScrolledHeight() {
        if (this.controlList.isEmpty()) {
            return;
        }
        this.mainContainer.layout();
        int heightRequired = ((ButtonFillLayout)this.mainContainer.getLayout()).getHeight();
        this.scrollComp.setMinHeight(heightRequired + 10);
    }

    private void initializeContent() {
        ActionRegistry registry;
        if (this.controlList.isEmpty() && this.getContributingPart() != null && (registry = (ActionRegistry)this.getContributingPart().getAdapter(ActionRegistry.class)) != null) {
            this.mainContainer.setRedraw(false);
            this.generateButton(registry.getAction((Object)"org.eclipse.gef.align_top"), 2);
            this.generateButton(registry.getAction((Object)"org.eclipse.gef.align_bottom"), 2);
            this.generateButton(registry.getAction((Object)"org.eclipse.gef.align_left"), 2);
            this.generateButton(registry.getAction((Object)"org.eclipse.gef.align_right"), 2);
            this.generateButton(registry.getAction((Object)"org.eclipse.gef.align_center"), 2);
            this.generateButton(registry.getAction((Object)"org.eclipse.gef.align_middle"), 2);
            this.generateButton(registry.getAction((Object)"band_org.eclipse.gef.align_top"), 1);
            this.generateButton(registry.getAction((Object)"band_org.eclipse.gef.align_bottom"), 1);
            this.generateButton(registry.getAction((Object)"band_org.eclipse.gef.align_left"), 1);
            this.generateButton(registry.getAction((Object)"band_org.eclipse.gef.align_right"), 1);
            this.generateButton(registry.getAction((Object)"organizeastable"), 1);
            this.generateButton(registry.getAction((Object)"joinleft"), 2);
            this.generateButton(registry.getAction((Object)"joinright"), 2);
            this.generateButton(registry.getAction((Object)"samehspace"), 2);
            this.generateButton(registry.getAction((Object)"increasehspace"), 2);
            this.generateButton(registry.getAction((Object)"decreasehspace"), 2);
            this.generateButton(registry.getAction((Object)"removehspace"), 2);
            this.generateButton(registry.getAction((Object)"samevspace"), 2);
            this.generateButton(registry.getAction((Object)"increasevspace"), 2);
            this.generateButton(registry.getAction((Object)"decreasevspace"), 2);
            this.generateButton(registry.getAction((Object)"removevspace"), 2);
            this.generateButton(registry.getAction((Object)"size_WIDTH"), 2);
            this.generateButton(registry.getAction((Object)"matchwidthmin"), 2);
            this.generateButton(registry.getAction((Object)"matchwidthmax"), 2);
            this.generateButton(registry.getAction((Object)"size_HEIGHT"), 2);
            this.generateButton(registry.getAction((Object)"matchheightmin"), 2);
            this.generateButton(registry.getAction((Object)"matchheightmax"), 2);
            this.generateButton(registry.getAction((Object)"size_BOTH"), 2);
            this.generateButton(registry.getAction((Object)"band_BOTH"), 1);
            this.generateButton(registry.getAction((Object)"band_WIDTH"), 1);
            this.generateButton(registry.getAction((Object)"band_HEIGHT"), 1);
            this.generateButton(registry.getAction((Object)"band_org.eclipse.gef.align_center"), 1);
            this.generateButton(registry.getAction((Object)"band_org.eclipse.gef.align_middle"), 1);
            this.generateButton(registry.getAction((Object)"centerinparent"), 1);
            this.mainContainer.setRedraw(true);
            this.scrollComp.layout(true, true);
            this.refreshScrolledHeight();
        }
    }

    private void generateButton(IAction action, int numberOfSelectedElements) {
        if (action == null) {
            return;
        }
        Button button = new Button(this.mainContainer, 8);
        button.setText(action.getText());
        button.setImage(ResourceManager.getImage((ImageDescriptor)action.getImageDescriptor()));
        button.setToolTipText(action.getToolTipText());
        FakeActionEnabler enablerAction = new FakeActionEnabler(numberOfSelectedElements, action.getId());
        button.setEnabled(enablerAction.isEnabled());
        button.setData((Object)enablerAction);
        RowData buttonData = new RowData();
        button.setLayoutData((Object)buttonData);
        this.controlList.add((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAction action = (IAction)e.widget.getData();
                action.run();
            }
        });
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partChangeListener);
        super.dispose();
        if (this.currentEditor != null) {
            CachedSelectionProvider cachedSelEditor = this.currentEditor;
            cachedSelEditor.getSelectionCache().removeSelectionChangeListener(this.selectionListener);
            this.currentEditor = null;
        }
    }

    public void setFocus() {
        this.mainContainer.setFocus();
    }

    private class ButtonFillLayout
    extends Layout {
        private int height = 0;

        private ButtonFillLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return composite.getParent().getSize();
        }

        protected void layout(Composite composite, boolean flushCache) {
            int containerWidth = composite.getBounds().width;
            if (containerWidth < FormattingToolsView.this.buttonsMinWidth) {
                return;
            }
            Control[] children = composite.getChildren();
            int maximumColumns = containerWidth / FormattingToolsView.this.buttonsMinWidth;
            int fillWidth = containerWidth / maximumColumns - 1;
            int actualRow = 0;
            int actualCol = 0;
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                int newX = actualCol * fillWidth + 1;
                int newY = actualRow * FormattingToolsView.this.buttonHeight + 1;
                Rectangle newBounds = new Rectangle(newX, newY, fillWidth, FormattingToolsView.this.buttonHeight);
                control.setBounds(newBounds);
                if (++actualCol == maximumColumns) {
                    actualCol = 0;
                    ++actualRow;
                }
                this.height = newY + FormattingToolsView.this.buttonHeight;
                ++n2;
            }
        }

        public int getHeight() {
            return this.height;
        }
    }

    private class FakeActionEnabler
    extends Action {
        private String actionId;
        private int requiredElementSelected;

        public FakeActionEnabler(int requiredElements, String actionId) {
            this.requiredElementSelected = requiredElements;
            this.actionId = actionId;
        }

        public boolean isEnabled() {
            return FormattingToolsView.this.selectedGraphicalElements >= this.requiredElementSelected;
        }

        public void run() {
            ActionRegistry registry = (ActionRegistry)FormattingToolsView.this.getContributingPart().getAdapter(ActionRegistry.class);
            IAction action = registry.getAction((Object)this.actionId);
            action.run();
        }
    }
}

