/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.storage.PreferencesTemplateStylesStorage;
import com.jaspersoft.studio.style.view.TemplateViewProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;

public class TemplateStyleView
extends ViewPart
implements IContributedContentsView {
    private static PreferencesTemplateStylesStorage savedStylesStorage = new PreferencesTemplateStylesStorage();
    private CTabFolder folder;
    private List<TemplateViewProvider> viewProviders;

    public static PreferencesTemplateStylesStorage getTemplateStylesStorage() {
        return savedStylesStorage;
    }

    public IWorkbenchPart getContributingPart() {
        return this.getSite().getPage().getActiveEditor();
    }

    public void createPartControl(Composite parent) {
        this.folder = new CTabFolder(parent, 2048);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, false));
        this.folder.setSimple(false);
        this.folder.setMinimizeVisible(false);
        this.folder.setMaximizeVisible(false);
        this.folder.setBorderVisible(true);
        this.viewProviders = JaspersoftStudioPlugin.getExtensionManager().getStylesViewProvider();
        for (TemplateViewProvider viewProvider : this.viewProviders) {
            this.createTab(viewProvider);
            viewProvider.fillStyles();
        }
        savedStylesStorage.addPropertyChangeListener("TEMPLATESTYLES", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                for (TemplateViewProvider viewProvider : TemplateStyleView.this.viewProviders) {
                    viewProvider.notifyChange(arg0);
                }
            }
        });
        if (this.folder.getSelectionIndex() == -1) {
            this.folder.setSelection(0);
        }
    }

    private void createTab(TemplateViewProvider provider) {
        CTabItem tableItem = new CTabItem(this.folder, 0);
        tableItem.setText(provider.getTabName());
        tableItem.setImage(provider.getTabImage());
        Composite tableComposite = new Composite((Composite)this.folder, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        provider.createControls(tableComposite);
        tableItem.setControl((Control)tableComposite);
    }

    public void setFocus() {
        this.folder.setFocus();
    }
}

