/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view.text;

import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.gef.parts.text.StaticTextFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.text.TextFieldFigureEditPart;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.style.view.text.TextRestrictedTransferType;
import com.jaspersoft.studio.style.view.text.TextStyle;
import com.jaspersoft.studio.style.view.text.UpdateStyleCommand;
import com.jaspersoft.studio.utils.IOUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;

public class TextStyleTransferDropListener
extends AbstractTransferDropTargetListener {
    public TextStyleTransferDropListener(EditPartViewer viewer) {
        super(viewer);
        this.setTransfer((Transfer)TextRestrictedTransferType.getInstance());
    }

    protected void updateTargetEditPart() {
        this.setTargetEditPart(this.calculateTargetEditPart());
    }

    public void dragLeave(DropTargetEvent event) {
        this.setCurrentEvent(event);
    }

    protected void handleDrop() {
        if (this.getTargetEditPart() instanceof StaticTextFigureEditPart || this.getTargetEditPart() instanceof TextFieldFigureEditPart) {
            MTextElement textModel = (MTextElement)this.getTargetEditPart().getModel();
            TemplateStyle style = (TemplateStyle)IOUtils.readFromByteArray((byte[])this.getCurrentEvent().data);
            if (style != null && style instanceof TextStyle) {
                TextStyle selectedStyle = (TextStyle)style;
                if (textModel != null) {
                    CommandStack cs = this.getCommandStack();
                    UpdateStyleCommand command = new UpdateStyleCommand(textModel, selectedStyle);
                    if (cs != null) {
                        cs.execute((Command)command);
                    } else {
                        command.execute();
                    }
                }
            }
        }
    }

    protected EditPart calculateTargetEditPart() {
        EditPart ep = this.getViewer().findObjectAt(this.getDropLocation());
        if (ep instanceof StaticTextFigureEditPart || ep instanceof TextFieldFigureEditPart) {
            return ep;
        }
        return null;
    }

    protected CommandStack getCommandStack() {
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof JrxmlEditor) {
            JrxmlEditor editor = (JrxmlEditor)activeJRXMLEditor;
            return (CommandStack)editor.getAdapter(CommandStack.class);
        }
        return null;
    }

    protected void updateTargetRequest() {
    }
}

