/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class AutoCompletionHelper {
    private static String CTRL_SPACE = "Ctrl+Space";

    private AutoCompletionHelper() {
    }

    public static void enableAutoCompletion(final Text text, final List<String> allProposals) {
        AutoCompletionHelper.setAutoCompletion(text, null, allProposals);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AutoCompletionHelper.setAutoCompletion(text, text.getText(), allProposals);
            }
        });
    }

    private static void setAutoCompletion(Text text, String value, List<String> allProposals) {
        try {
            ContentProposalAdapter adapter = null;
            String[] defaultProposals = allProposals.toArray(new String[allProposals.size()]);
            SimpleContentProposalProvider scp = new SimpleContentProposalProvider(defaultProposals);
            scp.setFiltering(true);
            scp.setProposals(defaultProposals);
            KeyStroke ks = KeyStroke.getInstance((String)CTRL_SPACE);
            adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)scp, ks, null);
            adapter.setProposalAcceptanceStyle(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

