/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ClasspathComponent {
    private List<File> classpaths = new ArrayList<File>();
    private Control control;
    private TableViewer tviewer;
    private Table wtable;

    public List<String> getClasspaths() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.classpaths != null) {
            for (File f : this.classpaths) {
                paths.add(f.getAbsolutePath());
            }
        }
        return paths;
    }

    public void setClasspaths(List<String> paths) {
        this.classpaths = new ArrayList<File>();
        for (String path : paths) {
            File file = new File(path);
            this.classpaths.add(file);
        }
        this.tviewer.setInput(this.classpaths);
    }

    public ClasspathComponent(Composite parent) {
        this.createComponent(parent);
    }

    public Control getControl() {
        return this.control;
    }

    public TableViewer getViewer() {
        return this.tviewer;
    }

    public void createComponent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.wtable = new Table(composite, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 100;
        this.wtable.setLayoutData((Object)gd);
        this.wtable.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(this.wtable, 0)};
        col[0].setText(Messages.ClasspathComponent_1);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.wtable.setLayout((Layout)tlayout);
        this.tviewer = new TableViewer(this.wtable);
        this.tviewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tviewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(parent.getBackground());
        new NewButton(){

            @Override
            protected void afterElementAdded(Object selement) {
                ClasspathComponent.this.handleClasspathChanged();
            }
        }.createNewButtons(bGroup, this.tviewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4098);
                dialog.setFilterNames(new String[]{"JAR Files", "All Files (*.*)"});
                dialog.setFilterExtensions(new String[]{"*.jar", "*.*"});
                if (dialog.open() != null) {
                    String dir = dialog.getFilterPath();
                    String[] jars = dialog.getFileNames();
                    String delimiter = System.getProperty("file.separator");
                    File[] files = new File[jars.length];
                    int i = 0;
                    while (i < jars.length) {
                        files[i] = new File(String.valueOf(dir) + delimiter + jars[i]);
                        ++i;
                    }
                    return files;
                }
                return null;
            }
        });
        new DeleteButton(){

            @Override
            protected void afterElementDeleted(Object element) {
                ClasspathComponent.this.handleClasspathChanged();
            }
        }.createDeleteButton(bGroup, this.tviewer);
        this.control = composite;
        this.tviewer.setInput(this.classpaths);
    }

    protected void handleClasspathChanged() {
    }

    public class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            File file = (File)element;
            if (!file.exists()) {
                return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/error_tsk.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }
    }
}

