/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorLabelProvider;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class ColorStyledText
extends Composite {
    private static final int LINECOLOR_PREVIEW_WIDTH = 16;
    private static final int LINECOLOR_PREVIEW_HEIGHT = 16;
    private AlfaRGB color = null;
    private StyledText textArea;
    private String lastValidText;
    private Label lineColor;
    private List<ModifyListener> listener = new ArrayList<ModifyListener>();
    private boolean raiseEvents = true;
    private ColorLabelProvider provider = new ColorLabelProvider(NullEnum.NULL);
    private boolean refreshingGuard = false;
    private boolean disableAlphaSelection = false;
    private boolean enabled = true;

    public void DisableAlphaSelection(boolean value) {
        this.disableAlphaSelection = value;
    }

    public static boolean isNumber(int keyCode) {
        return keyCode >= 48 && keyCode <= 57;
    }

    public static boolean isCharachter(int keyCode) {
        return keyCode >= 97 && keyCode <= 122;
    }

    public static boolean isAlphanumeric(int keyCode) {
        return ColorStyledText.isNumber(keyCode) || ColorStyledText.isCharachter(keyCode);
    }

    public ColorStyledText(Composite parent) {
        super(parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 0;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.createButton();
        GridData textData = new GridData();
        textData.verticalAlignment = 0x1000000;
        textData.horizontalAlignment = 16384;
        textData.widthHint = 50;
        this.textArea = new StyledText((Composite)this, 4);
        this.textArea.setBackground(this.getBackground());
        this.textArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ColorStyledText.this.disposeProvider();
            }
        });
        this.textArea.setLayoutData((Object)textData);
        this.textArea.setAlignment(16384);
        this.textArea.addModifyListener((ModifyListener)new EditListener());
        this.textArea.setLayoutData((Object)new GridData(768));
    }

    private void createButton() {
        GridData lineColorData = new GridData();
        lineColorData.heightHint = 16;
        lineColorData.widthHint = 16;
        lineColorData.verticalAlignment = 4;
        lineColorData.horizontalAlignment = 0x1000000;
        this.lineColor = new Label((Composite)this, 0);
        this.lineColor.setLayoutData((Object)lineColorData);
        this.lineColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ColorStyledText.this.enabled && e.button == 1) {
                    ColorDialog cd = new ColorDialog(ColorStyledText.this.getShell());
                    cd.setText(Messages.common_line_color);
                    if (ColorStyledText.this.getColor() != null) {
                        cd.setRGB(ColorStyledText.this.getColor());
                    }
                    AlfaRGB newColor = null;
                    if (ColorStyledText.this.disableAlphaSelection) {
                        RGB rgbColor = cd.openRGB();
                        if (rgbColor != null) {
                            newColor = AlfaRGB.getFullyOpaque(rgbColor);
                        }
                    } else {
                        newColor = cd.openAlfaRGB();
                    }
                    if (newColor != null) {
                        ColorStyledText.this.setColor(newColor, true);
                    }
                }
            }
        });
    }

    public void setToolTipText(String string) {
        this.lineColor.setToolTipText(string);
        this.textArea.setToolTipText(string);
    }

    public void setHelp(String href) {
        HelpSystem.setHelp((Control)this.textArea, href);
    }

    private String leftPadWithZero(String baseString) {
        return StringUtils.leftPad((String)baseString, (int)2, (String)"0");
    }

    private String getHexFromRGB(RGB color) {
        int r = color.red;
        int g = color.green;
        int b = color.blue;
        String s = String.valueOf(this.leftPadWithZero(Integer.toHexString(r))) + this.leftPadWithZero(Integer.toHexString(g)) + this.leftPadWithZero(Integer.toHexString(b));
        return "#".concat(s.toUpperCase());
    }

    public void setColor(AlfaRGB newColor, boolean callListener) {
        this.raiseEvents = callListener;
        this.color = newColor;
        this.lastValidText = this.getHexFromRGB(this.color.getRgb());
        this.textArea.setText(this.lastValidText);
        this.raiseEvents = true;
    }

    private void disposeProvider() {
        if (this.provider != null) {
            this.provider.dispose();
        }
    }

    public void setColor(AlfaRGB newColor) {
        this.setColor(newColor, false);
    }

    public void addListener(ModifyListener listener) {
        this.listener.add(listener);
    }

    public AlfaRGB getColor() {
        return this.color;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.textArea.setEnabled(enabled);
    }

    public void setInhterited(boolean isInherithed) {
        if (isInherithed && !this.textArea.isDisposed()) {
            this.textArea.setForeground(UIUtils.INHERITED_COLOR);
        } else {
            this.textArea.setForeground(ColorConstants.black);
        }
    }

    public Menu getMenu() {
        return this.textArea.getMenu();
    }

    public void setMenu(Menu menu) {
        this.textArea.setMenu(menu);
        this.lineColor.setMenu(menu);
    }

    private class EditListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            if (!ColorStyledText.this.refreshingGuard) {
                ColorStyledText.this.refreshingGuard = true;
                String text = ColorStyledText.this.textArea.getText();
                RGB newColor = null;
                try {
                    if (text.startsWith("[") && text.endsWith("]")) {
                        int index1 = text.indexOf("[") + 1;
                        int index2 = text.indexOf(",");
                        int index3 = text.indexOf(",", index2 + 1);
                        int index4 = text.indexOf("]");
                        int redCompontent = Integer.valueOf(text.substring(index1, index2));
                        int greenCompontent = Integer.valueOf(text.substring(index2 + 1, index3));
                        int blueCompontent = Integer.valueOf(text.substring(index3 + 1, index4));
                        newColor = new RGB(redCompontent, greenCompontent, blueCompontent);
                    } else if (text.startsWith("#") && text.length() == 7) {
                        newColor = new RGB(Integer.valueOf(text.substring(1, 3), 16).intValue(), Integer.valueOf(text.substring(3, 5), 16).intValue(), Integer.valueOf(text.substring(5, 7), 16).intValue());
                    } else if (!text.startsWith("#") && text.length() == 6) {
                        newColor = new RGB(Integer.valueOf(text.substring(0, 2), 16).intValue(), Integer.valueOf(text.substring(2, 4), 16).intValue(), Integer.valueOf(text.substring(4, 6), 16).intValue());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (newColor != null) {
                    ColorStyledText.this.color = ColorStyledText.this.color != null ? new AlfaRGB(newColor, ColorStyledText.this.color.getAlfa()) : AlfaRGB.getFullyOpaque(newColor);
                    ColorStyledText.this.textArea.setText(ColorStyledText.this.getHexFromRGB(ColorStyledText.this.color.getRgb()));
                    if (ColorStyledText.this.lineColor != null) {
                        ColorStyledText.this.lineColor.setImage(ColorStyledText.this.provider.getImage(ColorStyledText.this.color, 16, 16));
                    }
                    if (ColorStyledText.this.raiseEvents) {
                        for (ModifyListener element : ColorStyledText.this.listener) {
                            element.modifyText(e);
                        }
                    }
                }
                ColorStyledText.this.refreshingGuard = false;
            }
        }
    }
}

