/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.swt.widgets.NumericText;
import java.text.NumberFormat;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class NullableSpinner
extends Composite {
    private NumericText text;
    private Composite buttonContainer;
    private Layout mainLayout = new Layout(){

        protected void layout(Composite parent, boolean flushCache) {
            Control[] children = parent.getChildren();
            Rectangle carea = parent.getClientArea();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child == NullableSpinner.this.text) {
                    child.setBounds(0, 0, carea.width - 15, carea.height);
                } else if (child == NullableSpinner.this.buttonContainer) {
                    child.setBounds(carea.width - 15, 0, 15, carea.height);
                }
                ++i;
            }
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int height;
            int width;
            Control[] children = composite.getChildren();
            Point textSize = children[0].computeSize(wHint != -1 ? wHint - 15 : -1, hHint);
            int n = width = wHint == -1 ? Math.max(textSize.x + 15, 45) : wHint;
            if (width < 16) {
                width = 16;
            }
            int n2 = height = hHint == -1 ? textSize.y : hHint;
            if (height < 18) {
                height = 18;
            }
            return new Point(width, height);
        }
    };

    public NullableSpinner(Composite parent, int style, int decimalDigitsShown, int decimalDigitsAccepted) {
        super(parent, style);
        this.setLayout(this.mainLayout);
        this.createContent(style, decimalDigitsShown, decimalDigitsAccepted);
        this.addTextListeners();
        this.text.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!Util.isWindows() && !Util.isLinux()) {
                    e.gc.setForeground(ColorConstants.lightGray);
                    Rectangle rect = NullableSpinner.this.text.getBounds();
                    e.gc.setLineStyle(1);
                    e.gc.drawLine(0, 0, rect.width, 0);
                    e.gc.drawLine(0, -1, 0, rect.height + 1);
                    e.gc.drawLine(0, rect.height - 1, rect.width, rect.height - 1);
                }
            }
        });
    }

    public NullableSpinner(Composite parent, int style) {
        this(parent, style, 0, 0);
    }

    private void createContent(int style, int decimalDigitsShown, int decimalDigitsAccepted) {
        boolean readOnly;
        this.createText(style ^ 0x800, decimalDigitsShown, decimalDigitsAccepted);
        this.buttonContainer = new Composite((Composite)this, 0);
        this.buttonContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Color currentBackgroun = gc.getBackground();
                Color currentForeground = gc.getForeground();
                Rectangle bounds = NullableSpinner.this.buttonContainer.getBounds();
                gc.setBackground(ColorConstants.white);
                gc.setForeground(ColorConstants.lightGray);
                gc.fillRectangle(0, 0, bounds.width, bounds.height);
                int middleButtonHeight = bounds.height / 2;
                int middleButtonWidth = bounds.width / 2;
                gc.drawLine(0, middleButtonHeight, bounds.width + 2, middleButtonHeight);
                gc.setAntialias(1);
                if (NullableSpinner.this.isEnabled()) {
                    gc.setBackground(ColorConstants.black);
                } else {
                    gc.setBackground(ColorConstants.lightGray);
                }
                int arrowHeight = 3;
                int arrowWidth = 3;
                int heightSpan = (middleButtonHeight - arrowHeight) / 2;
                int[] upArrow = new int[]{middleButtonWidth, heightSpan, middleButtonWidth - arrowWidth, middleButtonHeight - heightSpan, middleButtonWidth + arrowWidth, middleButtonHeight - heightSpan};
                int[] downArrow = new int[]{middleButtonWidth, bounds.height - heightSpan, middleButtonWidth - arrowWidth, middleButtonHeight + heightSpan, middleButtonWidth + arrowWidth, middleButtonHeight + heightSpan};
                gc.fillPolygon(upArrow);
                gc.fillPolygon(downArrow);
                gc.setLineStyle(1);
                gc.drawLine(0, -1, 0, bounds.height + 10);
                gc.drawLine(-1, 0, bounds.width, 0);
                gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height);
                gc.drawLine(-1, bounds.height - 1, bounds.width, bounds.height - 1);
                gc.setBackground(currentBackgroun);
                gc.setForeground(currentForeground);
            }
        });
        boolean bl = readOnly = (style & 8) == 8;
        if (!readOnly) {
            this.buttonContainer.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Rectangle bounds = NullableSpinner.this.buttonContainer.getBounds();
                    if (e.y < bounds.height / 2) {
                        NullableSpinner.this.increaseValue();
                    } else {
                        NullableSpinner.this.decreaseValue();
                    }
                }
            });
        }
    }

    private void createText(int style, int decimalDigitsShown, int decimalDigitsAccepted) {
        this.text = new NumericText(this, style, decimalDigitsShown, decimalDigitsAccepted);
    }

    private void addTextListeners() {
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    NullableSpinner.this.text.increment();
                }
                if (e.keyCode == 0x1000002) {
                    NullableSpinner.this.text.decrement();
                }
            }
        });
    }

    public void increaseValue() {
        this.text.increment();
        this.text.selectAll();
        this.text.setFocus();
    }

    public void decreaseValue() {
        this.text.decrement();
        this.text.selectAll();
        this.text.setFocus();
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    public Number getValue() {
        this.checkWidget();
        return this.text.getValue();
    }

    public Integer getValueAsInteger() {
        this.checkWidget();
        Number value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public Double getValueAsDouble() {
        this.checkWidget();
        Number value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public Long getValueAsLong() {
        this.checkWidget();
        Number value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    public Float getValueAsFloat() {
        this.checkWidget();
        Number value = this.getValue();
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    public void setIncrement(float value) {
        this.checkWidget();
        this.text.setIncrementStep(value);
    }

    public void setMaximum(double value) {
        this.checkWidget();
        this.text.setMaximum(value);
    }

    public void setMinimum(double value) {
        this.checkWidget();
        this.text.setMinimum(value);
    }

    public void setValue(Number selection) {
        this.checkWidget();
        this.text.setValue(selection);
    }

    public void setFormat(NumberFormat formatter) {
        this.text.setFormat(formatter);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setValues(Number selection, int minimum, int maximum, int increment, NumberFormat formatter) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setIncrement(increment);
        this.setFormat(formatter);
        this.setValue(selection);
    }

    public void setValues(Number selection, int minimum, int maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setValue(selection);
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public boolean forceFocus() {
        this.checkWidget();
        return this.text.forceFocus();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.text.setBackground(color);
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.text.setBackgroundImage(image);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.text.setCursor(cursor);
        this.buttonContainer.setCursor(cursor);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.buttonContainer.setEnabled(enabled);
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.text.setForeground(color);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.text.setMenu(menu);
        this.buttonContainer.setMenu(menu);
    }

    public void setToolTipText(String tooltipText) {
        super.setToolTipText(tooltipText);
        this.text.setToolTipText(tooltipText);
        this.buttonContainer.setToolTipText(tooltipText);
    }

    public void setInherited(boolean value) {
        this.text.setInherited(value);
    }

    public void setNullable(boolean value) {
        this.text.setNullable(value);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.text.addSelectionListener(listener);
    }

    public NumericText getTextControl() {
        return this.text;
    }

    public int getCaretPosition() {
        return this.text.getCaretPosition();
    }

    public void setSelection(int start, int end) {
        this.text.setSelection(start, end);
    }

    public void setDefaultValue(Number value) {
        this.text.setDefaultValue(value);
    }
}

