/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.ValidatedDecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.mihalis.opal.utils.StringUtil;

public class NumericCombo
extends Composite {
    private Combo controlCombo = null;
    private CCombo controlCCombo = null;
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private Double minimum = 0.0;
    private Double maximum = Double.MAX_VALUE;
    private boolean isNullable = true;
    private boolean isInherited = false;
    private Color currentColor = null;
    private boolean removeTrailZeroes = false;
    private NumberFormat formatter;
    private Number storedValue;
    private int increamentStep = 1;
    private boolean changedAfterFocus = false;
    private Number defaultValue = null;
    private static Point defaultSize = null;
    private Layout mainLayout = new Layout(){

        protected void layout(Composite parent, boolean flushCache) {
            Control[] children = parent.getChildren();
            Rectangle carea = parent.getClientArea();
            children[0].setBounds(0, 0, carea.width, carea.height);
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int width = wHint;
            int height = hHint;
            if (wHint == -1) {
                int n = width = defaultSize != null ? NumericCombo.defaultSize.x : 50;
            }
            if (hHint == -1) {
                height = defaultSize != null ? NumericCombo.defaultSize.y : 23;
            }
            return new Point(width, height);
        }
    };
    private VerifyListener inputVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (NumericCombo.this.controlCCombo != null) {
                e.doit = NumericCombo.this.verifyEntryAndStoreValueCCombo(e.text, e.keyCode);
            } else if (NumericCombo.this.controlCombo != null) {
                e.doit = NumericCombo.this.verifyEntryAndStoreValueCombo(e.text, e.keyCode);
            }
        }
    };
    private ModifyListener inputNotifier = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NumericCombo.this.fireListeners();
            NumericCombo.this.changedAfterFocus = true;
        }
    };
    private SelectionListener selectionNotifier = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            NumericCombo.this.fireListeners();
            NumericCombo.this.changedAfterFocus = true;
        }
    };

    public NumericCombo(Composite parent, int style, int decimalDigitsShown, int decimalDigitsAccepted) {
        super(parent, 0);
        this.createControls();
        this.currentColor = this.getForeground();
        this.formatter = new ValidatedDecimalFormat(decimalDigitsShown, decimalDigitsAccepted);
        this.addListeners();
    }

    public NumericCombo(Composite parent, NumberFormat formatter, int style) {
        super(parent, 0);
        this.createControls();
        this.currentColor = this.getForeground();
        this.addListeners();
        this.formatter = formatter;
        Assert.isTrue((formatter != null ? 1 : 0) != 0, (String)"The formatter can't be null");
    }

    protected void createControls() {
        this.setLayout(this.mainLayout);
        if (defaultSize == null) {
            Combo tempCombo = new Combo((Composite)this, 4);
            defaultSize = tempCombo.computeSize(-1, -1);
            tempCombo.dispose();
        }
        if (Util.isWindows()) {
            this.controlCCombo = new CCombo((Composite)this, 2048);
        } else {
            this.controlCombo = new Combo((Composite)this, 4);
        }
        this.layout();
    }

    protected void addListeners() {
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
        this.addComboSelectionListener(this.selectionNotifier);
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NumericCombo.this.setValue(NumericCombo.this.storedValue, true);
                if (NumericCombo.this.changedAfterFocus) {
                    NumericCombo.this.fireListeners();
                }
                NumericCombo.this.changedAfterFocus = false;
            }

            public void focusGained(FocusEvent e) {
                NumericCombo.this.changedAfterFocus = false;
            }
        });
    }

    public void setMinimum(Double min) {
        if (min == null || this.maximum == null || min < this.maximum) {
            this.minimum = min;
        }
    }

    public void setMaximum(Double max) {
        if (max == null || this.minimum == null || max > this.minimum) {
            this.maximum = max;
        }
    }

    public void setInherited(boolean value) {
        if (this.isInherited != value) {
            if (value) {
                this.currentColor = this.getForeground();
                this.setComboForeground(UIUtils.INHERITED_COLOR);
            } else {
                this.setComboForeground(this.currentColor);
            }
            this.isInherited = value;
        }
    }

    public void setForeground(Color color) {
        this.currentColor = this.getForeground();
        if (!this.isInherited) {
            this.setComboForeground(color);
        }
    }

    public Color getForeground() {
        if (this.controlCombo != null) {
            return this.controlCombo.getForeground();
        }
        if (this.controlCCombo != null) {
            this.controlCCombo.getForeground();
        }
        return null;
    }

    public void setValues(Number selection, Number minimum, Number maximum) {
        this.setMinimum(minimum != null ? Double.valueOf(minimum.doubleValue()) : null);
        this.setMaximum(maximum != null ? Double.valueOf(maximum.doubleValue()) : null);
        this.setValue(selection);
    }

    protected String formatNumber(Number value) {
        String result = value instanceof Float ? this.formatter.format(Double.parseDouble(value.toString())) : this.formatter.format(value);
        if (this.removeTrailZeroes && result.indexOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR) != -1) {
            result = result.replaceAll("0*$", "").replaceAll(String.valueOf(ValidatedDecimalFormat.PATTERN_DECIMAL_SEPARATOR) + "$", "");
        }
        return result;
    }

    protected boolean hasSameValue(Number newValue, Number storedValue) {
        if (ModelUtils.safeEquals(newValue, storedValue)) {
            return true;
        }
        String newFormat = null;
        if (newValue != null) {
            newFormat = this.formatNumber(newValue);
        }
        String storedFormat = null;
        if (storedValue != null) {
            storedFormat = this.formatNumber(storedValue);
        }
        return ModelUtils.safeEquals(newFormat, storedFormat);
    }

    public void setValue(Number selection) {
        if (selection != null) {
            this.setInherited(false);
            if (!this.hasSameValue(selection, this.storedValue)) {
                this.setValue(selection, true);
            }
        } else if (this.defaultValue != null) {
            this.setInherited(true);
            if (!this.hasSameValue(this.defaultValue, this.storedValue)) {
                this.setValue(null, true);
            }
        } else if (this.storedValue != null) {
            this.setInherited(false);
            this.setValue(null, false);
        }
    }

    protected void setValue(Number selection, boolean formatText) {
        this.checkWidget();
        if (selection != null) {
            if (this.minimum != null && selection.doubleValue() < this.minimum) {
                selection = this.minimum;
            } else if (this.maximum != null && selection.doubleValue() > this.maximum) {
                selection = this.maximum;
            }
            this.storedValue = selection;
            if (formatText) {
                this.setText(this.formatNumber(selection));
            } else {
                this.setText(selection.toString());
            }
            this.setSelection(new Point(0, this.getText().length()));
        } else if (this.isNullable) {
            this.storedValue = null;
            if (this.defaultValue != null) {
                if (formatText) {
                    this.setText(this.formatNumber(this.defaultValue));
                } else {
                    this.setText(this.defaultValue.toString());
                }
            } else {
                this.setText("");
            }
            this.setSelection(new Point(0, this.getText().length()));
        } else {
            throw new IllegalArgumentException("The widget can not accept null values when the isNullable property is false");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyEntryAndStoreValueCCombo(String entry, int keyCode) {
        Number newValue;
        block16: {
            Point cursorSelection;
            String work = "";
            if (keyCode == 127) {
                cursorSelection = this.controlCCombo.getSelection();
                String text = this.getText();
                work = cursorSelection.x == cursorSelection.y && cursorSelection.x != text.length() ? StringUtil.removeCharAt((String)this.getText(), (int)cursorSelection.x) : String.valueOf(text.substring(0, cursorSelection.x)) + text.substring(cursorSelection.y, text.length());
            } else if (keyCode == 8) {
                cursorSelection = this.controlCCombo.getSelection();
                if (cursorSelection.x == cursorSelection.y && cursorSelection.x != 0) {
                    work = StringUtil.removeCharAt((String)this.getText(), (int)(cursorSelection.x - 1));
                } else if (cursorSelection.x != cursorSelection.y) {
                    String text = this.getText();
                    work = String.valueOf(text.substring(0, cursorSelection.x)) + text.substring(cursorSelection.y, text.length());
                }
            } else if (keyCode == 0) {
                work = entry;
            } else {
                cursorSelection = this.controlCCombo.getSelection();
                if (cursorSelection.x == cursorSelection.y) {
                    work = StringUtil.insertString((String)this.getText(), (String)entry, (int)cursorSelection.x);
                } else if (cursorSelection.x != cursorSelection.y) {
                    String text = this.getText();
                    work = String.valueOf(text.substring(0, cursorSelection.x)) + entry + text.substring(cursorSelection.y, text.length());
                }
            }
            work = work.trim();
            if (work.isEmpty()) {
                if (!this.isNullable) return false;
                this.storedValue = null;
                return true;
            }
            try {
                newValue = this.formatter.parse(work);
                if (!(this.minimum != null && newValue.doubleValue() < this.minimum) && (this.maximum == null || !(newValue.doubleValue() > this.maximum))) break block16;
                return false;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        this.storedValue = newValue;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyEntryAndStoreValueCombo(String entry, int keyCode) {
        Number newValue;
        block16: {
            Point cursorSelection;
            String work = "";
            if (keyCode == 127) {
                work = StringUtil.removeCharAt((String)this.getText(), (int)this.getCaretPosition());
            } else if (keyCode == 8) {
                cursorSelection = this.controlCombo.getSelection();
                if (cursorSelection.x == cursorSelection.y && cursorSelection.x != 0) {
                    work = StringUtil.removeCharAt((String)this.getText(), (int)(this.getCaretPosition() - 1));
                } else if (cursorSelection.x != cursorSelection.y) {
                    String text = this.getText();
                    work = String.valueOf(text.substring(0, cursorSelection.x)) + text.substring(cursorSelection.y, text.length());
                }
            } else if (keyCode == 0) {
                work = entry;
            } else {
                cursorSelection = this.controlCombo.getSelection();
                if (cursorSelection.x == cursorSelection.y) {
                    work = StringUtil.insertString((String)this.getText(), (String)entry, (int)cursorSelection.x);
                } else if (cursorSelection.x != cursorSelection.y) {
                    String text = this.getText();
                    work = String.valueOf(text.substring(0, cursorSelection.x)) + entry + text.substring(cursorSelection.y, text.length());
                }
            }
            work = work.trim();
            if (work.isEmpty()) {
                if (!this.isNullable) return false;
                this.storedValue = null;
                return true;
            }
            try {
                newValue = this.formatter.parse(work);
                if (!(this.minimum != null && newValue.doubleValue() < this.minimum) && (this.maximum == null || !(newValue.doubleValue() > this.maximum))) break block16;
                return false;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        this.storedValue = newValue;
        return true;
    }

    public Integer getValueAsInteger() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.intValue();
    }

    public Long getValueAsLong() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.longValue();
    }

    public Double getValueAsDouble() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.doubleValue();
    }

    public Float getValueAsFloat() {
        if (this.storedValue == null) {
            return null;
        }
        return Float.valueOf(this.storedValue.floatValue());
    }

    public Number getValue() {
        return this.storedValue;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.add(listener);
    }

    public void setNullable(boolean value) {
        this.isNullable = value;
    }

    public void setIncrementStep(int step) {
        Assert.isTrue((step >= 0 ? 1 : 0) != 0, (String)"The step can't be negative");
        this.increamentStep = step;
    }

    public void increment() {
        if (this.storedValue == null) {
            double defaultMin = 0.0;
            if (this.defaultValue != null) {
                defaultMin = this.defaultValue.intValue();
            }
            if (this.minimum != null && this.minimum > defaultMin) {
                defaultMin = this.minimum;
            }
            this.storedValue = new Double(defaultMin);
        }
        double newValue = this.storedValue.doubleValue() + (double)this.increamentStep;
        this.setValue(newValue, true);
        this.fireListeners();
    }

    public void decrement() {
        if (this.storedValue == null) {
            double defaultMin = 0.0;
            if (this.defaultValue != null) {
                defaultMin = this.defaultValue.intValue();
            }
            if (this.minimum != null && this.minimum > defaultMin) {
                defaultMin = this.minimum;
            }
            this.storedValue = new Double(defaultMin);
            this.setValue(this.storedValue, true);
        } else {
            double newValue = this.storedValue.doubleValue() - (double)this.increamentStep;
            this.setValue(newValue, true);
        }
        this.fireListeners();
    }

    protected void checkSubclass() {
    }

    public void cut() {
        this.comboCut();
        this.setValue(null);
        this.fireListeners();
    }

    public void paste() {
        this.comboPaste();
        String work = this.getText().trim();
        if (work.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                Number newValue = this.formatter.parse(work);
                this.setValue(newValue, true);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.fireListeners();
    }

    public void setFormat(NumberFormat formatter) {
        Assert.isTrue((formatter != null ? 1 : 0) != 0, (String)"The formatter can't be null");
        this.formatter = formatter;
        String work = this.getText().trim();
        if (work.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                Number newValue = formatter.parse(work);
                this.setValue(newValue);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void setText(String string) {
        this.removeVerifyListener(this.inputVerifier);
        this.removeModifyListener(this.inputNotifier);
        this.setComboText(string);
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
    }

    protected void fireListeners() {
        Event e = new Event();
        e.widget = this;
        e.time = (int)System.currentTimeMillis();
        SelectionEvent selectionEvent = new SelectionEvent(e);
        for (SelectionListener s : this.selectionListeners) {
            s.widgetSelected(selectionEvent);
        }
    }

    public void setDefaultValue(Number value) {
        this.defaultValue = value;
    }

    public void select(int index) {
        this.removeComboSelectionListener(this.selectionNotifier);
        this.comboSelect(index);
        int count = this.getItemCount();
        if (index >= 0 && index < count) {
            if (index == this.getSelectionIndex()) {
                return;
            }
            this.setValue(Double.parseDouble(this.getItem(index)));
        }
        this.addComboSelectionListener(this.selectionNotifier);
    }

    public void setRemoveTrailZeroes(boolean value) {
        this.removeTrailZeroes = value;
    }

    protected void comboSelect(int index) {
        if (this.controlCombo != null) {
            this.controlCombo.select(index);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.select(index);
        }
    }

    public int getItemCount() {
        if (this.controlCombo != null) {
            return this.controlCombo.getItemCount();
        }
        if (this.controlCCombo != null) {
            return this.controlCCombo.getItemCount();
        }
        return 0;
    }

    public int getSelectionIndex() {
        if (this.controlCombo != null) {
            return this.controlCombo.getSelectionIndex();
        }
        if (this.controlCCombo != null) {
            return this.controlCCombo.getSelectionIndex();
        }
        return 0;
    }

    public String getItem(int index) {
        if (this.controlCombo != null) {
            return this.controlCombo.getItem(index);
        }
        if (this.controlCCombo != null) {
            return this.controlCCombo.getItem(index);
        }
        return null;
    }

    public void setItems(String[] items) {
        this.removeVerifyListener(this.inputVerifier);
        this.removeModifyListener(this.inputNotifier);
        this.setComboItems(items);
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
    }

    protected void setComboItems(String[] items) {
        if (this.controlCombo != null) {
            this.controlCombo.setItems(items);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.setItems(items);
        }
    }

    public int getCaretPosition() {
        if (this.controlCombo != null) {
            return this.controlCombo.getCaretPosition();
        }
        if (this.controlCCombo != null) {
            return this.controlCCombo.getSelection().y;
        }
        return 0;
    }

    public String getText() {
        if (this.controlCombo != null) {
            return this.controlCombo.getText();
        }
        if (this.controlCCombo != null) {
            return this.controlCCombo.getText();
        }
        return null;
    }

    public void setMenu(Menu menu) {
        if (this.controlCombo != null) {
            this.controlCombo.setMenu(menu);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.setMenu(menu);
        }
    }

    public Menu getMenu() {
        if (this.controlCombo != null) {
            this.controlCombo.getMenu();
        } else if (this.controlCCombo != null) {
            this.controlCCombo.getMenu();
        }
        return null;
    }

    protected void addVerifyListener(VerifyListener listener) {
        if (this.controlCombo != null) {
            this.controlCombo.addVerifyListener(listener);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.addVerifyListener(listener);
        }
    }

    protected void addModifyListener(ModifyListener listener) {
        if (this.controlCombo != null) {
            this.controlCombo.addModifyListener(listener);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.addModifyListener(listener);
        }
    }

    protected void removeVerifyListener(VerifyListener listener) {
        if (this.controlCombo != null) {
            this.controlCombo.removeVerifyListener(listener);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.removeVerifyListener(listener);
        }
    }

    protected void removeModifyListener(ModifyListener listener) {
        if (this.controlCombo != null) {
            this.controlCombo.removeModifyListener(listener);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.removeModifyListener(listener);
        }
    }

    protected void addComboSelectionListener(SelectionListener listener) {
        if (this.controlCombo != null) {
            this.controlCombo.addSelectionListener(listener);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.addSelectionListener(listener);
        }
    }

    protected void removeComboSelectionListener(SelectionListener listener) {
        if (this.controlCombo != null) {
            this.controlCombo.removeSelectionListener(listener);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.removeSelectionListener(listener);
        }
    }

    public void addFocusListener(FocusListener listener) {
        if (this.controlCombo != null) {
            this.controlCombo.addFocusListener(listener);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.addFocusListener(listener);
        }
    }

    protected void setComboText(String text) {
        if (this.controlCombo != null) {
            this.controlCombo.setText(text);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.setText(text);
        }
    }

    protected void comboCut() {
        if (this.controlCombo != null) {
            this.controlCombo.cut();
        } else if (this.controlCCombo != null) {
            this.controlCCombo.cut();
        }
    }

    protected void comboPaste() {
        if (this.controlCombo != null) {
            this.controlCombo.paste();
        } else if (this.controlCCombo != null) {
            this.controlCCombo.paste();
        }
    }

    public void setSelection(Point selection) {
        if (this.controlCombo != null) {
            this.controlCombo.setSelection(selection);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.setSelection(selection);
        }
    }

    public void setBackground(Color color) {
        if (this.controlCombo != null) {
            this.controlCombo.setBackground(color);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.setBackground(color);
        }
    }

    protected void setComboForeground(Color color) {
        if (this.controlCombo != null) {
            this.controlCombo.setForeground(color);
        } else if (this.controlCCombo != null) {
            this.controlCCombo.setForeground(color);
        }
    }
}

