/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.ValidatedDecimalFormat;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.utils.StringUtil;

public class NumericText
extends Text {
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private Double minimum = 0.0;
    private Double maximum = Double.MAX_VALUE;
    private boolean isNullable = true;
    private boolean isInherited = false;
    private Color currentColor = null;
    private NumberFormat formatter;
    private Number storedValue;
    private float increamentStep = 1.0f;
    private Number defaultValue = null;
    private boolean removeTrailZeroes = false;
    private boolean changedAfterFocus = false;
    private Color defaultBackgroundColor;
    protected VALIDATION_RESULT currentState = VALIDATION_RESULT.VALID;
    private VerifyListener inputVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            NumericText.this.currentState = NumericText.this.verifyEntryAndStoreValue(e.text, e.keyCode);
            e.doit = NumericText.this.currentState != VALIDATION_RESULT.NOT_VALID;
        }
    };
    private ModifyListener inputNotifier = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (NumericText.this.currentState == VALIDATION_RESULT.VALID) {
                NumericText.this.fireListeners();
            }
            NumericText.this.changedAfterFocus = true;
        }
    };
    private FocusListener focusNotifier = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            if (NumericText.this.changedAfterFocus) {
                if (NumericText.this.currentState == VALIDATION_RESULT.VALID || NumericText.this.currentState == VALIDATION_RESULT.VALID_NOT_FINAL) {
                    NumericText.this.fireListeners();
                }
                NumericText.this.setValue(NumericText.this.storedValue, true, NumericText.this.getText());
            }
        }

        public void focusGained(FocusEvent e) {
            NumericText.this.changedAfterFocus = false;
            if (Util.isMac()) {
                NumericText.this.setValue(NumericText.this.storedValue, true);
            }
        }
    };

    public NumericText(Composite parent, int style, int decimalDigitsShown, int decimalDigitsAccepted) {
        super(parent, style);
        this.currentColor = this.getForeground();
        this.formatter = new ValidatedDecimalFormat(decimalDigitsShown, decimalDigitsAccepted);
        this.addListeners();
        this.defaultBackgroundColor = this.getBackground();
    }

    public NumericText(Composite parent, NumberFormat formatter, int style) {
        super(parent, style);
        this.currentColor = this.getForeground();
        this.addListeners();
        this.formatter = formatter;
        Assert.isTrue((formatter != null ? 1 : 0) != 0, (String)"The formatter can't be null");
        this.defaultBackgroundColor = this.getBackground();
    }

    protected void addListeners() {
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
        this.addFocusListener(this.focusNotifier);
    }

    public void setMinimum(Double min) {
        if (min == null) {
            this.minimum = null;
        } else if (this.maximum == null || min < this.maximum) {
            this.minimum = min;
            if (this.storedValue != null && this.minimum != null && this.storedValue.doubleValue() < this.minimum) {
                this.setValue(this.minimum);
            }
        }
    }

    public void setMaximum(Double max) {
        if (max == null) {
            this.maximum = null;
        } else if (this.minimum == null || max > this.minimum) {
            this.maximum = max;
            if (this.storedValue != null && this.maximum != null && this.storedValue.doubleValue() > this.maximum) {
                this.setValue(this.maximum);
            }
        }
    }

    public void setInherited(boolean value) {
        if (this.isInherited != value) {
            if (value) {
                this.currentColor = this.getForeground();
                super.setForeground(UIUtils.INHERITED_COLOR);
            } else {
                super.setForeground(this.currentColor);
            }
            this.isInherited = value;
        }
    }

    public void setForeground(Color color) {
        this.currentColor = this.getForeground();
        if (!this.isInherited) {
            super.setForeground(color);
        }
    }

    public void setValues(Number selection, Number minimum, Number maximum) {
        this.setMinimum(minimum != null ? Double.valueOf(minimum.doubleValue()) : null);
        this.setMaximum(maximum != null ? Double.valueOf(maximum.doubleValue()) : null);
        this.setValue(selection);
    }

    protected boolean hasSameValue(Number newValue, Number storedValue) {
        if (this.currentState != VALIDATION_RESULT.VALID) {
            return false;
        }
        if (ModelUtils.safeEquals(newValue, storedValue)) {
            return true;
        }
        String newFormat = null;
        if (newValue != null) {
            newFormat = this.formatNumber(newValue, "");
        }
        String storedFormat = null;
        if (storedValue != null) {
            storedFormat = this.formatNumber(storedValue, "");
        }
        return ModelUtils.safeEquals(newFormat, storedFormat);
    }

    protected String formatNumber(Number value, String text) {
        String result = value instanceof Float ? this.formatter.format(Double.parseDouble(value.toString())) : this.formatter.format(value);
        if (this.removeTrailZeroes && result.indexOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR) != -1) {
            String trailingDecimal = StringUtils.getTrailingZeros((String)text, (char)ValidatedDecimalFormat.DECIMAL_SEPARATOR);
            result = result.replaceAll("0*$", "").replaceAll(String.valueOf(ValidatedDecimalFormat.PATTERN_DECIMAL_SEPARATOR) + "$", "");
            result = String.valueOf(result) + trailingDecimal;
        }
        return result;
    }

    public void setValue(Number selection) {
        this.setValue(selection, "");
    }

    public void setValue(Number selection, String text) {
        if (selection != null) {
            this.setInherited(false);
            if (!this.hasSameValue(selection, this.storedValue)) {
                this.setValue(selection, true, text);
            }
        } else if (this.defaultValue != null) {
            this.setInherited(true);
            if (!this.hasSameValue(this.defaultValue, this.storedValue)) {
                this.setValue(null, true, text);
            }
        } else if (this.storedValue != null) {
            this.setInherited(false);
            this.setValue(null, false, text);
        }
    }

    protected void setValue(Number selection, boolean formatText) {
        this.setValue(selection, formatText, "");
    }

    protected void setValue(Number selection, boolean formatText, String text) {
        this.checkWidget();
        if (selection != null) {
            if (this.minimum != null && selection.doubleValue() < this.minimum || this.maximum != null && selection.doubleValue() > this.maximum) {
                this.updateBackground(ColorConstants.red);
                this.currentState = VALIDATION_RESULT.OUT_OF_BOUNDS;
            } else {
                this.updateBackground(this.defaultBackgroundColor);
                this.currentState = VALIDATION_RESULT.VALID;
                this.storedValue = selection;
            }
            if (formatText) {
                this.setText(this.formatNumber(selection, text));
            } else {
                this.setText(selection.toString());
            }
        } else if (this.isNullable) {
            this.updateBackground(this.defaultBackgroundColor);
            this.currentState = VALIDATION_RESULT.VALID;
            this.storedValue = null;
            if (this.defaultValue != null) {
                if (formatText) {
                    this.setText(this.formatNumber(this.defaultValue, text));
                } else {
                    this.setText(this.defaultValue.toString());
                }
            } else {
                this.setText("");
            }
        } else {
            throw new IllegalArgumentException("The widget can not accept null values when the isNullable property is false");
        }
    }

    protected String updateString(String entry, int keyCode, String text, Point cursorSelection) {
        String work = "";
        if (keyCode == 127) {
            work = cursorSelection.x == cursorSelection.y && cursorSelection.x != text.length() ? StringUtil.removeCharAt((String)this.getText(), (int)this.getCaretPosition()) : String.valueOf(text.substring(0, cursorSelection.x)) + text.substring(cursorSelection.y, text.length());
        } else if (keyCode == 8) {
            if (cursorSelection.x == cursorSelection.y && cursorSelection.x != 0) {
                work = StringUtil.removeCharAt((String)this.getText(), (int)(this.getCaretPosition() - 1));
            } else if (cursorSelection.x != cursorSelection.y) {
                work = String.valueOf(text.substring(0, cursorSelection.x)) + text.substring(cursorSelection.y, text.length());
            }
        } else if (keyCode == 0) {
            work = entry;
        } else if (cursorSelection.x == cursorSelection.y) {
            work = StringUtil.insertString((String)this.getText(), (String)entry, (int)this.getCaretPosition());
        } else if (cursorSelection.x != cursorSelection.y) {
            work = String.valueOf(text.substring(0, cursorSelection.x)) + entry + text.substring(cursorSelection.y, text.length());
        }
        work = work.trim();
        return work;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VALIDATION_RESULT verifyEntryAndStoreValue(String entry, int keyCode) {
        Point cursorSelection = this.getSelection();
        String text = this.getText();
        String work = this.updateString(entry, keyCode, text, cursorSelection);
        if (work.isEmpty()) {
            if (!this.isNullable) return VALIDATION_RESULT.NOT_VALID;
            this.storedValue = null;
        } else {
            try {
                Number newValue = this.formatter.parse(work);
                if (this.minimum != null && newValue.doubleValue() < this.minimum || this.maximum != null && newValue.doubleValue() > this.maximum) {
                    this.updateBackground(ColorConstants.red);
                    return VALIDATION_RESULT.OUT_OF_BOUNDS;
                }
                this.storedValue = newValue;
            }
            catch (ParseException parseException) {
                return VALIDATION_RESULT.NOT_VALID;
            }
        }
        this.updateBackground(this.defaultBackgroundColor);
        if (!String.valueOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR).equals(entry) && (keyCode != 127 && keyCode != 8 || !work.endsWith(String.valueOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR)))) return VALIDATION_RESULT.VALID;
        return VALIDATION_RESULT.VALID_NOT_FINAL;
    }

    protected void updateBackground(Color color) {
        if (Util.isMac() && this.isFocusControl() && !ModelUtils.safeEquals(color, super.getBackground())) {
            this.removeFocusListener(this.focusNotifier);
            Point caretPosition = this.getSelection();
            boolean oldEnabled = this.getEnabled();
            this.setEnabled(false);
            super.setBackground(color);
            this.setEnabled(oldEnabled);
            this.setFocus();
            this.setSelection(caretPosition.x);
            this.addFocusListener(this.focusNotifier);
        } else {
            super.setBackground(color);
        }
    }

    public Integer getValueAsInteger() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.intValue();
    }

    public Long getValueAsLong() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.longValue();
    }

    public Double getValueAsDouble() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.doubleValue();
    }

    public Float getValueAsFloat() {
        if (this.storedValue == null) {
            return null;
        }
        return Float.valueOf(this.storedValue.floatValue());
    }

    public BigDecimal getValueAsBigDecimal() {
        if (this.storedValue == null) {
            return null;
        }
        return new BigDecimal(this.storedValue.toString());
    }

    public Number getValue() {
        return this.storedValue;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.add(listener);
    }

    public void setNullable(boolean value) {
        this.isNullable = value;
    }

    public void setIncrementStep(float step) {
        Assert.isTrue((step >= 0.0f ? 1 : 0) != 0, (String)"The step can't be negative");
        this.increamentStep = step;
    }

    public void increment() {
        if (this.storedValue == null) {
            double defaultMin = 0.0;
            if (this.defaultValue != null) {
                defaultMin = this.defaultValue.intValue();
            }
            if (this.minimum != null && this.minimum > defaultMin) {
                defaultMin = this.minimum;
            }
            this.storedValue = new Double(defaultMin);
        }
        double newValue = this.storedValue.doubleValue() + (double)this.increamentStep;
        if (this.minimum != null && newValue >= this.minimum && this.maximum != null && newValue <= this.maximum) {
            this.setValue((Number)newValue, true);
        }
        this.fireListeners();
    }

    public void decrement() {
        if (this.storedValue == null) {
            double defaultMin = 0.0;
            if (this.defaultValue != null) {
                defaultMin = this.defaultValue.intValue();
            }
            if (this.minimum != null && this.minimum > defaultMin) {
                defaultMin = this.minimum;
            }
            this.storedValue = new Double(defaultMin);
            this.setValue(this.storedValue, true);
        } else {
            double newValue = this.storedValue.doubleValue() - (double)this.increamentStep;
            if (this.minimum != null && newValue >= this.minimum && this.maximum != null && newValue <= this.maximum) {
                this.setValue((Number)newValue, true);
            }
        }
        this.fireListeners();
    }

    protected void checkSubclass() {
    }

    public void cut() {
        super.cut();
        this.setValue(null);
        this.fireListeners();
    }

    public void paste() {
        super.paste();
        String work = this.getText().trim();
        if (work.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                Number newValue = this.formatter.parse(work);
                this.setValue(newValue, true);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.fireListeners();
    }

    public void setFormat(NumberFormat formatter) {
        Assert.isTrue((formatter != null ? 1 : 0) != 0, (String)"The formatter can't be null");
        this.formatter = formatter;
        String work = this.getText().trim();
        if (work.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                Number newValue = formatter.parse(work);
                this.setValue(newValue);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void setText(String string) {
        this.removeVerifyListener(this.inputVerifier);
        this.removeModifyListener(this.inputNotifier);
        Point location = this.getSelection();
        super.setText(string);
        this.setSelection(location.x);
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
    }

    protected void fireListeners() {
        Event e = new Event();
        e.widget = this;
        e.time = (int)System.currentTimeMillis();
        SelectionEvent selectionEvent = new SelectionEvent(e);
        for (SelectionListener s : this.selectionListeners) {
            s.widgetSelected(selectionEvent);
        }
    }

    public void setDefaultValue(Number value) {
        this.defaultValue = value;
    }

    public void setRemoveTrailZeroes(boolean value) {
        this.removeTrailZeroes = value;
    }

    public void setBackground(Color color) {
        if (this.currentState != VALIDATION_RESULT.OUT_OF_BOUNDS) {
            super.setBackground(color);
        }
        this.defaultBackgroundColor = color;
    }

    protected static enum VALIDATION_RESULT {
        VALID,
        VALID_NOT_FINAL,
        NOT_VALID,
        OUT_OF_BOUNDS;

    }
}

