/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PropertiesComponent {
    private Map<String, String> properties;
    private Control control;
    private TableViewer tviewer;

    public Map<String, String> getProperties() {
        ArrayList list = (ArrayList)this.tviewer.getInput();
        if (list == null) {
            list = new ArrayList();
        }
        this.properties.clear();
        for (Property prop : list) {
            this.properties.put(prop.key, prop.value);
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        this.properties = properties;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            list.add(new Property(entry.getKey(), entry.getValue()));
        }
        this.tviewer.setInput(list);
    }

    public PropertiesComponent(Composite parent) {
        this.createComponent(parent);
    }

    public Control getControl() {
        return this.control;
    }

    public void createComponent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Table wtable = new Table(composite, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 250;
        wtable.setLayoutData((Object)gd);
        wtable.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[2];
        col[0] = new TableColumn(wtable, 0);
        col[0].setText(Messages.PropertiesComponent_0);
        col[0].pack();
        col[1] = new TableColumn(wtable, 0);
        col[1].setText(Messages.PropertiesComponent_1);
        col[1].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, false));
        wtable.setLayout((Layout)tlayout);
        this.tviewer = new TableViewer(wtable);
        this.tviewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tviewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        this.attachCellEditors(this.tviewer, (Composite)wtable);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton(){

            @Override
            protected void afterElementAdded(Object selement) {
                PropertiesComponent.this.handlePropertiesChanged();
            }
        }.createNewButtons(bGroup, this.tviewer, (input, pos) -> new Property("property", "value"));
        new DeleteButton(){

            @Override
            protected void afterElementDeleted(Object element) {
                PropertiesComponent.this.handlePropertiesChanged();
            }
        }.createDeleteButton(bGroup, this.tviewer);
        this.control = composite;
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals("KEY")) {
                    return true;
                }
                return property.equals("VALUE");
            }

            public Object getValue(Object element, String property) {
                Property prop = (Property)element;
                if ("KEY".equals(property)) {
                    return prop.key;
                }
                if ("VALUE".equals(property)) {
                    return prop.value;
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                Property field = (Property)tableItem.getData();
                if ("KEY".equals(property)) {
                    field.key = (String)value;
                } else if ("VALUE".equals(property)) {
                    field.value = (String)value;
                }
                PropertiesComponent.this.tviewer.update(element, new String[]{property});
                PropertiesComponent.this.tviewer.refresh();
                PropertiesComponent.this.handlePropertiesChanged();
            }
        });
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), new TextCellEditor(parent)});
        viewer.setColumnProperties(new String[]{"KEY", "VALUE"});
    }

    protected void handlePropertiesChanged() {
    }

    class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArrayLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Property) {
                if (columnIndex == 0) {
                    return ((Property)element).key;
                }
                return ((Property)element).value;
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class Property {
        public String key;
        public String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

