/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.swt.widgets.WrapTooltip;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TooltipCCombo
extends CCombo {
    private static final String FIELD_LIST = "list";
    private static final String FIELD_POPUP = "popup";
    private final List<String> tooltips = new ArrayList<String>();

    public TooltipCCombo(Composite parent, int style) {
        super(parent, style);
        try {
            Field listField = CCombo.class.getDeclaredField(FIELD_LIST);
            listField.setAccessible(true);
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)listField.get((Object)this);
            Field popupField = CCombo.class.getDeclaredField(FIELD_POPUP);
            popupField.setAccessible(true);
            Shell popup = (Shell)popupField.get((Object)this);
            ActivationListener activationListener = new ActivationListener(list, this.tooltips);
            popup.addListener(9, (Listener)activationListener);
            popup.addListener(21, (Listener)activationListener);
            popup.addListener(27, (Listener)activationListener);
            this.addListener(16, activationListener);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Reflections of this JVM can't be used to access private fields. Thus this class won't work with your JVM.", e);
        }
    }

    public void add(String string) {
        super.add(string);
        this.tooltips.add(null);
    }

    public void add(String string, int index) {
        super.add(string, index);
        this.tooltips.add(index, null);
    }

    public void add(String element, String tooltip) {
        Assert.isNotNull((Object)tooltip, (String)"Tooltip must not be null!");
        super.add(element);
        this.tooltips.add(tooltip);
    }

    public void add(String string, int index, String tooltip) {
        Assert.isNotNull((Object)tooltip, (String)"Tooltip must not be null!");
        super.add(string, index);
        this.tooltips.add(index, tooltip);
    }

    public void setToolTip(int index, String tooltip) {
        Assert.isNotNull((Object)tooltip, (String)"Tooltip must not be null!");
        if (index >= 0 && index < this.getItemCount()) {
            throw new IndexOutOfBoundsException("The index must be  in range 0 <= index && index < getItemCount()");
        }
        this.tooltips.set(index, tooltip);
    }

    public void setToolTip(String element, String tooltip) {
        Assert.isNotNull((Object)element, (String)"Element must not be null!");
        Assert.isNotNull((Object)tooltip, (String)"Tooltip must not be null!");
        int idx = this.indexOf(element);
        if (idx != -1) {
            this.tooltips.set(idx, tooltip);
        }
    }

    public String getToolTip(String element) {
        int idx = this.indexOf(element);
        if (idx != -1) {
            return this.tooltips.get(idx);
        }
        return null;
    }

    public String getToolTip(int index) {
        return this.tooltips.get(index);
    }

    public void remove(int start, int end) {
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            SWT.error((int)6);
        }
        int i = start;
        while (i <= end) {
            this.tooltips.remove(this.getItem(i));
            ++i;
        }
        super.remove(start, end);
    }

    public void remove(String string) {
        this.tooltips.remove(string);
        super.remove(string);
    }

    public void remove(int index) {
        this.tooltips.remove(this.getItem(index));
        super.remove(index);
    }

    public void removeAll() {
        this.tooltips.clear();
        super.removeAll();
    }

    protected void checkSubclass() {
    }

    private class ActivationListener
    implements Listener {
        private org.eclipse.swt.widgets.List list;
        private List<String> textLookup;
        private TooltipHandler handler;

        public ActivationListener(org.eclipse.swt.widgets.List list, List<String> textLookup) {
            this.list = list;
            this.textLookup = textLookup;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    this.handler = new TooltipHandler(this.list, this.textLookup);
                    break;
                }
                case 7: 
                case 16: 
                case 21: 
                case 27: {
                    if (this.handler == null) break;
                    this.handler.dispose();
                    this.handler = null;
                }
            }
        }
    }

    private class TooltipHandler
    implements MouseMoveListener,
    SelectionListener,
    MouseTrackListener {
        private int previousSelectionIdx = -1;
        private WrapTooltip tooltip = null;
        private org.eclipse.swt.widgets.List list;
        private List<String> textLookup;

        public TooltipHandler(org.eclipse.swt.widgets.List list, List<String> textLookup) {
            this.list = list;
            this.list.addMouseMoveListener((MouseMoveListener)this);
            this.list.addSelectionListener((SelectionListener)this);
            this.list.addMouseTrackListener((MouseTrackListener)this);
            this.textLookup = textLookup;
            this.tooltip = new WrapTooltip((Control)this.list);
            if (this.list.getSelectionIndex() != -1) {
                this.updateTooltip(this.list.getSelectionIndex());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateTooltip(this.list.getSelectionIndex());
        }

        public void mouseMove(MouseEvent e) {
            int itemHeight = this.list.getItemHeight();
            int hoverItem = e.y / itemHeight;
            int itemIdx = this.list.getTopIndex() + hoverItem;
            if (this.previousSelectionIdx != itemIdx) {
                this.updateTooltip(itemIdx);
                this.previousSelectionIdx = itemIdx;
            }
        }

        private void updateTooltip(int index) {
            String text = null;
            if (index >= 0 && index < this.list.getItemCount() && (text = this.textLookup.get(index)) != null) {
                this.tooltip.setText(text);
                Point size = this.list.getSize();
                this.tooltip.show(new Point(size.x - 2, 0));
                this.previousSelectionIdx = index;
            } else {
                this.tooltip.hide();
            }
        }

        public void dispose() {
            this.list.removeMouseMoveListener((MouseMoveListener)this);
            this.list.removeSelectionListener((SelectionListener)this);
            this.list.removeMouseTrackListener((MouseTrackListener)this);
            this.tooltip.hide();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            this.tooltip.hide();
            this.previousSelectionIdx = -1;
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }
    }
}

