/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.jface.dialogs.ElementWithValueExpressionDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import net.sf.jasperreports.engine.design.JRDesignHyperlinkParameter;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class WHyperlink
extends Composite
implements IExpressionContextSetter {
    private JRDesignHyperlink hyperlink;
    private ExpressionContext expContext;
    private boolean init = true;
    private WTextExpression referenceExpr;
    private WTextExpression anchorExpr;
    private WTextExpression pageExpr;
    private WTextExpression tooltipExpr;
    private Combo comboHyperlinkTarget;
    private Combo comboHyperlinkType;
    private TableViewer tableViewerHyperlinkParameters;
    private Button btnAddHyperlinkParam;
    private Button btnModifyHyperlinkParam;
    private Button btnRemoveHyperlinkParam;
    private CTabFolder tabFolder;
    private CTabItem tbtmReference;
    private CTabItem tbtmAnchor;
    private CTabItem tbtmPage;
    private CTabItem tbtmHyperlinkParameters;
    private CTabItem tbtmTooltip;
    private Composite tooltipContent;
    private Composite hyperlinkParamsContent;
    private Composite anchorContent;
    private Composite referenceContent;
    private Composite pageContent;
    public static final String[] LINK_TARGET_ITEMS = new String[]{HyperlinkTargetEnum.SELF.getName(), HyperlinkTargetEnum.BLANK.getName(), HyperlinkTargetEnum.TOP.getName(), HyperlinkTargetEnum.PARENT.getName()};
    public static final String[] LINK_TYPE_ITEMS;

    static {
        ArrayList<HyperlinkTypeEnum> filteredTypes = new ArrayList<HyperlinkTypeEnum>(2);
        filteredTypes.add(HyperlinkTypeEnum.CUSTOM);
        filteredTypes.add(HyperlinkTypeEnum.NULL);
        List<String> alltypes = ModelUtils.getHyperlinkTypeNames4Widget(filteredTypes);
        LINK_TYPE_ITEMS = alltypes.toArray(new String[alltypes.size()]);
    }

    public WHyperlink(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setBackground(this.getDisplay().getSystemColor(22));
        CLabel lblHyperlinkTarget = new CLabel((Composite)this, 0);
        lblHyperlinkTarget.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblHyperlinkTarget.setText(Messages.WHyperlink_TargetLbl);
        this.comboHyperlinkTarget = new Combo((Composite)this, 0);
        GridData gd_comboHyperlinkTarget = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_comboHyperlinkTarget.widthHint = 195;
        this.comboHyperlinkTarget.setLayoutData((Object)gd_comboHyperlinkTarget);
        this.comboHyperlinkTarget.setItems(LINK_TARGET_ITEMS);
        this.comboHyperlinkTarget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WHyperlink.this.init) {
                    WHyperlink.this.hyperlink.setLinkTarget(WHyperlink.this.comboHyperlinkTarget.getText());
                }
            }
        });
        CLabel lblHyperlinkType = new CLabel((Composite)this, 0);
        lblHyperlinkType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblHyperlinkType.setText(Messages.WHyperlink_TypeLbl);
        this.comboHyperlinkType = new Combo((Composite)this, 0);
        GridData gd_comboHyperlinkType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_comboHyperlinkType.widthHint = 195;
        this.comboHyperlinkType.setLayoutData((Object)gd_comboHyperlinkType);
        this.comboHyperlinkType.setItems(LINK_TYPE_ITEMS);
        this.comboHyperlinkType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkTypeEnum selectedType = HyperlinkTypeEnum.getByName((String)WHyperlink.this.comboHyperlinkType.getText());
                if (selectedType == null) {
                    selectedType = HyperlinkTypeEnum.CUSTOM;
                }
                WHyperlink.this.refreshSubTabs(selectedType);
                if (!WHyperlink.this.init) {
                    WHyperlink.this.hyperlink.setLinkType(WHyperlink.this.comboHyperlinkType.getText());
                }
            }
        });
        this.tabFolder = new CTabFolder((Composite)this, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tbtmReference = new CTabItem(this.tabFolder, 0);
        this.tbtmReference.setText(Messages.WHyperlink_ReferenceTab);
        this.referenceContent = new Composite((Composite)this.tabFolder, 0);
        this.tbtmReference.setControl((Control)this.referenceContent);
        this.referenceContent.setLayout((Layout)new GridLayout(1, true));
        this.referenceExpr = new WTextExpression(this.referenceContent, 0, Messages.WHyperlink_ReferenceExprLbl, 2){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                if (!WHyperlink.this.init) {
                    WHyperlink.this.hyperlink.setHyperlinkReferenceExpression((JRExpression)exp);
                }
            }
        };
        this.referenceExpr.setLayoutData(new GridData(4, 4, true, true));
        this.tbtmAnchor = new CTabItem(this.tabFolder, 0);
        this.tbtmAnchor.setText(Messages.WHyperlink_AnchorTab);
        this.anchorContent = new Composite((Composite)this.tabFolder, 0);
        this.tbtmAnchor.setControl((Control)this.anchorContent);
        this.anchorContent.setLayout((Layout)new GridLayout(1, true));
        this.anchorExpr = new WTextExpression(this.anchorContent, 0, Messages.WHyperlink_AnchorExprLbl, 2){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                if (!WHyperlink.this.init) {
                    WHyperlink.this.hyperlink.setHyperlinkAnchorExpression((JRExpression)exp);
                }
            }
        };
        this.anchorExpr.setLayoutData(new GridData(4, 4, true, true));
        this.tbtmPage = new CTabItem(this.tabFolder, 0);
        this.tbtmPage.setText(Messages.WHyperlink_PageTab);
        this.pageContent = new Composite((Composite)this.tabFolder, 0);
        this.tbtmPage.setControl((Control)this.pageContent);
        this.pageContent.setLayout((Layout)new GridLayout(1, true));
        this.pageExpr = new WTextExpression(this.pageContent, 0, Messages.WHyperlink_PageExprLbl, 2){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                if (!WHyperlink.this.init) {
                    WHyperlink.this.hyperlink.setHyperlinkPageExpression((JRExpression)exp);
                }
            }
        };
        this.pageExpr.setLayoutData(new GridData(4, 4, true, true));
        this.tbtmHyperlinkParameters = new CTabItem(this.tabFolder, 0);
        this.tbtmHyperlinkParameters.setText(Messages.WHyperlink_ParametersTab);
        this.hyperlinkParamsContent = new Composite((Composite)this.tabFolder, 0);
        this.tbtmHyperlinkParameters.setControl((Control)this.hyperlinkParamsContent);
        this.hyperlinkParamsContent.setLayout((Layout)new GridLayout(3, false));
        Composite cmpHyperlinkParamsTableViewer = new Composite(this.hyperlinkParamsContent, 0);
        cmpHyperlinkParamsTableViewer.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        TableColumnLayout tl_hyperlinkParamsTableViewer = new TableColumnLayout();
        cmpHyperlinkParamsTableViewer.setLayout((Layout)tl_hyperlinkParamsTableViewer);
        this.tableViewerHyperlinkParameters = new TableViewer(cmpHyperlinkParamsTableViewer, 67584);
        Table tableHyperlinkParameters = this.tableViewerHyperlinkParameters.getTable();
        tableHyperlinkParameters.setHeaderVisible(true);
        tableHyperlinkParameters.setLinesVisible(true);
        TableViewerColumn tblclmnHyperlinkParamName = new TableViewerColumn(this.tableViewerHyperlinkParameters, 0);
        tblclmnHyperlinkParamName.getColumn().setText(Messages.WHyperlink_ParameterNameCol);
        tblclmnHyperlinkParamName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null) {
                    return ((JRDesignHyperlinkParameter)element).getName();
                }
                return null;
            }
        });
        tl_hyperlinkParamsTableViewer.setColumnData((Widget)tblclmnHyperlinkParamName.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        TableViewerColumn tblclmnHyperlinkParamExp = new TableViewerColumn(this.tableViewerHyperlinkParameters, 0);
        tblclmnHyperlinkParamExp.getColumn().setText(Messages.WHyperlink_ParameterExprCol);
        tblclmnHyperlinkParamExp.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                JRExpression valueExpression;
                if (element != null && (valueExpression = ((JRDesignHyperlinkParameter)element).getValueExpression()) != null) {
                    return valueExpression.getText();
                }
                return super.getText(element);
            }
        });
        tl_hyperlinkParamsTableViewer.setColumnData((Widget)tblclmnHyperlinkParamExp.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this.tableViewerHyperlinkParameters.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewerHyperlinkParameters.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WHyperlink.this.modifySelectedParameter();
            }
        });
        this.tableViewerHyperlinkParameters.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WHyperlink.this.btnModifyHyperlinkParam.setEnabled(true);
                WHyperlink.this.btnRemoveHyperlinkParam.setEnabled(true);
            }
        });
        this.btnAddHyperlinkParam = new Button(this.hyperlinkParamsContent, 0);
        this.btnAddHyperlinkParam.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnAddHyperlinkParam.setText(Messages.WHyperlink_AddBtn);
        this.btnAddHyperlinkParam.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WHyperlink.this.addNewParameter();
            }
        });
        this.btnModifyHyperlinkParam = new Button(this.hyperlinkParamsContent, 0);
        this.btnModifyHyperlinkParam.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnModifyHyperlinkParam.setText(Messages.WHyperlink_ModifyBtn);
        this.btnModifyHyperlinkParam.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WHyperlink.this.modifySelectedParameter();
            }
        });
        this.btnModifyHyperlinkParam.setEnabled(false);
        this.btnRemoveHyperlinkParam = new Button(this.hyperlinkParamsContent, 0);
        this.btnRemoveHyperlinkParam.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnRemoveHyperlinkParam.setText(Messages.WHyperlink_RemoveBtn);
        this.btnRemoveHyperlinkParam.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WHyperlink.this.removeSelectedParameter();
                WHyperlink.this.btnModifyHyperlinkParam.setEnabled(false);
                WHyperlink.this.btnRemoveHyperlinkParam.setEnabled(false);
            }
        });
        this.btnRemoveHyperlinkParam.setEnabled(false);
        this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
        this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
        this.tooltipContent = new Composite((Composite)this.tabFolder, 0);
        this.tbtmTooltip.setControl((Control)this.tooltipContent);
        this.tooltipContent.setLayout((Layout)new GridLayout(1, true));
        this.tooltipExpr = new WTextExpression(this.tooltipContent, 0, Messages.WHyperlink_TooltipExprLbl, 2){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                if (!WHyperlink.this.init) {
                    WHyperlink.this.hyperlink.setHyperlinkTooltipExpression((JRExpression)exp);
                }
            }
        };
        this.tooltipExpr.setLayoutData(new GridData(4, 4, true, true));
        if (this.hyperlink == null) {
            this.hyperlink = new JRDesignHyperlink();
            this.hyperlink.setHyperlinkType(HyperlinkTypeEnum.NONE);
            this.hyperlink.setLinkType("None");
            this.hyperlink.setHyperlinkTarget(HyperlinkTargetEnum.SELF);
            this.hyperlink.setLinkTarget("Self");
        }
        this.refreshWidgetsContent();
        this.init = false;
    }

    private void refreshWidgetsContent() {
        String linkType;
        Assert.isNotNull((Object)this.hyperlink);
        String linkTarget = this.hyperlink.getLinkTarget();
        if (linkTarget != null && !linkTarget.isEmpty()) {
            this.comboHyperlinkTarget.setText(linkTarget);
        }
        if ((linkType = this.hyperlink.getLinkType()) != null && !linkType.isEmpty()) {
            this.comboHyperlinkType.setText(linkType);
        }
        this.referenceExpr.setExpression((JRDesignExpression)this.hyperlink.getHyperlinkReferenceExpression());
        this.anchorExpr.setExpression((JRDesignExpression)this.hyperlink.getHyperlinkAnchorExpression());
        this.pageExpr.setExpression((JRDesignExpression)this.hyperlink.getHyperlinkPageExpression());
        if (this.hyperlink.getHyperlinkParameters() != null) {
            this.tableViewerHyperlinkParameters.setInput((Object)this.hyperlink.getHyperlinkParameters());
        }
        this.tooltipExpr.setExpression((JRDesignExpression)this.hyperlink.getHyperlinkTooltipExpression());
    }

    private void refreshSubTabs(HyperlinkTypeEnum selectedType) {
        this.tbtmReference.dispose();
        this.tbtmAnchor.dispose();
        this.tbtmPage.dispose();
        this.tbtmHyperlinkParameters.dispose();
        this.tbtmTooltip.dispose();
        switch (selectedType) {
            case CUSTOM: {
                this.createDefaultTabsForContributedTypes();
                break;
            }
            case LOCAL_ANCHOR: {
                this.tbtmAnchor = new CTabItem(this.tabFolder, 0);
                this.tbtmAnchor.setText(Messages.WHyperlink_AnchorTab);
                this.tbtmAnchor.setControl((Control)this.anchorContent);
                this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
                this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
                this.tbtmTooltip.setControl((Control)this.tooltipContent);
                break;
            }
            case LOCAL_PAGE: {
                this.tbtmPage = new CTabItem(this.tabFolder, 0);
                this.tbtmPage.setText(Messages.WHyperlink_PageTab);
                this.tbtmPage.setControl((Control)this.pageContent);
                this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
                this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
                this.tbtmTooltip.setControl((Control)this.tooltipContent);
                break;
            }
            case NONE: {
                this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
                this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
                this.tbtmTooltip.setControl((Control)this.tooltipContent);
                break;
            }
            case REFERENCE: {
                this.tbtmReference = new CTabItem(this.tabFolder, 0);
                this.tbtmReference.setText(Messages.WHyperlink_ReferenceTab);
                this.tbtmReference.setControl((Control)this.referenceContent);
                this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
                this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
                this.tbtmTooltip.setControl((Control)this.tooltipContent);
                break;
            }
            case REMOTE_ANCHOR: {
                this.tbtmReference = new CTabItem(this.tabFolder, 0);
                this.tbtmReference.setText(Messages.WHyperlink_ReferenceTab);
                this.tbtmReference.setControl((Control)this.referenceContent);
                this.tbtmAnchor = new CTabItem(this.tabFolder, 0);
                this.tbtmAnchor.setText(Messages.WHyperlink_AnchorTab);
                this.tbtmAnchor.setControl((Control)this.anchorContent);
                this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
                this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
                this.tbtmTooltip.setControl((Control)this.tooltipContent);
                break;
            }
            case REMOTE_PAGE: {
                this.tbtmReference = new CTabItem(this.tabFolder, 0);
                this.tbtmReference.setText(Messages.WHyperlink_ReferenceTab);
                this.tbtmReference.setControl((Control)this.referenceContent);
                this.tbtmPage = new CTabItem(this.tabFolder, 0);
                this.tbtmPage.setText(Messages.WHyperlink_PageTab);
                this.tbtmPage.setControl((Control)this.pageContent);
                this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
                this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
                this.tbtmTooltip.setControl((Control)this.tooltipContent);
                break;
            }
        }
        this.tabFolder.setSelection(0);
    }

    private void createDefaultTabsForContributedTypes() {
        String typeTxt = this.comboHyperlinkType.getText();
        List<UIElement> uiElements = JaspersoftStudioPlugin.getExtensionManager().getUIElementsForCustomHyperlink(typeTxt);
        if (uiElements.contains((Object)UIElement.ANCHOR)) {
            this.tbtmAnchor = new CTabItem(this.tabFolder, 0);
            this.tbtmAnchor.setText(Messages.WHyperlink_AnchorTab);
            this.tbtmAnchor.setControl((Control)this.anchorContent);
        }
        if (uiElements.contains((Object)UIElement.PAGE)) {
            this.tbtmPage = new CTabItem(this.tabFolder, 0);
            this.tbtmPage.setText(Messages.WHyperlink_PageTab);
            this.tbtmPage.setControl((Control)this.pageContent);
        }
        if (uiElements.contains((Object)UIElement.REFERENCE)) {
            this.tbtmReference = new CTabItem(this.tabFolder, 0);
            this.tbtmReference.setText(Messages.WHyperlink_ReferenceTab);
            this.tbtmReference.setControl((Control)this.referenceContent);
        }
        if (uiElements.contains((Object)UIElement.PARAMETERS)) {
            this.tbtmHyperlinkParameters = new CTabItem(this.tabFolder, 0);
            this.tbtmHyperlinkParameters.setText(Messages.WHyperlink_ParametersTab);
            this.tbtmHyperlinkParameters.setControl((Control)this.hyperlinkParamsContent);
        }
        if (uiElements.contains((Object)UIElement.TOOLTIP)) {
            this.tbtmTooltip = new CTabItem(this.tabFolder, 0);
            this.tbtmTooltip.setText(Messages.WHyperlink_TooltipTab);
            this.tbtmTooltip.setControl((Control)this.tooltipContent);
        }
    }

    public void setHyperlink(JRDesignHyperlink hyperlink) {
        Assert.isNotNull((Object)hyperlink);
        this.hyperlink = hyperlink;
        this.refreshWidgetsContent();
    }

    private void addNewParameter() {
        ElementWithValueExpressionDialog dialog = new ElementWithValueExpressionDialog(Messages.WHyperlink_AddParameterDialogTitle, Messages.WHyperlink_AddParameterDialogLbl1, Messages.WHyperlink_AddParameterDialogLbl2, null, null, this.getShell());
        dialog.setExpressionContext(this.expContext);
        if (dialog.open() == 0) {
            JRDesignHyperlinkParameter linkParam = new JRDesignHyperlinkParameter();
            linkParam.setName(dialog.getElementName());
            linkParam.setValueExpression((JRExpression)dialog.getElementValueExpression());
            this.hyperlink.addHyperlinkParameter((JRHyperlinkParameter)linkParam);
            this.tableViewerHyperlinkParameters.setInput((Object)this.hyperlink.getHyperlinkParametersList());
        }
    }

    private void modifySelectedParameter() {
        Object selObject = ((IStructuredSelection)this.tableViewerHyperlinkParameters.getSelection()).getFirstElement();
        if (selObject != null && selObject instanceof JRDesignHyperlinkParameter) {
            JRDesignHyperlinkParameter selectedParam = (JRDesignHyperlinkParameter)selObject;
            ElementWithValueExpressionDialog dialog = new ElementWithValueExpressionDialog(Messages.WHyperlink_ModifyParameterDialogTitle, Messages.WHyperlink_ModifyParameterDialogLbl1, Messages.WHyperlink_ModifyParameterDialogLbl2, selectedParam.getName(), (JRDesignExpression)selectedParam.getValueExpression(), this.getShell());
            dialog.setExpressionContext(this.expContext);
            if (dialog.open() == 0) {
                selectedParam.setName(dialog.getElementName());
                selectedParam.setValueExpression((JRExpression)dialog.getElementValueExpression());
                this.tableViewerHyperlinkParameters.setInput((Object)this.hyperlink.getHyperlinkParametersList());
            }
        }
    }

    private void removeSelectedParameter() {
        Object selObject = ((IStructuredSelection)this.tableViewerHyperlinkParameters.getSelection()).getFirstElement();
        if (selObject != null && selObject instanceof JRDesignHyperlinkParameter) {
            this.hyperlink.removeHyperlinkParameter((JRHyperlinkParameter)((JRDesignHyperlinkParameter)selObject));
            this.tableViewerHyperlinkParameters.setInput((Object)this.hyperlink.getHyperlinkParametersList());
        }
    }

    public JRDesignHyperlink getHyperlink() {
        if (this.hyperlink.getHyperlinkTypeValue() == null) {
            return null;
        }
        boolean clearParameters = false;
        switch (this.hyperlink.getHyperlinkTypeValue()) {
            case CUSTOM: {
                String typeTxt = this.comboHyperlinkType.getText();
                List<UIElement> uiElements = JaspersoftStudioPlugin.getExtensionManager().getUIElementsForCustomHyperlink(typeTxt);
                if (!uiElements.contains((Object)UIElement.ANCHOR)) {
                    this.hyperlink.setHyperlinkAnchorExpression(null);
                }
                if (!uiElements.contains((Object)UIElement.PAGE)) {
                    this.hyperlink.setHyperlinkPageExpression(null);
                }
                if (!uiElements.contains((Object)UIElement.REFERENCE)) {
                    this.hyperlink.setHyperlinkReferenceExpression(null);
                }
                if (!uiElements.contains((Object)UIElement.PARAMETERS)) {
                    clearParameters = true;
                }
                if (uiElements.contains((Object)UIElement.TOOLTIP)) break;
                this.hyperlink.setHyperlinkTooltipExpression(null);
                break;
            }
            case LOCAL_ANCHOR: {
                this.hyperlink.setHyperlinkPageExpression(null);
                this.hyperlink.setHyperlinkReferenceExpression(null);
                clearParameters = true;
                break;
            }
            case LOCAL_PAGE: {
                this.hyperlink.setHyperlinkAnchorExpression(null);
                this.hyperlink.setHyperlinkReferenceExpression(null);
                clearParameters = true;
                break;
            }
            case REMOTE_ANCHOR: {
                this.hyperlink.setHyperlinkPageExpression(null);
                clearParameters = true;
                break;
            }
            case REMOTE_PAGE: {
                this.hyperlink.setHyperlinkAnchorExpression(null);
                clearParameters = true;
                break;
            }
            case NONE: {
                this.hyperlink.setHyperlinkAnchorExpression(null);
                this.hyperlink.setHyperlinkPageExpression(null);
                this.hyperlink.setHyperlinkReferenceExpression(null);
                clearParameters = true;
                break;
            }
            case REFERENCE: {
                this.hyperlink.setHyperlinkAnchorExpression(null);
                this.hyperlink.setHyperlinkPageExpression(null);
                clearParameters = true;
                break;
            }
            default: {
                return null;
            }
        }
        if (clearParameters) {
            List allParameters = this.hyperlink.getHyperlinkParametersList();
            if (allParameters != null) {
                for (JRHyperlinkParameter p : allParameters) {
                    this.hyperlink.removeHyperlinkParameter(p);
                }
            }
            allParameters.clear();
        }
        return this.hyperlink;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        this.referenceExpr.setExpressionContext(expContext);
        this.anchorExpr.setExpressionContext(expContext);
        this.pageExpr.setExpressionContext(expContext);
        this.tooltipExpr.setExpressionContext(expContext);
    }

    public static enum UIElement {
        PAGE,
        ANCHOR,
        REFERENCE,
        PARAMETERS,
        TOOLTIP;

    }
}

