/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.swt.widgets.WLocale;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class WLocaleList
extends Composite {
    private ListViewer listViewer;
    private List list;

    public WLocaleList(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.listViewer = new ListViewer((Composite)this, 2560);
        this.list = this.listViewer.getList();
        this.initList();
    }

    protected void checkSubclass() {
    }

    private void initList() {
        Object[] strLocales = WLocale.getLocales();
        Arrays.sort(strLocales);
        Object[] objectArray = strLocales;
        int n = strLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Object strLocale = objectArray[n2];
            this.list.add((String)strLocale);
            ++n2;
        }
    }

    private int getIndexFromLocale(Locale locale) {
        int returnedIndex = -1;
        if (locale != null) {
            int i = 0;
            while (i < WLocale.strLocales.length) {
                if (WLocale.strLocales[i].equals(locale.getDisplayName())) {
                    returnedIndex = i;
                }
                ++i;
            }
        }
        return returnedIndex;
    }

    public void setSelection(Locale locale) {
        int index = locale == null ? this.getIndexFromLocale(Locale.getDefault()) : this.getIndexFromLocale(locale);
        this.list.setSelection(index);
    }

    public Locale getSelectedLocale() {
        int selectionIndex = this.list.getSelectionIndex();
        if (selectionIndex < 0) {
            return Locale.getDefault();
        }
        String strLocale = WLocale.strLocales[this.list.getSelectionIndex()];
        int i = 0;
        while (i < WLocale.locales.length) {
            if (WLocale.locales[i].getDisplayName().equals(strLocale)) {
                return WLocale.locales[i];
            }
            ++i;
        }
        return null;
    }

    public boolean contains(Locale locale) {
        String displayName = locale.getDisplayName();
        if (displayName != null && displayName.length() > 0) {
            String[] stringArray = WLocale.strLocales;
            int n = WLocale.strLocales.length;
            int n2 = 0;
            while (n2 < n) {
                String strLocale = stringArray[n2];
                if (strLocale.equals(displayName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasSelectedLocale() {
        return this.list.getSelection().length > 0;
    }

    public void setListSelectionListener(SelectionAdapter selectionAdapter) {
        this.list.addSelectionListener((SelectionListener)selectionAdapter);
    }
}

