/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.parameter.GenericParameterLabelProvider;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.GenericJSSParameter;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.ParameterEditor;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WTParametersText
extends Composite {
    private JRHyperlinkParameter[] parameters;
    private Button btn;
    protected Text ftext;
    private Object propertyId;
    private APropertyNode pNode;
    private SelectionAdapter adapter = null;

    public WTParametersText(Composite parent, Object propertyId, APropertyNode pNode) {
        super(parent, 0);
        this.propertyId = propertyId;
        this.pNode = pNode;
        this.createComponent();
    }

    public void setSelectionAdapter(SelectionAdapter adapter) {
        this.adapter = adapter;
    }

    private ExpressionContext getExpressionContext() {
        JRDesignElement designEl = null;
        if (this.pNode.getValue() instanceof JRDesignElement) {
            designEl = (JRDesignElement)this.pNode.getValue();
        }
        ExpressionContext elementExpressionContext = ModelUtils.getElementExpressionContext(designEl, this.pNode);
        return elementExpressionContext;
    }

    protected void createComponent() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.ftext = new Text((Composite)this, 2048);
        this.ftext.setText("");
        this.setWidth(this, 15);
        this.ftext.setEnabled(false);
        this.ftext.setLayoutData((Object)new GridData(768));
        this.btn = new Button((Composite)this, 0x800008 | Window.getDefaultOrientation());
        this.btn.setText("...");
        this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterEditor wizard = new ParameterEditor();
                wizard.setValue(GenericJSSParameter.convertFrom(WTParametersText.this.parameters));
                wizard.setExpressionContext(WTParametersText.this.getExpressionContext());
                WizardDialog dialog = new WizardDialog(WTParametersText.this.ftext.getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    JRHyperlinkParameter[] value = GenericJSSParameter.convertToHyperlink(wizard.getValue());
                    WTParametersText.this.pNode.setPropertyValue(WTParametersText.this.propertyId, value);
                    if (WTParametersText.this.adapter != null) {
                        WTParametersText.this.adapter.widgetSelected(e);
                    }
                }
            }
        });
    }

    public void updateData() {
        Object b = this.pNode.getPropertyActualValue(this.propertyId);
        this.parameters = (JRHyperlinkParameter[])b;
        this.setTextData(new GenericParameterLabelProvider().getText(b));
    }

    public Control getButton() {
        return this.btn;
    }

    public Control getControl() {
        return this.ftext;
    }

    protected void setWidth(Composite parent, int chars) {
        int w = UIUtil.getCharWidth((Drawable)this.ftext) * chars;
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            rd.width = w;
            this.ftext.setLayoutData((Object)rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData rd = new GridData(768);
            rd.minimumWidth = w;
            rd.widthHint = w;
            this.ftext.setLayoutData((Object)rd);
        }
    }

    public void setTextData(Object b) {
        if (b != null) {
            int oldpos = this.ftext.getLocation().x;
            this.ftext.setText(b.toString());
            if (b.toString().length() >= oldpos) {
                this.ftext.setSelection(oldpos, oldpos);
            }
        } else {
            this.ftext.setText("");
        }
    }
}

