/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import java.util.Arrays;
import java.util.TimeZone;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class WTimeZoneList
extends Composite {
    private String[] timeZonesIDs;
    private ListViewer listViewer;
    private List list;

    public WTimeZoneList(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.listViewer = new ListViewer((Composite)this, 2560);
        this.list = this.listViewer.getList();
        this.timeZonesIDs = TimeZone.getAvailableIDs();
        this.initList();
    }

    protected void checkSubclass() {
    }

    private void initList() {
        Arrays.sort(this.timeZonesIDs);
        String[] stringArray = this.timeZonesIDs;
        int n = this.timeZonesIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String timeZonesID = stringArray[n2];
            this.list.add(String.valueOf(timeZonesID) + " (" + TimeZone.getTimeZone(timeZonesID).getDisplayName() + ")");
            ++n2;
        }
    }

    public void setSelection(TimeZone timeZone) {
        int index = timeZone == null ? this.getIndexFromTimeZone(TimeZone.getDefault()) : this.getIndexFromTimeZone(timeZone);
        this.list.setSelection(index);
    }

    private int getIndexFromTimeZone(TimeZone timeZone) {
        int returnedIndex = -1;
        if (timeZone != null) {
            int i = 0;
            while (i < this.timeZonesIDs.length) {
                if (this.timeZonesIDs[i].equals(timeZone.getID())) {
                    returnedIndex = i;
                }
                ++i;
            }
        }
        return returnedIndex;
    }

    public TimeZone getSelectedTimeZone() {
        int selectionIndex = this.list.getSelectionIndex();
        if (selectionIndex < 0) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(this.timeZonesIDs[selectionIndex]);
    }

    public boolean contains(TimeZone timeZone) {
        String ID = timeZone.getID();
        if (ID != null && ID.length() > 0) {
            String[] stringArray = this.timeZonesIDs;
            int n = this.timeZonesIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String timeZonesID = stringArray[n2];
                if (timeZonesID.equals(ID)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasSelectedValue() {
        return this.list.getSelection().length > 0;
    }

    public void setListSelectionListener(SelectionAdapter selectionAdapter) {
        this.list.addSelectionListener((SelectionListener)selectionAdapter);
    }
}

