/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets.table;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class EditButton<T> {
    private Button editB;
    private EditListener listener;

    public void createEditButtons(Composite composite, TableViewer tableViewer, IEditElement<T> editElement) {
        this.editB = new Button(composite, 8);
        this.editB.setText(Messages.common_edit);
        this.editB.setLayoutData((Object)new GridData(770));
        this.listener = new EditListener(tableViewer, editElement);
        this.editB.addSelectionListener((SelectionListener)this.listener);
        this.editB.setEnabled(!tableViewer.getSelection().isEmpty());
        tableViewer.addSelectionChangedListener(event -> {
            StructuredSelection s = (StructuredSelection)tableViewer.getSelection();
            this.setEnabled(!s.isEmpty() && s.size() == 1);
        });
    }

    public void editOnDoubleClick() {
        this.listener.tableViewer.addDoubleClickListener(event -> this.push());
    }

    public void push() {
        if (this.editB.isEnabled()) {
            this.listener.widgetSelected(null);
        }
    }

    public void setButtonText(String text) {
        this.editB.setText(text);
    }

    public void setEnabled(boolean enable) {
        this.editB.setEnabled(enable);
    }

    protected void afterElementModified(T element, List<T> inlist, int ind) {
    }

    private final class EditListener
    extends SelectionAdapter {
        protected TableViewer tableViewer;
        private IEditElement<T> editElement;

        private EditListener(TableViewer tableViewer, IEditElement<T> newElement) {
            this.tableViewer = tableViewer;
            this.editElement = newElement;
        }

        public void widgetSelected(SelectionEvent e) {
            EditButton.this.editB.setEnabled(false);
            try {
                StructuredSelection s = (StructuredSelection)this.tableViewer.getSelection();
                ArrayList inlist = (ArrayList)this.tableViewer.getInput();
                if (inlist == null) {
                    inlist = new ArrayList();
                    this.tableViewer.setInput(inlist);
                }
                int index = -1;
                if (s.isEmpty()) {
                    return;
                }
                index = inlist.indexOf(s.getFirstElement());
                this.editElement.editElement(inlist, index);
                if (inlist.get(index) == null) {
                    inlist.remove(index);
                    this.tableViewer.refresh();
                    return;
                }
                EditButton.this.afterElementModified(s.getFirstElement(), inlist, index);
                this.tableViewer.refresh();
                this.tableViewer.setSelection((ISelection)new StructuredSelection(inlist.get(index)));
                this.tableViewer.reveal(s.getFirstElement());
            }
            finally {
                EditButton.this.editB.setEnabled(true);
            }
        }
    }
}

