/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.templates;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ReportNewWizard;
import com.jaspersoft.studio.wizards.WizardUtils;
import com.jaspersoft.studio.wizards.datasource.ReportWizardDataSourceDynamicPage;
import com.jaspersoft.studio.wizards.fields.ReportWizardFieldsDynamicPage;
import com.jaspersoft.studio.wizards.fields.StaticWizardFieldsPage;
import com.jaspersoft.studio.wizards.group.ReportWizardFieldsGroupByDynamicPage;
import com.jaspersoft.templates.ReportBundle;
import com.jaspersoft.templates.TemplateEngine;
import com.jaspersoft.templates.WizardTemplateBundle;
import java.io.Closeable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;

public class JrxmlTemplateBundle
extends WizardTemplateBundle {
    private ReportWizardDataSourceDynamicPage step1 = null;
    private ReportWizardFieldsDynamicPage step2 = null;
    private ReportWizardFieldsGroupByDynamicPage step3 = null;

    public JrxmlTemplateBundle(URL url, boolean isExternal, JasperReportsContext jrContext) throws Exception {
        super(url, isExternal, jrContext);
    }

    public JrxmlTemplateBundle(URL url, JasperReportsContext jrContext) throws Exception {
        super(url, jrContext);
    }

    @Override
    public IFile doFinish(ReportNewWizard mainWizard, IProgressMonitor monitor) throws CoreException {
        IFile reportFile = null;
        Map<String, Object> settings = mainWizard.getSettings();
        String containerName = (String)settings.get("containerNameKey");
        String fileName = (String)settings.get("fileNameKey");
        monitor.beginTask(String.valueOf(Messages.ReportNewWizard_3) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.format(Messages.ReportNewWizard_4, containerName));
        }
        JasperReportsConfiguration jConfig = mainWizard.getConfig();
        HashMap<String, Object> templateSettings = new HashMap<String, Object>();
        WizardTemplateBundle templateBundle = mainWizard.getTemplateChooserStep().getTemplateBundle();
        JRDesignDataset dataset = WizardUtils.createDataset((JasperReportsContext)jConfig, true, settings);
        templateSettings.put("main_dataset", dataset);
        if (settings.containsKey("dataset_fields")) {
            templateSettings.put("main_fields", settings.get("dataset_fields"));
        }
        if (settings.containsKey("group_fields")) {
            templateSettings.put("main_group_fields", settings.get("group_fields"));
        }
        if (settings.containsKey("create_sort_fields")) {
            templateSettings.put("create_sort_fields", settings.get("create_sort_fields"));
        }
        if (settings.containsKey("extra_parameters")) {
            templateSettings.put("parameters", settings.get("extra_parameters"));
        }
        TemplateEngine templateEngine = templateBundle.getTemplateEngine();
        Closeable stream = null;
        try {
            this.saveReportBundleResources(monitor, templateBundle, this.getReportContainer(mainWizard));
            ReportBundle reportBundle = templateEngine.generateReportBundle(templateBundle, templateSettings, (JasperReportsContext)jConfig);
            if (this.step1 != null && this.step1.getDataAdapter() != null) {
                Object props = settings.get("dataset_properties");
                JRPropertiesMap pmap = new JRPropertiesMap();
                if (props != null && props instanceof JRPropertiesMap) {
                    pmap = (JRPropertiesMap)props;
                }
                templateEngine.setReportDataAdapter(reportBundle, this.step1.getDataAdapter(), pmap, jConfig);
            }
            reportFile = this.saveBundleIntoFile(reportBundle, mainWizard, jConfig, monitor);
            this.getReportContainer(mainWizard).refreshLocal(1, monitor);
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        FileUtils.closeStream(stream);
        return reportFile;
    }

    @Override
    public void wizardClosed() {
        this.step1 = null;
        this.step2 = null;
        this.step3 = null;
    }

    @Override
    public WizardPage[] getCustomWizardPages() {
        if (this.step1 == null || this.step2 == null || this.step3 == null) {
            this.step1 = new ReportWizardDataSourceDynamicPage(this);
            this.step2 = new ReportWizardFieldsDynamicPage(this);
            this.step3 = new ReportWizardFieldsGroupByDynamicPage(this);
        }
        WizardPage[] result = new WizardPage[]{this.step1, this.step2, this.step3};
        return result;
    }

    public ReportWizardDataSourceDynamicPage getStep1() {
        return this.step1;
    }

    public StaticWizardFieldsPage getStep2() {
        return this.step2;
    }

    public ReportWizardFieldsGroupByDynamicPage getStep3() {
        return this.step3;
    }

    @Override
    public boolean hasSupportForSubreport() {
        return true;
    }
}

