/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.ResetValueCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboItemSeparator;
import com.jaspersoft.studio.property.combomenu.WritableComboTableViewer;
import com.jaspersoft.studio.property.section.widgets.SPFontNamePopUp;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wb.swt.ResourceManager;

public class TextualFontNameContributionItem
extends CommonToolbarHandler {
    protected static MouseAdapter macComboMenuOpener = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            Menu menu;
            if (e.button == 3 && ((Control)e.widget).getMenu() != null && !(menu = ((Control)e.widget).getMenu()).isDisposed() && !menu.isVisible()) {
                Point location = e.widget.getDisplay().getCursorLocation();
                menu.setLocation(location.x, location.y);
                menu.setVisible(true);
            }
        }
    };
    private APropertyNode showedNode = null;
    private Composite controlsArea;
    private WritableComboTableViewer fontName;
    private boolean refreshing = false;
    private String[] fontList = null;
    PreferenceListener preferenceListener = new PreferenceListener();
    private PropertyChangeListener nodeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if (TextualFontNameContributionItem.this.fontName.isDisposed()) {
                return;
            }
            TextualFontNameContributionItem.this.refreshing = true;
            List selection = TextualFontNameContributionItem.this.getSelectionForType(MTextElement.class);
            if (selection.size() == 1) {
                APropertyNode node = (APropertyNode)selection.get(0);
                Object actaulNameValue = node.getPropertyActualValue("fontName");
                Object ownNameValue = node.getPropertyValue("fontName");
                TextualFontNameContributionItem.this.setFontNameText(actaulNameValue, ownNameValue);
            } else {
                TextualFontNameContributionItem.this.setFontNameText(null, null);
                if (TextualFontNameContributionItem.this.showedNode != null) {
                    TextualFontNameContributionItem.this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(TextualFontNameContributionItem.this.nodeChangeListener);
                    TextualFontNameContributionItem.this.showedNode = null;
                }
            }
            TextualFontNameContributionItem.this.refreshing = false;
        }
    };
    private ComboItemAction fontNameComboModify = new ComboItemAction(){

        @Override
        public void exec() {
            if (!TextualFontNameContributionItem.this.refreshing) {
                List selection = TextualFontNameContributionItem.this.getSelectionForType(MTextElement.class);
                if (selection.isEmpty()) {
                    return;
                }
                String value = TextualFontNameContributionItem.this.fontName.getText();
                JSSCompoundCommand cc = new JSSCompoundCommand(null);
                for (Object textElement : selection) {
                    Command changeValueCmd = TextualFontNameContributionItem.this.createCommand(textElement, value, "fontName");
                    if (changeValueCmd == null) continue;
                    cc.add(changeValueCmd);
                    cc.setReferenceNodeIfNull(textElement);
                }
                TextualFontNameContributionItem.this.getCommandStack().execute((Command)cc);
            }
        }
    };

    @Override
    protected Control createControl(Composite parent) {
        this.controlsArea = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.controlsArea.setLayout((Layout)layout);
        this.fontList = null;
        this.fontName = new WritableComboTableViewer(this.controlsArea, 4);
        this.fontName.setData(WIDGET_DATA_KEY, "fontName");
        this.fontName.addSelectionListener(this.fontNameComboModify);
        this.setAvailableFonts();
        this.setAllControlsData();
        return this.controlsArea;
    }

    @Override
    protected boolean fillWithToolItems(ToolBar parent) {
        this.fontList = null;
        ToolItem tiFontName = new ToolItem(parent, 2);
        this.fontName = new WritableComboTableViewer((Composite)parent, 4);
        this.fontName.setData(WIDGET_DATA_KEY, "fontName");
        this.fontName.addSelectionListener(this.fontNameComboModify);
        this.setAvailableFonts();
        this.fontName.getControl().pack();
        tiFontName.setWidth(200);
        tiFontName.setControl((Control)this.fontName.getControl());
        this.getToolItems().add(tiFontName);
        this.setAllControlsData();
        return true;
    }

    protected Command createCommand(Object model, Object value, Object property) {
        if (!(model instanceof IPropertySource)) {
            return null;
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget((IPropertySource)model);
        cmd.setPropertyId(property);
        cmd.setPropertyValue(value);
        return cmd;
    }

    private boolean needFontsUpdate(String[] newFont) {
        return this.fontList == null || !this.fontList.equals(newFont);
    }

    private void setAvailableFonts() {
        APropertyNode node;
        JasperReportsConfiguration jConfig;
        String[] fonts;
        this.refreshing = true;
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        if (selection.size() > 0 && this.needFontsUpdate(fonts = (jConfig = (node = (APropertyNode)selection.get(0)).getJasperConfiguration()).getFontList()) && this.fontName != null && !this.fontName.isDisposed()) {
            this.fontName.setItems(this.stringToItems(ModelUtils.getFontNames(jConfig), jConfig));
            this.fontList = fonts;
        }
        this.refreshing = false;
    }

    private List<ComboItem> stringToItems(List<String[]> fontsList, JasperReportsConfiguration jConfig) {
        int i = 0;
        ArrayList<ComboItem> itemsList = new ArrayList<ComboItem>();
        FontUtil util = FontUtil.getInstance((JasperReportsContext)jConfig);
        int index = 0;
        while (index < fontsList.size()) {
            String[] fonts;
            String[] stringArray = fonts = fontsList.get(index);
            int n = fonts.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Image resolvedImage = ResourceManager.getImage((String)element);
                if (resolvedImage == null) {
                    resolvedImage = new Image(null, ImageUtils.convertToSWT(SPFontNamePopUp.createFontImage(element, util)));
                    ResourceManager.addImage((String)element, (Image)resolvedImage);
                }
                itemsList.add(new ComboItem(element, true, resolvedImage, i, element, element));
                ++i;
                ++n2;
            }
            if (index + 1 != fontsList.size() && fonts.length > 0) {
                itemsList.add(new ComboItemSeparator(i));
                ++i;
            }
            ++index;
        }
        return itemsList;
    }

    @Override
    public boolean isVisible() {
        boolean selectionValid;
        JaspersoftStudioPlugin.getInstance().removePreferenceListener(this.preferenceListener);
        if (!super.isVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        boolean bl = selectionValid = selection.size() > 0;
        if (selectionValid) {
            this.setAvailableFonts();
            this.setAllControlsData();
        } else if (this.showedNode != null) {
            this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            this.showedNode = null;
        }
        if (selectionValid) {
            ANode n = (ANode)selection.get(0);
            IResource r = (IResource)n.getJasperConfiguration().get("ifile");
            JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, r);
        }
        return selectionValid;
    }

    protected void setFontNameText(Object resolvedValue, Object elementValue) {
        this.fontName.setText(Misc.nvl((Object)resolvedValue, (String)"").toString());
        if (elementValue == null) {
            this.fontName.setInherithed(true);
        } else {
            this.fontName.setInherithed(false);
        }
    }

    protected void setAllControlsData() {
        if (this.fontName == null || this.fontName.isDisposed()) {
            return;
        }
        this.refreshing = true;
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        if (selection.size() == 1) {
            APropertyNode node = (APropertyNode)selection.get(0);
            Object actaulNameValue = node.getPropertyActualValue("fontName");
            Object ownNameValue = node.getPropertyValue("fontName");
            this.setFontNameText(actaulNameValue, ownNameValue);
            this.createContextualMenu(node, (Control)this.fontName.getControl(), "fontName");
            if (this.showedNode != null) {
                this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            }
            this.showedNode = node;
            this.showedNode.getPropertyChangeSupport().addPropertyChangeListener(this.nodeChangeListener);
        } else {
            this.setFontNameText(null, null);
            if (this.showedNode != null) {
                this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
                this.showedNode = null;
            }
        }
        this.refreshing = false;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.showedNode != null) {
            this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            this.showedNode = null;
        }
        if (this.controlsArea != null) {
            this.controlsArea.dispose();
            this.controlsArea = null;
        }
        this.refreshing = false;
    }

    protected void createContextualMenu(final APropertyNode node, final Control control, final String propertyID) {
        if (node != null && control != null && !control.isDisposed()) {
            DefaultValue defaultEntry;
            boolean handleComboListener;
            boolean bl = handleComboListener = Util.isMac() && control.getClass() == Combo.class;
            if (handleComboListener) {
                control.removeMouseListener((MouseListener)macComboMenuOpener);
            }
            boolean entryCreated = false;
            Map<String, DefaultValue> defaultMap = node.getDefaultsPropertiesMap();
            if (defaultMap != null && (defaultEntry = defaultMap.get(propertyID)) != null && (defaultEntry.isNullable() || defaultEntry.hasDefault())) {
                Menu controlMenu = new Menu(control);
                if (defaultEntry.hasDefault()) {
                    MenuItem resetItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    resetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResetValueCommand cmd = new ResetValueCommand();
                            cmd.setPropertyId(propertyID);
                            cmd.setTarget(node);
                            CommandStack cs = TextualFontNameContributionItem.this.getCommandStack();
                            cs.execute((Command)cmd);
                            control.setFocus();
                        }
                    });
                    resetItem.setText(Messages.ASPropertyWidget_0);
                }
                if (defaultEntry.isNullable()) {
                    MenuItem nullItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    nullItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SetValueCommand cmd = new SetValueCommand();
                            cmd.setPropertyId(propertyID);
                            cmd.setTarget(node);
                            cmd.setPropertyValue(null);
                            CommandStack cs = TextualFontNameContributionItem.this.getCommandStack();
                            cs.execute((Command)cmd);
                            control.setFocus();
                        }
                    });
                    nullItem.setText(Messages.ASPropertyWidget_1);
                }
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(controlMenu);
                if (handleComboListener) {
                    control.addMouseListener((MouseListener)macComboMenuOpener);
                }
            }
            if (!entryCreated) {
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(null);
            }
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("FONT_LIST")) {
                TextualFontNameContributionItem.this.setAvailableFonts();
                TextualFontNameContributionItem.this.setAllControlsData();
            }
        }
    }
}

