/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.translation.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.translation.ExtendedTranslationInformation;
import com.jaspersoft.studio.translation.wizard.LocalesTranslationWizardPage;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExportedResourcesWizardPage
extends JSSHelpWizardPage {
    private Table pluginTable;
    private Text pluginName;
    private Text pluginVersion;
    private Text hostPluginName;
    private Text hostPluginVersion;
    private Text pluginProducer;
    private List<ExtendedTranslationInformation> resources;
    private List<ExtendedTranslationInformation> selectedResources = new ArrayList<ExtendedTranslationInformation>();
    private ExtendedTranslationInformation selectedItem = null;
    private Boolean updating = false;
    private ModifyListener modListener = new ModifyListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifyText(ModifyEvent e) {
            Boolean bl = ExportedResourcesWizardPage.this.updating;
            synchronized (bl) {
                if (!ExportedResourcesWizardPage.this.updating.booleanValue() && ExportedResourcesWizardPage.this.selectedItem != null) {
                    ExportedResourcesWizardPage.this.updating = true;
                    ExportedResourcesWizardPage.this.selectedItem.setBundleName(ExportedResourcesWizardPage.this.pluginName.getText());
                    ExportedResourcesWizardPage.this.selectedItem.setBundleVersion(ExportedResourcesWizardPage.this.pluginVersion.getText());
                    ExportedResourcesWizardPage.this.selectedItem.setHostPluginName(ExportedResourcesWizardPage.this.hostPluginName.getText());
                    ExportedResourcesWizardPage.this.selectedItem.setHostPluginVersion(ExportedResourcesWizardPage.this.hostPluginVersion.getText());
                    ExportedResourcesWizardPage.this.selectedItem.setBundleProducer(ExportedResourcesWizardPage.this.pluginProducer.getText());
                    Text usedWidget = (Text)e.widget;
                    int caretPosition = usedWidget.getCaretPosition();
                    ExportedResourcesWizardPage.this.updateSelection();
                    usedWidget.setSelection(caretPosition);
                    ExportedResourcesWizardPage.this.updating = false;
                }
            }
        }
    };

    public ExportedResourcesWizardPage(List<ExtendedTranslationInformation> resources) {
        super(Messages.ExportedResourcesWizardPage_dialogName);
        this.setTitle(Messages.ExportedResourcesWizardPage_pageTitle);
        this.setMessage(Messages.ExportedResourcesWizardPage_pageMessage);
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.pluginTable = new Table(container, 2848);
        GridData tableData = new GridData(1808);
        tableData.heightHint = 500;
        this.pluginTable.setLayoutData((Object)tableData);
        for (ExtendedTranslationInformation resource : this.resources) {
            TableItem item = new TableItem(this.pluginTable, 0);
            item.setText(resource.getPluginName());
            item.setChecked(true);
            item.setData((Object)resource);
        }
        Group infoGroup = new Group(container, 0);
        infoGroup.setText(Messages.ExportedResourcesWizardPage_selectedGroupTitle);
        GridData infoData = new GridData(1808);
        infoData.heightHint = 120;
        infoData.minimumHeight = 120;
        infoGroup.setLayoutData((Object)infoData);
        infoGroup.setLayout((Layout)new GridLayout(4, false));
        Label pluginNameLabel = new Label((Composite)infoGroup, 0);
        pluginNameLabel.setText(Messages.ExportedResourcesWizardPage_pluginNameLabel);
        this.pluginName = new Text((Composite)infoGroup, 2048);
        this.pluginName.setLayoutData((Object)new GridData(768));
        this.pluginName.addModifyListener(this.modListener);
        Label pluginVersionLabel = new Label((Composite)infoGroup, 0);
        pluginVersionLabel.setText(Messages.ExportedResourcesWizardPage_pluginVersion);
        this.pluginVersion = new Text((Composite)infoGroup, 2048);
        this.pluginVersion.setLayoutData((Object)new GridData(768));
        this.pluginVersion.addModifyListener(this.modListener);
        Label hostPluginNameLabel = new Label((Composite)infoGroup, 0);
        hostPluginNameLabel.setText(Messages.ExportedResourcesWizardPage_hostPlaginNameLabel);
        this.hostPluginName = new Text((Composite)infoGroup, 2048);
        this.hostPluginName.setLayoutData((Object)new GridData(768));
        this.hostPluginName.addModifyListener(this.modListener);
        Label hostPluginVersionLabel = new Label((Composite)infoGroup, 0);
        hostPluginVersionLabel.setText(Messages.ExportedResourcesWizardPage_hostPluginVersion);
        this.hostPluginVersion = new Text((Composite)infoGroup, 2048);
        this.hostPluginVersion.setLayoutData((Object)new GridData(768));
        this.hostPluginVersion.addModifyListener(this.modListener);
        Label pluginProducerLabel = new Label((Composite)infoGroup, 0);
        pluginProducerLabel.setText(Messages.ExportedResourcesWizardPage_pluginProducer);
        this.pluginProducer = new Text((Composite)infoGroup, 2048);
        this.pluginProducer.setLayoutData((Object)new GridData(768));
        this.pluginProducer.addModifyListener(this.modListener);
        this.pluginTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                boolean atLeastOneSelected = false;
                TableItem[] tableItemArray = ExportedResourcesWizardPage.this.pluginTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        atLeastOneSelected = true;
                        break;
                    }
                    ++n2;
                }
                ExportedResourcesWizardPage.this.setPageComplete(atLeastOneSelected);
                if (atLeastOneSelected && ExportedResourcesWizardPage.this.pluginTable.getSelection().length > 0) {
                    TableItem selectedEntry = ExportedResourcesWizardPage.this.pluginTable.getSelection()[0];
                    ExportedResourcesWizardPage.this.selectedItem = (ExtendedTranslationInformation)((Object)selectedEntry.getData());
                    Boolean bl = ExportedResourcesWizardPage.this.updating;
                    synchronized (bl) {
                        ExportedResourcesWizardPage.this.updating = true;
                        ExportedResourcesWizardPage.this.updateSelection();
                        ExportedResourcesWizardPage.this.updating = false;
                    }
                }
            }
        });
        if (this.resources.size() == 0) {
            this.pluginName.setEnabled(false);
            this.pluginVersion.setEnabled(false);
            this.hostPluginName.setEnabled(false);
            this.hostPluginVersion.setEnabled(false);
            this.pluginProducer.setEnabled(false);
            this.setPageComplete(false);
        } else {
            this.pluginTable.setSelection(0);
            TableItem selectedEntry = this.pluginTable.getSelection()[0];
            this.selectedItem = (ExtendedTranslationInformation)((Object)selectedEntry.getData());
            Boolean bl = this.updating;
            synchronized (bl) {
                this.updating = true;
                this.updateSelection();
                this.updating = false;
            }
        }
        this.setControl((Control)container);
    }

    public IWizardPage getNextPage() {
        this.selectedResources.clear();
        TableItem[] tableItemArray = this.pluginTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.selectedResources.add((ExtendedTranslationInformation)((Object)item.getData()));
            }
            ++n2;
        }
        IWizardPage page = super.getNextPage();
        if (page instanceof LocalesTranslationWizardPage) {
            ((LocalesTranslationWizardPage)page).initializeSelectedLocales();
        }
        return page;
    }

    public List<ExtendedTranslationInformation> getSelectedResources() {
        return this.selectedResources;
    }

    private void updateSelection() {
        if (this.selectedItem != null) {
            this.pluginName.setText(this.selectedItem.getBundleName());
            this.pluginVersion.setText(this.selectedItem.getBundleVersion());
            this.hostPluginName.setText(this.selectedItem.getHostPluginName());
            this.hostPluginVersion.setText(this.selectedItem.getHostPluginVersion());
            this.pluginProducer.setText(this.selectedItem.getBundleProducer());
        }
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_INSTALL_TRANSLATION_STEP1;
    }
}

