/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.translation.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.translation.ExtendedTranslationInformation;
import com.jaspersoft.studio.translation.FragmentCreationUtil;
import com.jaspersoft.studio.translation.ImageLocale;
import com.jaspersoft.studio.translation.wizard.ExportedResourcesWizardPage;
import com.jaspersoft.studio.translation.wizard.LocalesTranslationWizardPage;
import com.jaspersoft.studio.wizards.CongratulationsWizardPage;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.io.File;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class GenerateFragmentWizard
extends JSSWizard {
    private ExportedResourcesWizardPage step1;
    private LocalesTranslationWizardPage step2;
    private CongratulationsWizardPage step3;
    private List<ExtendedTranslationInformation> sourceList;

    public GenerateFragmentWizard(List<ExtendedTranslationInformation> sourceList) {
        this.sourceList = sourceList;
    }

    @Override
    public boolean canFinish() {
        List<ExtendedTranslationInformation> selectedResources = this.step1.getSelectedResources();
        if (selectedResources.isEmpty()) {
            return false;
        }
        String destinationPath = this.step2.getDestinationPath();
        if (destinationPath.isEmpty() || !new File(destinationPath).exists()) {
            return false;
        }
        List<ImageLocale> localesList = this.step2.getSelectedLanguages();
        return !localesList.isEmpty();
    }

    @Override
    public void addPages() {
        this.step1 = new ExportedResourcesWizardPage(this.sourceList);
        this.addPage((IWizardPage)this.step1);
        this.step2 = new LocalesTranslationWizardPage();
        this.addPage((IWizardPage)this.step2);
        this.step3 = new CongratulationsWizardPage(Messages.GenerateFragmentWizard_congratsText1, Messages.GenerateFragmentWizard_congratsText2, Messages.GenerateFragmentWizard_congratsText3, Messages.GenerateFragmentWizard_congratsText4, Messages.GenerateFragmentWizard_congratsText5);
        this.addPage((IWizardPage)this.step3);
    }

    public List<ExtendedTranslationInformation> getSelectedResources() {
        return this.step1.getSelectedResources();
    }

    @Override
    public boolean performFinish() {
        List<ExtendedTranslationInformation> selectedResources = this.step1.getSelectedResources();
        String destinationPath = this.step2.getDestinationPath();
        List<ImageLocale> localesList = this.step2.getSelectedLanguages();
        FragmentCreationUtil.createFragment(destinationPath, selectedResources, localesList);
        return super.performFinish();
    }
}

