/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.translation.wizard;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.translation.ExtendedTranslationInformation;
import com.jaspersoft.studio.translation.FlagLocaleSelector;
import com.jaspersoft.studio.translation.ImageLocale;
import com.jaspersoft.studio.translation.wizard.GenerateFragmentWizard;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import com.jaspersoft.translation.resources.ITranslationResource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceCache;

public class LocalesTranslationWizardPage
extends JSSHelpWizardPage {
    public static final String DEFAULT_LOCALE = "[Default]";
    private Text filePath;
    private Button addButton;
    private Button removeButton;
    private Table bundleLocalesList;
    private FlagLocaleSelector localeSelector;
    private String destinationPath = "";
    private List<ImageLocale> selectedLanguages = new ArrayList<ImageLocale>();
    private ResourceCache imagesCache = new ResourceCache();

    public LocalesTranslationWizardPage() {
        super(Messages.LocalesTranslationWizardPage_dialogTitle);
        this.setTitle(Messages.LocalesTranslationWizardPage_pageTitle);
        this.setMessage(Messages.LocalesTranslationWizardPage_pageMessage);
    }

    private String getPluginsFolder() {
        String separator = System.getProperty("file.separator");
        try {
            String path = new URL(ConfigurationManager.getApplicationConfigurationPath()).getFile();
            File destination = new File(path).getParentFile();
            destination = new File(String.valueOf(destination.toString()) + separator + "dropins" + separator + "eclipse" + separator + "plugins");
            if (destination.exists()) {
                return destination.getAbsolutePath();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return "";
    }

    private Locale getLocaleFromFilename(String fileName) {
        if (fileName.endsWith(".properties")) {
            int propertiesIndex = fileName.toLowerCase().lastIndexOf(".properties");
            fileName = fileName.substring(0, propertiesIndex);
        }
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale loc = localeArray[n2];
            if (fileName.endsWith("_" + loc.toString())) {
                return loc;
            }
            ++n2;
        }
        return Locale.getDefault();
    }

    private ImageData getImageForLocale(Locale loc) {
        String newLocaleLang = loc.getLanguage();
        String newLocaleCountry = loc.getCountry();
        String key = "icons/flags/" + newLocaleLang + ".png";
        ImageDescriptor descriptor = JaspersoftStudioPlugin.getInstance().getImageDescriptor(key);
        if (descriptor == null) {
            key = "icons/flags/" + newLocaleCountry + ".png";
            descriptor = JaspersoftStudioPlugin.getInstance().getImageDescriptor(key);
        }
        if (descriptor == null) {
            return null;
        }
        return descriptor.getImageData();
    }

    private void recursiveResourceExplorer(HashSet<String> analyzedFiles, HashSet<Locale> foundedLocales, ITranslationResource actualResource) {
        if (actualResource.isFile() && !analyzedFiles.contains(actualResource.getResourceName())) {
            Locale fileLocale = this.getLocaleFromFilename(actualResource.getResourceName());
            analyzedFiles.add(actualResource.getResourceName());
            if (!foundedLocales.contains(fileLocale)) {
                foundedLocales.add(fileLocale);
            }
        } else {
            for (ITranslationResource child : actualResource.getChildren()) {
                this.recursiveResourceExplorer(analyzedFiles, foundedLocales, child);
            }
        }
    }

    private List<ImageLocale> getSelectedLocales() {
        HashSet<String> analyzedFiles = new HashSet<String>();
        HashSet<Locale> foundedLocales = new HashSet<Locale>();
        List<ExtendedTranslationInformation> selectedInfos = ((GenerateFragmentWizard)this.getWizard()).getSelectedResources();
        for (ExtendedTranslationInformation info : selectedInfos) {
            for (ITranslationResource resource : info.getResources()) {
                this.recursiveResourceExplorer(analyzedFiles, foundedLocales, resource);
            }
        }
        ArrayList<ImageLocale> result = new ArrayList<ImageLocale>();
        for (Locale locale : foundedLocales) {
            result.add(new ImageLocale(locale, this.getImageForLocale(locale)));
        }
        return result;
    }

    public void initializeSelectedLocales() {
        this.bundleLocalesList.removeAll();
        List<ImageLocale> alreadySelectedLocales = this.getSelectedLocales();
        for (ImageLocale loc : alreadySelectedLocales) {
            TableItem item = new TableItem(this.bundleLocalesList, 0);
            item.setText(loc.getLocale().toString());
            item.setData((Object)loc.getLocale());
            item.setImage(this.imagesCache.getImage(loc.getImage()));
        }
        this.setAddButtonState();
    }

    public IWizardPage getNextPage() {
        this.destinationPath = this.filePath.getText();
        this.selectedLanguages = new ArrayList<ImageLocale>();
        TableItem[] tableItemArray = this.bundleLocalesList.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ImageData itemImageData = null;
            if (item.getImage() != null) {
                itemImageData = item.getImage().getImageData();
            }
            ImageLocale exportedLocale = new ImageLocale((Locale)item.getData(), itemImageData);
            this.selectedLanguages.add(exportedLocale);
            ++n2;
        }
        return super.getNextPage();
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public List<ImageLocale> getSelectedLanguages() {
        return this.selectedLanguages;
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_INSTALL_TRANSLATION_STEP1;
    }

    protected void dialogChanged() {
        String fileName = this.filePath.getText();
        if (fileName.length() == 0 || !new File(fileName).exists()) {
            this.updateStatus(Messages.LocalesTranslationWizardPage_errorFolder, 3);
            return;
        }
        if (this.bundleLocalesList.getItems().length == 0) {
            this.updateStatus(Messages.LocalesTranslationWizardPage_errorLocales, 3);
            return;
        }
        this.updateStatus(Messages.LocalesTranslationWizardPage_pageMessage, 0);
    }

    protected void updateStatus(String message, int messageType) {
        this.setMessage(message, messageType);
        this.setPageComplete(messageType != 3);
    }

    protected void setAddButtonState() {
        int index = -1;
        int i = 0;
        while (i < this.bundleLocalesList.getItemCount() && index == -1) {
            if (this.bundleLocalesList.getItem(i).getText().equals(this.getSelectedLocaleAsString())) {
                index = i;
            }
            ++i;
        }
        this.addButton.setEnabled(index == -1);
    }

    public String getSelectedLocaleAsString() {
        Locale selectedLocale = this.localeSelector.getSelectedLocale();
        if (selectedLocale != null) {
            return selectedLocale.toString();
        }
        return DEFAULT_LOCALE;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createLocalesSection(container);
        this.createPathSection(container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.dialogChanged();
        }
    }

    private void createPathSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(Messages.LocalesTranslationWizardPage_destinationLabel);
        this.filePath = new Text(container, 2048);
        this.filePath.setText(this.getPluginsFolder());
        this.filePath.setLayoutData((Object)new GridData(768));
        this.filePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalesTranslationWizardPage.this.dialogChanged();
            }
        });
        Button browseButton = new Button(container, 0);
        browseButton.setText(Messages.LocalesTranslationWizardPage_browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(UIUtils.getShell());
                dlg.setFilterPath(LocalesTranslationWizardPage.this.filePath.getText());
                dlg.setText(Messages.LocalesTranslationWizardPage_browseDialogTitle);
                dlg.setMessage(Messages.LocalesTranslationWizardPage_browseDialogMessage);
                String dir = dlg.open();
                if (dir != null) {
                    LocalesTranslationWizardPage.this.filePath.setText(dir);
                }
            }
        });
    }

    private void createLocalesSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createBottomAvailableLocalesComposite(container);
        this.createBottomButtonsComposite(container);
        this.createBottomSelectedLocalesComposite(container);
    }

    private void createBottomSelectedLocalesComposite(Composite parent) {
        Group selectedGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout = new GridLayout();
        layout.numColumns = 1;
        selectedGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        selectedGroup.setLayoutData((Object)gd);
        selectedGroup.setText("Selected locales");
        this.bundleLocalesList = new Table((Composite)selectedGroup, 2058);
        gd = new GridData(1808);
        this.bundleLocalesList.setLayoutData((Object)gd);
        this.bundleLocalesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocalesTranslationWizardPage.this.removeButton.setEnabled(LocalesTranslationWizardPage.this.bundleLocalesList.getSelectionIndices().length != 0);
                LocalesTranslationWizardPage.this.setAddButtonState();
            }
        });
    }

    private void createBottomButtonsComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.addButton = new Button(container, 0);
        this.addButton.setText("Add   -->");
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem item = new TableItem(LocalesTranslationWizardPage.this.bundleLocalesList, 0);
                item.setText(LocalesTranslationWizardPage.this.getSelectedLocaleAsString());
                item.setData((Object)LocalesTranslationWizardPage.this.localeSelector.getSelectedLocale());
                item.setImage(LocalesTranslationWizardPage.this.imagesCache.getImage(LocalesTranslationWizardPage.this.localeSelector.getActualImage()));
                LocalesTranslationWizardPage.this.setAddButtonState();
                LocalesTranslationWizardPage.this.dialogChanged();
            }
        });
        this.removeButton = new Button(container, 0);
        this.removeButton.setText("<-- Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocalesTranslationWizardPage.this.bundleLocalesList.remove(LocalesTranslationWizardPage.this.bundleLocalesList.getSelectionIndices());
                LocalesTranslationWizardPage.this.removeButton.setEnabled(false);
                LocalesTranslationWizardPage.this.setAddButtonState();
                LocalesTranslationWizardPage.this.dialogChanged();
            }
        });
    }

    private void createBottomAvailableLocalesComposite(Composite parent) {
        this.localeSelector = new FlagLocaleSelector(parent);
        this.localeSelector.setLayoutData(new GridData(1040));
        this.localeSelector.addModifyListener(new ModifyListener(){
            private String actualLocale;

            private ImageData getImage(String newLocaleLang, String newLocaleCountry) {
                this.actualLocale = newLocaleLang;
                String key = "icons/flags/" + newLocaleLang + ".png";
                ImageDescriptor descriptor = JaspersoftStudioPlugin.getInstance().getImageDescriptor(key);
                if (descriptor == null) {
                    this.actualLocale = newLocaleCountry;
                    key = "icons/flags/" + newLocaleCountry + ".png";
                    descriptor = JaspersoftStudioPlugin.getInstance().getImageDescriptor(key);
                    this.actualLocale = newLocaleCountry;
                }
                if (descriptor != null) {
                    return descriptor.getImageData();
                }
                return null;
            }

            public void modifyText(ModifyEvent e) {
                LocalesTranslationWizardPage.this.setAddButtonState();
                String newLocaleLang = LocalesTranslationWizardPage.this.localeSelector.getLangText();
                String newLocaleCountry = LocalesTranslationWizardPage.this.localeSelector.getCountryText();
                this.actualLocale = LocalesTranslationWizardPage.this.localeSelector.getActualLocaleImage();
                if (!newLocaleLang.equals(this.actualLocale) && !newLocaleCountry.equals(this.actualLocale)) {
                    LocalesTranslationWizardPage.this.localeSelector.updateImage(this.getImage(newLocaleLang, newLocaleCountry), this.actualLocale);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.imagesCache.dispose();
    }
}

