/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.utils.expr.AInterpreter;
import com.jaspersoft.studio.utils.expr.GroovyInterpretter;
import com.jaspersoft.studio.utils.expr.JavaInterpreter;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ExpressionInterpreter {
    private AInterpreter interpreter;
    private JasperReportsConfiguration jConfig;

    public ExpressionInterpreter(JRDesignDataset dataset, JasperReportsConfiguration jConfig) {
        this(dataset, jConfig.getJasperDesign(), jConfig);
    }

    public ExpressionInterpreter(JRDesignDataset dataset, JasperDesign jasperDesign, JasperReportsConfiguration jConfig) {
        try {
            this.jConfig = jConfig;
            if (jasperDesign.getLanguage().equalsIgnoreCase("java")) {
                this.interpreter = new JavaInterpreter();
            } else if (jasperDesign.getLanguage().equalsIgnoreCase("groovy")) {
                this.interpreter = new GroovyInterpretter();
            } else if (jasperDesign.getLanguage().equalsIgnoreCase("bsh")) {
                this.interpreter = new JavaInterpreter();
            }
            if (this.interpreter != null) {
                this.interpreter.prepareExpressionEvaluator(dataset, jasperDesign, jConfig);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JasperReportsConfiguration getJasperReportsConfiguration() {
        return this.jConfig;
    }

    public Object interpretExpression(String expression) {
        if (this.interpreter == null) {
            return null;
        }
        return this.interpreter.interpretExpression(expression);
    }
}

